/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.ITMScope;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.ui.TMImages;
import org.eclipse.tm4e.ui.internal.model.TMModelManager;
import org.eclipse.tm4e.ui.internal.samples.SampleManager;
import org.eclipse.tm4e.ui.internal.themes.ThemeManager;
import org.eclipse.tm4e.ui.internal.utils.CodeTemplateContextTypeUtils;
import org.eclipse.tm4e.ui.model.ITMModelManager;
import org.eclipse.tm4e.ui.samples.ISampleManager;
import org.eclipse.tm4e.ui.templates.TMLanguageTemplateContextType;
import org.eclipse.tm4e.ui.themes.ColorManager;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TMUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.tm4e.ui";
    private static final String TRACE_ID = "org.eclipse.tm4e.ui/trace";
    private static final String CUSTOM_TEMPLATES_KEY = "org.eclipse.tm4e.ui.text.templates.custom";
    private static final String TEMPLATES_REGISTRY_ID = "org.eclipse.tm4e.ui.templates";
    private static volatile @Nullable TMUIPlugin plugin;
    private @Nullable ContributionContextTypeRegistry contextTypeRegistry = null;
    private @Nullable TemplateStore templateStore = null;

    public static @Nullable TMUIPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        TMUIPlugin p = plugin;
        if (p != null) {
            p.getLog().log(status);
        } else {
            System.out.println(status);
        }
    }

    public static void logError(Exception ex) {
        TMUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, ex.getMessage(), (Throwable)ex));
    }

    public static void logTrace(Exception ex) {
        if (TMUIPlugin.isLogTraceEnabled()) {
            TMUIPlugin.log((IStatus)new Status(1, PLUGIN_ID, ex.getMessage(), (Throwable)ex));
        }
    }

    public static void logTrace(String message) {
        if (TMUIPlugin.isLogTraceEnabled()) {
            TMUIPlugin.log((IStatus)new Status(1, PLUGIN_ID, message));
        }
    }

    public static boolean isLogTraceEnabled() {
        return Boolean.parseBoolean(Platform.getDebugOption((String)TRACE_ID));
    }

    public static boolean getPreference(String key, boolean defaultValue) {
        return Platform.getPreferencesService().getBoolean(PLUGIN_ID, key, defaultValue, null);
    }

    public static @Nullable String getPreference(String key, @Nullable String defaultValue) {
        return Platform.getPreferencesService().getString(PLUGIN_ID, key, defaultValue, null);
    }

    public static ITMModelManager getTMModelManager() {
        return TMModelManager.INSTANCE;
    }

    public static IThemeManager getThemeManager() {
        return ThemeManager.getInstance();
    }

    public static ISampleManager getSampleManager() {
        return SampleManager.getInstance();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (TMUIPlugin.isLogTraceEnabled()) {
            String tm4eCorePluginId = "org.eclipse.tm4e.core";
            Logger tm4eCoreLogger = Logger.getLogger("org.eclipse.tm4e.core");
            tm4eCoreLogger.setLevel(Level.FINEST);
            tm4eCoreLogger.addHandler(new Handler(){

                @Override
                public void publish(@Nullable LogRecord entry) {
                    if (entry == null) {
                        return;
                    }
                    Object[] params = entry.getParameters();
                    String msg = entry.getMessage();
                    TMUIPlugin.log((IStatus)new Status(this.toSeverity(entry.getLevel()), "org.eclipse.tm4e.core", msg == null || params == null || params.length == 0 ? msg : MessageFormat.format(msg, entry.getParameters())));
                }

                private int toSeverity(Level level) {
                    if (level.intValue() >= Level.SEVERE.intValue()) {
                        return 4;
                    }
                    if (level.intValue() >= Level.WARNING.intValue()) {
                        return 2;
                    }
                    return 1;
                }

                @Override
                public void flush() {
                }

                @Override
                public void close() throws SecurityException {
                }
            });
        }
        TMImages.initalize(this.getImageRegistry());
    }

    public void stop(BundleContext context) throws Exception {
        if (this.templateStore != null) {
            this.templateStore.stopListeningForPreferenceChanges();
        }
        ColorManager.getInstance().dispose();
        plugin = null;
        super.stop(context);
    }

    public org.eclipse.text.templates.ContextTypeRegistry getTemplateContextRegistry() {
        IGrammarDefinition[] grammarDefinitions;
        ContributionContextTypeRegistry newContextTypeRegistry;
        ContributionContextTypeRegistry contextTypeRegistry = this.contextTypeRegistry;
        if (contextTypeRegistry != null) {
            return contextTypeRegistry;
        }
        this.contextTypeRegistry = newContextTypeRegistry = new ContributionContextTypeRegistry(TEMPLATES_REGISTRY_ID);
        newContextTypeRegistry.addContextType("org.eclipse.tm4e.ui.templates.context");
        newContextTypeRegistry.addContextType("org.eclipse.tm4e.ui.templates.context.comment");
        newContextTypeRegistry.addContextType("org.eclipse.tm4e.ui.templates.context.comment.doc");
        IGrammarDefinition[] iGrammarDefinitionArray = grammarDefinitions = TMEclipseRegistryPlugin.getGrammarRegistryManager().getDefinitions();
        int n = grammarDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            IGrammarDefinition definition = iGrammarDefinitionArray[n2];
            ITMScope languageScope = definition.getScope();
            String contextTypeName = CodeTemplateContextTypeUtils.toContextTypeName(languageScope);
            TMLanguageTemplateContextType languageContextType = new TMLanguageTemplateContextType(contextTypeName, languageScope);
            newContextTypeRegistry.addContextType((TemplateContextType)languageContextType);
            ++n2;
        }
        return newContextTypeRegistry;
    }

    public static ContextTypeRegistryWrapper from(org.eclipse.text.templates.ContextTypeRegistry registry) {
        return new ContextTypeRegistryWrapper(registry);
    }

    public TemplateStore getTemplateStore() {
        TemplateStore templateStore = this.templateStore;
        if (templateStore != null) {
            return templateStore;
        }
        ContributionTemplateStore newTemplateStore = new ContributionTemplateStore((ContextTypeRegistry)TMUIPlugin.from(this.getTemplateContextRegistry()), this.getPreferenceStore(), CUSTOM_TEMPLATES_KEY);
        this.templateStore = newTemplateStore;
        try {
            newTemplateStore.load();
        }
        catch (IOException e) {
            Platform.getLog(((Object)((Object)this)).getClass()).error(e.getMessage(), (Throwable)e);
        }
        newTemplateStore.startListeningForPreferenceChanges();
        return newTemplateStore;
    }

    private static class ContextTypeRegistryWrapper
    extends ContextTypeRegistry {
        private final org.eclipse.text.templates.ContextTypeRegistry delegate;

        public ContextTypeRegistryWrapper(org.eclipse.text.templates.ContextTypeRegistry registry) {
            this.delegate = registry;
        }

        public Iterator<TemplateContextType> contextTypes() {
            return this.delegate.contextTypes();
        }

        public void addContextType(TemplateContextType contextType) {
            this.delegate.addContextType(contextType);
        }

        public @Nullable TemplateContextType getContextType(String id) {
            return this.delegate.getContextType(id);
        }
    }
}

