/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.ls.core.internal.JDTUtils;

public class JdtDomModels {
    public static IBinding[] convertToBindings(ITypeBinding typeBinding, LspVariableBinding[] fields) {
        IBinding[] result;
        Set bindingKeys = Stream.of(fields).map(field -> field.bindingKey).collect(Collectors.toSet());
        IVariableBinding[] bindings = typeBinding.getDeclaredFields();
        ArrayList<IVariableBinding> fieldsToBindings = new ArrayList<IVariableBinding>();
        IVariableBinding[] iVariableBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding variableBinding = iVariableBindingArray[n2];
            if (!Modifier.isStatic((int)variableBinding.getModifiers())) {
                fieldsToBindings.add(variableBinding);
            }
            ++n2;
        }
        ITypeBinding superTypeBinding = typeBinding;
        while ((superTypeBinding = superTypeBinding.getSuperclass()) != null) {
            IVariableBinding[] iVariableBindingArray2 = superTypeBinding.getDeclaredFields();
            int n3 = iVariableBindingArray2.length;
            n = 0;
            while (n < n3) {
                IVariableBinding candidateField = iVariableBindingArray2[n];
                if (!(Modifier.isPrivate((int)candidateField.getModifiers()) || Modifier.isStatic((int)candidateField.getModifiers()) || JdtDomModels.contains(fieldsToBindings, candidateField))) {
                    fieldsToBindings.add(candidateField);
                }
                ++n;
            }
        }
        ArrayList<IMethodBinding> methodsToBindings = new ArrayList<IMethodBinding>();
        IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
        int n4 = iMethodBindingArray.length;
        int n5 = 0;
        while (n5 < n4) {
            IMethodBinding candidateMethod = iMethodBindingArray[n5];
            if (!(Modifier.isStatic((int)candidateMethod.getModifiers()) || candidateMethod.getParameterTypes().length != 0 || "void".equals(candidateMethod.getReturnType().getName()) || "toString".equals(candidateMethod.getName()) || "clone".equals(candidateMethod.getName()))) {
                methodsToBindings.add(candidateMethod);
            }
            ++n5;
        }
        superTypeBinding = typeBinding;
        while ((superTypeBinding = superTypeBinding.getSuperclass()) != null) {
            iMethodBindingArray = superTypeBinding.getDeclaredMethods();
            n4 = iMethodBindingArray.length;
            n5 = 0;
            while (n5 < n4) {
                IMethodBinding candidateMethod = iMethodBindingArray[n5];
                if (!(Modifier.isPrivate((int)candidateMethod.getModifiers()) || Modifier.isStatic((int)candidateMethod.getModifiers()) || candidateMethod.getParameterTypes().length != 0 || "void".equals(candidateMethod.getReturnType().getName()) || JdtDomModels.contains(methodsToBindings, candidateMethod) || "clone".equals(candidateMethod.getName()))) {
                    methodsToBindings.add(candidateMethod);
                }
                ++n5;
            }
        }
        IBinding[] fieldsMembers = (IBinding[])fieldsToBindings.stream().sorted(new BindingComparator()).filter(f -> bindingKeys.contains(f.getKey())).toArray(IVariableBinding[]::new);
        IBinding[] methodsMembers = (IBinding[])methodsToBindings.stream().sorted(new BindingComparator()).filter(f -> bindingKeys.contains(f.getKey())).toArray(IMethodBinding[]::new);
        if (methodsMembers.length == 0) {
            result = fieldsMembers;
        } else if (fieldsMembers.length == 0) {
            result = methodsMembers;
        } else {
            result = new IBinding[fieldsMembers.length + methodsMembers.length];
            System.arraycopy(fieldsMembers, 0, result, 0, fieldsMembers.length);
            System.arraycopy(methodsMembers, 0, result, fieldsMembers.length, methodsMembers.length);
        }
        return result;
    }

    public static IVariableBinding[] convertToVariableBindings(ITypeBinding typeBinding, LspVariableBinding[] fields) {
        Set bindingKeys = Stream.of(fields).map(field -> field.bindingKey).collect(Collectors.toSet());
        IVariableBinding[] bindings = typeBinding.getDeclaredFields();
        ArrayList<IVariableBinding> members = new ArrayList<IVariableBinding>();
        IVariableBinding[] iVariableBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding variableBinding = iVariableBindingArray[n2];
            if (!Modifier.isStatic((int)variableBinding.getModifiers())) {
                members.add(variableBinding);
            }
            ++n2;
        }
        return (IVariableBinding[])members.stream().sorted(new BindingComparator()).filter(f -> bindingKeys.contains(f.getKey())).toArray(IVariableBinding[]::new);
    }

    public static <T extends IBinding> boolean contains(List<T> inheritedFields, T member) {
        for (IBinding object : inheritedFields) {
            if (object instanceof IVariableBinding && member instanceof IVariableBinding && ((IVariableBinding)object).getName().equals(((IVariableBinding)member).getName())) {
                return true;
            }
            if (!(object instanceof IMethodBinding) || !(member instanceof IMethodBinding) || !((IMethodBinding)object).getName().equals(((IMethodBinding)member).getName())) continue;
            return true;
        }
        return false;
    }

    public static LspVariableBinding[] getDeclaredFields(ITypeBinding typeBinding, boolean includeStatic) {
        return (LspVariableBinding[])Arrays.stream(typeBinding.getDeclaredFields()).sorted(new BindingComparator()).filter(f -> includeStatic || !Modifier.isStatic((int)f.getModifiers())).map(f -> new LspVariableBinding((IVariableBinding)f)).toArray(LspVariableBinding[]::new);
    }

    public static class BindingComparator
    implements Comparator<IBinding> {
        @Override
        public int compare(IBinding a, IBinding b) {
            try {
                ISourceRange nameRangeB;
                ISourceRange nameRangeA = a.getJavaElement() == null ? null : JDTUtils.getNameRange(a.getJavaElement());
                ISourceRange iSourceRange = nameRangeB = b.getJavaElement() == null ? null : JDTUtils.getNameRange(b.getJavaElement());
                if (nameRangeA != null && nameRangeB != null) {
                    return nameRangeA.getOffset() - nameRangeB.getOffset();
                }
                return 0;
            }
            catch (JavaModelException e) {
                return 0;
            }
        }
    }

    public static class LspMethodBinding {
        public String bindingKey;
        public String name;
        public String[] parameters;

        public LspMethodBinding(IMethodBinding binding) {
            this.bindingKey = binding.getKey();
            this.name = binding.getName();
            this.parameters = (String[])Stream.of(binding.getParameterTypes()).map(type -> type.getName()).toArray(String[]::new);
        }
    }

    public static class LspVariableBinding {
        public String bindingKey;
        public String name;
        public String type;
        public boolean isField;
        public boolean isSelected;
        public String[] parameters;

        public LspVariableBinding(IVariableBinding binding) {
            this(binding, false);
        }

        public LspVariableBinding(IVariableBinding binding, boolean isSelected) {
            this.bindingKey = binding.getKey();
            this.name = binding.getName();
            this.type = binding.getType().getName();
            this.isField = binding.isField();
            this.isSelected = isSelected;
        }

        public LspVariableBinding(IMethodBinding binding) {
            this(binding, false);
        }

        public LspVariableBinding(IMethodBinding binding, boolean isSelected) {
            this.bindingKey = binding.getKey();
            this.name = binding.getName();
            this.type = binding.getReturnType().getName();
            this.isField = false;
            this.parameters = (String[])Stream.of(binding.getParameterTypes()).map(type -> type.getName()).toArray(String[]::new);
            this.isSelected = isSelected;
        }
    }
}

