/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.template.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corext.template.java.InnerExpressionResolver;
import org.eclipse.jdt.ls.core.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.ls.core.internal.corext.template.java.JavaPostfixContextType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class JavaPostfixContext
extends JavaContext {
    private static final Object CONTEXT_TYPE_ID = "postfix";
    private static final String OBJECT_SIGNATURE = "java.lang.Object";
    private static final String ID_SEPARATOR = "\ufffd\ufffd";
    private static final Pattern INNER_EXPRESSION_PATTERN = Pattern.compile("\\$\\{([a-zA-Z]*):inner_expression\\(([^\\$|\\{|\\}]*)\\)\\}");
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9$_\\.]+");
    private ASTNode selectedNode;
    private Map<ASTNode, Region> nodeRegions;
    private Map<TemplateVariable, int[]> variableOutOfRangeOffsets;
    private boolean domInitialized;
    private BodyDeclaration bodyDeclaration;
    private ASTNode parentDeclaration;
    private CompletionContext completionCtx;
    private Map<String, List<TextEdit>> additionalTextEdits;
    private String activeTemplateName;

    public JavaPostfixContext(JavaPostfixContextType type, IDocument document, int offset, int length, ICompilationUnit compilationUnit, ASTNode currentNode, ASTNode parentNode, CompletionContext context) {
        super((TemplateContextType)type, document, offset, length, compilationUnit);
        this.completionCtx = context;
        this.nodeRegions = new HashMap<ASTNode, Region>();
        this.variableOutOfRangeOffsets = new HashMap<TemplateVariable, int[]>();
        this.nodeRegions.put(currentNode, this.calculateNodeRegion(currentNode));
        this.nodeRegions.put(parentNode, this.calculateNodeRegion(parentNode));
        this.selectedNode = this.findBestASTNodeSelection(currentNode);
        this.additionalTextEdits = new HashMap<String, List<TextEdit>>();
    }

    private ASTNode findBestASTNodeSelection(ASTNode currentNode) {
        ASTNode result = currentNode;
        int currMax = this.getNodeBegin(currentNode) + this.getNodeLength(currentNode);
        Set<ASTNode> nodes = this.nodeRegions.keySet();
        int tokenLength = this.completionCtx != null && this.completionCtx.getToken() != null ? this.completionCtx.getToken().length : 0;
        int invOffset = this.completionCtx != null ? this.completionCtx.getOffset() - tokenLength - 1 : this.getCompletionOffset();
        for (ASTNode n : nodes) {
            int end = this.getNodeBegin(n) + this.getNodeLength(n);
            if (end <= currMax || end > invOffset) continue;
            currMax = end;
            result = n;
        }
        return result;
    }

    public TextEdit addField(String type, String varName, boolean publicField, boolean staticField, boolean finalField, String value) {
        int modifiers;
        if (this.isReadOnly()) {
            return null;
        }
        if (!this.domInitialized) {
            this.initDomAST();
        }
        boolean isStatic = this.isBodyStatic();
        int n = modifiers = !publicField ? 2 : 1;
        if (isStatic || staticField) {
            modifiers |= 8;
        }
        if (finalField) {
            modifiers |= 0x10;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)this.parentDeclaration.getAST());
        this.addFieldDeclaration(rewrite, this.parentDeclaration, modifiers, varName, type, value);
        TextEdit te = rewrite.rewriteAST(this.getDocument(), null);
        return te;
    }

    private VariableDeclarationFragment addFieldDeclaration(ASTRewrite rewrite, ASTNode newTypeDecl, int modifiers, String varName, String qualifiedName, String value) {
        ChildListPropertyDescriptor property = ASTNodes.getBodyDeclarationsProperty((ASTNode)newTypeDecl);
        List decls = ASTNodes.getBodyDeclarations((ASTNode)newTypeDecl);
        AST ast = newTypeDecl.getAST();
        VariableDeclarationFragment newDeclFrag = ast.newVariableDeclarationFragment();
        newDeclFrag.setName(ast.newSimpleName(varName));
        Type type = this.createType(Signature.createTypeSignature((String)qualifiedName, (boolean)true), ast);
        if (value != null && value.trim().length() > 0) {
            Expression e = this.createExpression(value);
            Expression ne = (Expression)ASTNode.copySubtree((AST)ast, (ASTNode)e);
            newDeclFrag.setInitializer(ne);
        } else if (Modifier.isStatic((int)modifiers) && Modifier.isFinal((int)modifiers)) {
            newDeclFrag.setInitializer(ASTNodeFactory.newDefaultExpression((AST)ast, (Type)type, (int)0));
        }
        FieldDeclaration newDecl = ast.newFieldDeclaration(newDeclFrag);
        newDecl.setType(type);
        newDecl.modifiers().addAll(ASTNodeFactory.newModifiers((AST)ast, (int)modifiers));
        int insertIndex = this.findFieldInsertIndex(decls, this.getCompletionOffset(), modifiers);
        rewrite.getListRewrite(newTypeDecl, property).insertAt((ASTNode)newDecl, insertIndex, null);
        return newDeclFrag;
    }

    public String addImportGenericClass(String className) {
        Matcher m = CLASS_NAME_PATTERN.matcher(className);
        ArrayList<String> classNames = new ArrayList<String>();
        HashMap<String, String> classNameMapping = new HashMap<String, String>();
        while (m.find()) {
            classNames.add(className.substring(m.start(), m.end()));
        }
        Collections.sort(classNames, (arg0, arg1) -> arg1.length() - arg0.length());
        int i = 0;
        while (i < classNames.size()) {
            className = className.replace((CharSequence)classNames.get(i), ID_SEPARATOR + i + ID_SEPARATOR);
            classNameMapping.put((String)classNames.get(i), this.addImport((String)classNames.get(i)));
            ++i;
        }
        i = 0;
        while (i < classNames.size()) {
            className = className.replace(ID_SEPARATOR + i + ID_SEPARATOR, (CharSequence)classNameMapping.get(classNames.get(i)));
            ++i;
        }
        return className;
    }

    public boolean applyTextEdit(TextEdit te) {
        try {
            te.apply(this.getDocument());
            this.setCompletionOffset(this.getCompletionOffset() + (te.getOffset() < this.getCompletionOffset() ? te.getLength() : 0));
            return true;
        }
        catch (BadLocationException | MalformedTreeException throwable) {
            return false;
        }
    }

    private Region calculateNodeRegion(ASTNode node) {
        if (node == null) {
            return new Region(0, 0);
        }
        int start = this.getNodeBegin(node);
        int end = this.getCompletionOffset() - this.getPrefixKey().length() - start - 1;
        return new Region(start, end);
    }

    public boolean canEvaluate(Template template) {
        IBinding binding;
        if (!template.getContextTypeId().equals(CONTEXT_TYPE_ID)) {
            return false;
        }
        if (this.isForceEvaluation()) {
            return true;
        }
        if (this.selectedNode == null || this.selectedNode instanceof Javadoc) {
            return false;
        }
        if (!template.getName().toLowerCase().startsWith(this.getPrefixKey().toLowerCase())) {
            return false;
        }
        if (this.selectedNode instanceof SimpleName && !((binding = ((SimpleName)this.selectedNode).resolveBinding()) instanceof IVariableBinding) && binding != null && !binding.isRecovered()) {
            return false;
        }
        Matcher matcher = INNER_EXPRESSION_PATTERN.matcher(template.getPattern());
        boolean result = true;
        while (matcher.find()) {
            String[] types;
            String[] stringArray = types = matcher.group(2).split(",");
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!Arrays.asList(InnerExpressionResolver.FLAGS).contains(s)) {
                    result = false;
                    if (this.isNodeResolvingTo(this.selectedNode, s.trim())) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean containsNestedCapture(String signature) {
        return signature.length() > 1 && signature.indexOf(33, 1) != -1;
    }

    private Expression createExpression(String expr) {
        ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        parser.setKind(1);
        parser.setResolveBindings(true);
        parser.setSource(expr.toCharArray());
        ASTNode astNode = parser.createAST((IProgressMonitor)new NullProgressMonitor());
        return (Expression)astNode;
    }

    private Type createType(String typeSig, AST ast) {
        int sigKind = Signature.getTypeSignatureKind((String)typeSig);
        switch (sigKind) {
            case 2: {
                return ast.newPrimitiveType(PrimitiveType.toCode((String)Signature.toString((String)typeSig)));
            }
            case 4: {
                Type elementType = this.createType(Signature.getElementType((String)typeSig), ast);
                return ast.newArrayType(elementType, Signature.getArrayCount((String)typeSig));
            }
            case 1: {
                String erasureSig = Signature.getTypeErasure((String)typeSig);
                String erasureName = Signature.toString((String)erasureSig);
                if (erasureSig.charAt(0) == 'L') {
                    erasureName = this.addImport(erasureName);
                }
                SimpleType baseType = ast.newSimpleType(ast.newName(erasureName));
                String[] typeArguments = Signature.getTypeArguments((String)typeSig);
                if (typeArguments.length > 0) {
                    ParameterizedType type = ast.newParameterizedType((Type)baseType);
                    List argNodes = type.typeArguments();
                    String[] stringArray = typeArguments;
                    int n = typeArguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String curr = stringArray[n2];
                        if (this.containsNestedCapture(curr)) {
                            argNodes.add(ast.newWildcardType());
                        } else {
                            argNodes.add(this.createType(curr, ast));
                        }
                        ++n2;
                    }
                    return type;
                }
                return baseType;
            }
            case 3: {
                return ast.newSimpleType((Name)ast.newSimpleName(Signature.toString((String)typeSig)));
            }
            case 5: {
                WildcardType wildcardType = ast.newWildcardType();
                char ch = typeSig.charAt(0);
                if (ch != '*') {
                    Type bound = this.createType(typeSig.substring(1), ast);
                    wildcardType.setBound(bound, ch == '+');
                }
                return wildcardType;
            }
            case 6: {
                return this.createType(typeSig.substring(1), ast);
            }
        }
        return ast.newSimpleType(ast.newName(OBJECT_SIGNATURE));
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        TemplateBuffer result = super.evaluate(template);
        TemplateVariable[] templateVariableArray = result.getVariables();
        int n = templateVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable tv = templateVariableArray[n2];
            int[] outOfRangeOffsets = this.variableOutOfRangeOffsets.get(tv);
            if (outOfRangeOffsets != null && outOfRangeOffsets.length > 0) {
                int[] offsets = tv.getOffsets();
                int[] newOffsets = Arrays.copyOf(offsets, offsets.length + outOfRangeOffsets.length);
                System.arraycopy(outOfRangeOffsets, 0, newOffsets, offsets.length, outOfRangeOffsets.length);
                tv.setOffsets(newOffsets);
            }
            ++n2;
        }
        return result;
    }

    private int findFieldInsertIndex(List<BodyDeclaration> decls, int currPos, int modifiers) {
        int i = decls.size() - 1;
        while (i >= 0) {
            ASTNode curr = (ASTNode)decls.get(i);
            if (curr instanceof FieldDeclaration && currPos > curr.getStartPosition() + curr.getLength() && ((FieldDeclaration)curr).getModifiers() == modifiers) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    public Region getAffectedSourceRegion() {
        return new Region(this.getCompletionOffset() - this.getPrefixKey().length() - this.nodeRegions.get(this.selectedNode).getLength() - 1, this.nodeRegions.get(this.selectedNode).getLength());
    }

    public String getAffectedStatement() {
        Region r = this.getAffectedSourceRegion();
        try {
            return this.getDocument().get(r.getOffset(), r.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public int getEnd() {
        return this.getCompletionOffset();
    }

    public String getInnerExpressionTypeSignature() {
        return this.resolveNodeToTypeString(this.selectedNode);
    }

    protected int getNodeBegin(ASTNode node) {
        if (node == null) {
            return -1;
        }
        if (node.getParent() instanceof MethodInvocation) {
            return ((MethodInvocation)node.getParent()).getStartPosition();
        }
        if (node.getParent() instanceof FieldAccess || node.getParent() instanceof SuperFieldAccess) {
            return node.getParent().getStartPosition();
        }
        if (node instanceof Name) {
            ASTNode n = node;
            while (n.getParent() instanceof QualifiedName) {
                n = n.getParent();
            }
            return ((Name)n).getStartPosition();
        }
        return node.getStartPosition();
    }

    protected int getNodeLength(ASTNode node) {
        if (node == null) {
            return -1;
        }
        return node.getLength();
    }

    private String getPrefixKey() {
        if (this.completionCtx != null) {
            IDocument document = this.getDocument();
            int start = this.completionCtx.getTokenStart();
            int end = this.completionCtx.getTokenEnd();
            try {
                return document.get(start, end - start + 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return "";
    }

    public int getStart() {
        int result = super.getStart();
        return result -= this.getAffectedSourceRegion().getLength() + 1;
    }

    private void initDomAST() {
        if (this.isReadOnly()) {
            return;
        }
        ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        parser.setSource(this.getCompilationUnit());
        parser.setResolveBindings(true);
        ASTNode domAst = parser.createAST((IProgressMonitor)new NullProgressMonitor());
        NodeFinder nf = new NodeFinder(domAst, this.getCompletionOffset(), 1);
        ASTNode cv = nf.getCoveringNode();
        this.bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)cv);
        this.parentDeclaration = ASTResolving.findParentType((ASTNode)cv);
        this.domInitialized = true;
    }

    private boolean isNodeResolvingTo(ASTNode node, String signature) {
        if (signature == null || signature.trim().length() == 0) {
            return true;
        }
        ITypeBinding tb = this.resolveNodeToBinding(node);
        if (tb != null && tb.isPrimitive()) {
            return new String(tb.getQualifiedName()).equals(signature);
        }
        return this.resolvesReferenceBindingTo(tb, signature);
    }

    private boolean isBodyStatic() {
        boolean isAnonymous = this.parentDeclaration.getNodeType() == 1;
        boolean isStatic = Modifier.isStatic((int)this.bodyDeclaration.getModifiers()) && !isAnonymous;
        return isStatic;
    }

    public void registerOutOfRangeOffset(TemplateVariable var, int absoluteOffset) {
        if (this.variableOutOfRangeOffsets.get(var) == null) {
            this.variableOutOfRangeOffsets.put(var, new int[]{absoluteOffset});
        } else {
            int[] temp = this.variableOutOfRangeOffsets.get(var);
            int[] newArr = new int[temp.length + 1];
            System.arraycopy(temp, 0, newArr, 0, temp.length);
            newArr[temp.length] = absoluteOffset;
            this.variableOutOfRangeOffsets.put(var, newArr);
        }
    }

    private ITypeBinding resolveNodeToBinding(ASTNode node) {
        if (node instanceof StringLiteral) {
            return ((StringLiteral)node).resolveTypeBinding();
        }
        final ITypeBinding[] res = new ITypeBinding[1];
        node.accept(new ASTVisitor(){

            public boolean visit(MethodInvocation n) {
                res[0] = n.resolveTypeBinding();
                return false;
            }

            public boolean visit(SimpleName n) {
                IBinding b = n.resolveBinding();
                if (b instanceof IVariableBinding) {
                    IVariableBinding vb = (IVariableBinding)b;
                    res[0] = vb.getType();
                } else if (b instanceof IMethodBinding) {
                    IMethodBinding mb = (IMethodBinding)b;
                    res[0] = mb.getReturnType();
                }
                return false;
            }

            public boolean visit(QualifiedName n) {
                IBinding b = n.resolveBinding();
                if (b instanceof IVariableBinding) {
                    IVariableBinding vb = (IVariableBinding)b;
                    res[0] = vb.getType();
                }
                return false;
            }

            public boolean visit(FieldAccess n) {
                ITypeBinding tmp = n.getName().resolveTypeBinding();
                if (tmp != null) {
                    res[0] = tmp;
                    return false;
                }
                res[0] = n.getExpression().resolveTypeBinding();
                return false;
            }

            public boolean visit(Assignment n) {
                ITypeBinding tmp = n.getLeftHandSide().resolveTypeBinding();
                if (tmp != null) {
                    res[0] = tmp;
                    return false;
                }
                return true;
            }

            public boolean visit(BooleanLiteral n) {
                res[0] = n.resolveTypeBinding();
                return false;
            }

            public boolean visit(InfixExpression n) {
                res[0] = n.resolveTypeBinding();
                return false;
            }

            public boolean visit(ClassInstanceCreation n) {
                res[0] = n.resolveTypeBinding();
                return false;
            }

            public boolean visit(ArrayAccess n) {
                res[0] = n.resolveTypeBinding();
                return false;
            }
        });
        return res[0] != null ? res[0] : null;
    }

    private String resolveNodeToTypeString(ASTNode node) {
        ITypeBinding b = this.resolveNodeToBinding(node);
        if (b == null) {
            return OBJECT_SIGNATURE;
        }
        String result = b.getQualifiedName();
        if (result.isEmpty() && b.isCapture()) {
            ITypeBinding[] iTypeBindingArray = b.getTypeBounds();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding tb = iTypeBindingArray[n2];
                result = tb.getQualifiedName();
                if (!result.isEmpty()) {
                    return result;
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean resolvesReferenceBindingTo(ITypeBinding sb, String signature) {
        if (sb == null) {
            return false;
        }
        if (new String(sb.getQualifiedName()).startsWith(signature) || sb.isArray() && "array".equals(signature)) {
            return true;
        }
        if (Object.class.getName().equals(signature)) {
            return true;
        }
        ArrayList<ITypeBinding> bindings = new ArrayList<ITypeBinding>();
        Collections.addAll(bindings, sb.getInterfaces());
        bindings.add(sb.getSuperclass());
        boolean result = false;
        Iterator it = bindings.iterator();
        while (it.hasNext() && !result) {
            result = this.resolvesReferenceBindingTo((ITypeBinding)it.next(), signature);
        }
        return result;
    }

    public String[] suggestFieldName(String type, String[] excludes, boolean staticField, boolean finalField) throws IllegalArgumentException {
        int dim = 0;
        while (type.endsWith("[]")) {
            ++dim;
            type = type.substring(0, type.length() - 2);
        }
        IJavaProject project = this.getJavaProject();
        int namingConventions = 0;
        namingConventions = staticField && finalField ? 3 : (staticField && !finalField ? 1 : 2);
        if (project != null) {
            return StubUtility.getVariableNameSuggestions((int)namingConventions, (IJavaProject)project, (String)type, (int)dim, Arrays.asList(excludes), (boolean)true);
        }
        return new String[]{Signature.getSimpleName((String)type).toLowerCase()};
    }

    public String[] suggestFieldName(String type, boolean finalField, boolean forceStatic) {
        if (!this.domInitialized) {
            this.initDomAST();
        }
        if (this.domInitialized) {
            return this.suggestFieldName(type, ASTResolving.getUsedVariableNames((ASTNode)this.bodyDeclaration), forceStatic ? forceStatic : this.isBodyStatic(), finalField);
        }
        return new String[]{"newField"};
    }

    public String[] suggestVariableNames(String type) throws IllegalArgumentException {
        ArrayList<String> res = new ArrayList<String>();
        if (this.selectedNode instanceof Expression) {
            ITypeBinding tb = this.resolveNodeToBinding(this.selectedNode);
            List<String> excludes = Arrays.asList(this.computeExcludes());
            String[] names = StubUtility.getVariableNameSuggestions((int)5, (IJavaProject)this.getJavaProject(), (ITypeBinding)tb, (Expression)((Expression)this.selectedNode), excludes);
            res.addAll(Arrays.asList(names));
        }
        res.addAll(Arrays.asList(super.suggestVariableNames(type)));
        return res.toArray(new String[0]);
    }

    public List<TextEdit> getAdditionalTextEdits(String name) {
        return this.additionalTextEdits.get(name);
    }

    public void setActiveTemplateName(String activeTemplateName) {
        this.activeTemplateName = activeTemplateName;
    }

    public String addImport(String type) {
        ICompilationUnit cu = this.getCompilationUnit();
        if (cu == null) {
            return type;
        }
        try {
            boolean qualified;
            boolean bl = qualified = type.indexOf(46) != -1;
            if (!qualified) {
                return type;
            }
            CompilationUnit root = this.getASTRoot(cu);
            ImportRewrite importRewrite = root == null ? StubUtility.createImportRewrite((ICompilationUnit)cu, (boolean)true) : StubUtility.createImportRewrite((CompilationUnit)root, (boolean)true);
            ContextSensitiveImportRewriteContext context = root == null ? null : new ContextSensitiveImportRewriteContext(root, this.getCompletionOffset(), importRewrite);
            String typeName = importRewrite.addImport(type, context);
            if (StringUtils.isNotBlank((CharSequence)this.activeTemplateName)) {
                List edits = this.additionalTextEdits.getOrDefault(this.activeTemplateName, new ArrayList());
                try {
                    edits.add(importRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()));
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.log(e);
                }
                this.additionalTextEdits.put(this.activeTemplateName, edits);
            }
            return typeName;
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.log((CoreException)((Object)e));
            return type;
        }
    }

    private CompilationUnit getASTRoot(ICompilationUnit compilationUnit) {
        return SharedASTProviderCore.getAST((ITypeRoot)compilationUnit, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_NO, (IProgressMonitor)new NullProgressMonitor());
    }
}

