/*
 * Decompiled with CFR 0.152.
 */
package com.github.badsyntax.gradle.process;

import com.github.badsyntax.gradle.exceptions.ProcessException;
import com.github.badsyntax.gradle.process.ProcessOutput;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Process
implements AutoCloseable {
    public static final Boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase().contains("windows");
    private static Runtime runtime = Runtime.getRuntime();
    private File workingDir;
    private String windowsCommand;
    private String unixCommand;
    private ProcessOutput processOutput;

    public Process(File workingDir) {
        this.workingDir = workingDir;
    }

    public synchronized void setWindowsCommand(String command) {
        this.windowsCommand = command;
    }

    public synchronized void setUnixCommand(String command) {
        this.unixCommand = command;
    }

    public static synchronized void kill(String pid) throws IOException {
        if (Boolean.TRUE.equals(IS_WINDOWS)) {
            runtime.exec(String.format("taskkill /f /pid %s", pid));
        } else {
            runtime.exec(String.format("kill -9 %s", pid));
        }
    }

    public synchronized void exec(String ... args) throws IOException, ProcessException {
        ProcessBuilder processBuilder = new ProcessBuilder(this.buildCommand(args));
        processBuilder.directory(this.workingDir);
        Map<String, String> env = processBuilder.environment();
        env.put("JAVA_HOME", System.getProperty("java.home"));
        java.lang.Process process = processBuilder.start();
        this.processOutput = new ProcessOutput(new BufferedReader(new InputStreamReader(process.getInputStream())), new BufferedReader(new InputStreamReader(process.getErrorStream())));
    }

    private synchronized List<String> buildCommand(String[] args) throws ProcessException {
        String command;
        String string = command = Boolean.TRUE.equals(IS_WINDOWS) ? this.windowsCommand : this.unixCommand;
        if (command == null) {
            throw new ProcessException("No command is set");
        }
        Path commandPath = Paths.get(this.workingDir.getAbsolutePath(), command);
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(commandPath.toAbsolutePath().toString());
        commandList.addAll(Arrays.asList(args));
        return commandList;
    }

    public synchronized ProcessOutput getProcessOutput() {
        return this.processOutput;
    }

    @Override
    public synchronized void close() throws IOException {
        this.processOutput.close();
    }
}

