/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support.conversion;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.platform.commons.support.conversion.StringToObjectConverter;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

class FallbackStringToObjectConverter
implements StringToObjectConverter {
    private static final Function<String, Object> NULL_EXECUTABLE = source -> source;
    private static final ConcurrentHashMap<Class<?>, Function<String, Object>> factoryExecutableCache = new ConcurrentHashMap(64);

    FallbackStringToObjectConverter() {
    }

    @Override
    public boolean canConvertTo(Class<?> targetType) {
        return FallbackStringToObjectConverter.findFactoryExecutable(targetType) != NULL_EXECUTABLE;
    }

    @Override
    public Object convert(String source, Class<?> targetType) throws Exception {
        Function<String, Object> executable = FallbackStringToObjectConverter.findFactoryExecutable(targetType);
        Preconditions.condition(executable != NULL_EXECUTABLE, "Illegal state: convert() must not be called if canConvert() returned false");
        return executable.apply(source);
    }

    private static Function<String, Object> findFactoryExecutable(Class<?> targetType) {
        return factoryExecutableCache.computeIfAbsent(targetType, type -> {
            Method factoryMethod = FallbackStringToObjectConverter.findFactoryMethod(type);
            if (factoryMethod != null) {
                return source -> ReflectionUtils.invokeMethod(factoryMethod, null, source);
            }
            Constructor<?> constructor = FallbackStringToObjectConverter.findFactoryConstructor(type);
            if (constructor != null) {
                return source -> ReflectionUtils.newInstance(constructor, source);
            }
            return NULL_EXECUTABLE;
        });
    }

    private static Method findFactoryMethod(Class<?> targetType) {
        List<Method> factoryMethods = ReflectionUtils.findMethods(targetType, new IsFactoryMethod(targetType), ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP);
        if (factoryMethods.size() == 1) {
            return factoryMethods.get(0);
        }
        return null;
    }

    private static Constructor<?> findFactoryConstructor(Class<?> targetType) {
        List<Constructor<?>> constructors = ReflectionUtils.findConstructors(targetType, new IsFactoryConstructor(targetType));
        if (constructors.size() == 1) {
            return constructors.get(0);
        }
        return null;
    }

    private static boolean isNotPrivateAndAcceptsSingleStringArgument(Executable executable) {
        return ReflectionUtils.isNotPrivate(executable) && executable.getParameterCount() == 1 && executable.getParameterTypes()[0] == String.class;
    }

    static class IsFactoryMethod
    implements Predicate<Method> {
        private final Class<?> targetType;

        IsFactoryMethod(Class<?> targetType) {
            this.targetType = targetType;
        }

        @Override
        public boolean test(Method method) {
            if (!method.getReturnType().equals(this.targetType)) {
                return false;
            }
            if (ReflectionUtils.isNotStatic(method)) {
                return false;
            }
            return FallbackStringToObjectConverter.isNotPrivateAndAcceptsSingleStringArgument(method);
        }
    }

    static class IsFactoryConstructor
    implements Predicate<Constructor<?>> {
        private final Class<?> targetType;

        IsFactoryConstructor(Class<?> targetType) {
            this.targetType = targetType;
        }

        @Override
        public boolean test(Constructor<?> constructor) {
            if (!constructor.getDeclaringClass().equals(this.targetType)) {
                return false;
            }
            return FallbackStringToObjectConverter.isNotPrivateAndAcceptsSingleStringArgument(constructor);
        }
    }
}

