/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.configuration.RunConfiguration;
import org.eclipse.buildship.core.internal.gradle.GradleProgressAttributes;
import org.eclipse.buildship.core.internal.util.gradle.CompatEclipseProject;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.EclipseProjectNature;

public final class RunOnImportTasksOperation {
    private static final String WTP_TASK = "eclipseWtp";
    private static final String CLEAN_WTP_TASK = "cleanEclipseWtp";
    private static final String WTP_COMPONENT_NATURE = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
    private final BuildConfiguration buildConfig;
    private final Set<EclipseProject> allprojects;

    public RunOnImportTasksOperation(Set<? extends EclipseProject> allProjects, BuildConfiguration buildConfig) {
        this.allprojects = ImmutableSet.copyOf(allProjects);
        this.buildConfig = (BuildConfiguration)Preconditions.checkNotNull((Object)buildConfig);
    }

    public void run(IProgressMonitor monitor, CancellationTokenSource tokenSource) throws CoreException {
        List<String> tasksToRun = this.findWtpTasks();
        if (!tasksToRun.isEmpty()) {
            this.runTasks(tasksToRun, monitor, tokenSource);
        }
    }

    private List<String> findWtpTasks() {
        if (!CorePlugin.workspaceOperations().isNatureRecognizedByEclipse(WTP_COMPONENT_NATURE)) {
            return Collections.emptyList();
        }
        HashSet cleanWtpTasks = Sets.newHashSet();
        HashSet wtpTasks = Sets.newHashSet();
        for (EclipseProject eclipseProject : this.allprojects) {
            if (!this.isGradle30(eclipseProject) || !this.isWtpProject(eclipseProject) || this.isIncludedProject(eclipseProject)) continue;
            DomainObjectSet tasks = eclipseProject.getGradleProject().getTasks();
            for (GradleTask task : tasks) {
                if (WTP_TASK.equals(task.getName())) {
                    wtpTasks.add(task.getPath());
                    continue;
                }
                if (!CLEAN_WTP_TASK.equals(task.getName())) continue;
                cleanWtpTasks.add(task.getPath());
            }
        }
        return ImmutableList.builder().addAll((Iterable)cleanWtpTasks).addAll((Iterable)wtpTasks).build();
    }

    private boolean isGradle30(EclipseProject eclipseProject) {
        return CompatEclipseProject.supportsClasspathContainers(eclipseProject);
    }

    private boolean isWtpProject(EclipseProject eclipseProject) {
        for (EclipseProjectNature nature : eclipseProject.getProjectNatures()) {
            if (!nature.getId().equals(WTP_COMPONENT_NATURE)) continue;
            return true;
        }
        return false;
    }

    private boolean isIncludedProject(EclipseProject eclipseProject) {
        File projectRoot;
        File buildRoot = this.buildConfig.getRootProjectDirectory();
        return !buildRoot.equals(projectRoot = eclipseProject.getProjectIdentifier().getBuildIdentifier().getRootDir());
    }

    private void runTasks(List<String> tasksToRun, IProgressMonitor monitor, CancellationTokenSource tokenSource) {
        RunConfiguration runConfiguration = CorePlugin.configurationManager().createDefaultRunConfiguration(this.buildConfig);
        InternalGradleBuild gradleBuild = CorePlugin.internalGradleWorkspace().getGradleBuild(this.buildConfig);
        GradleProgressAttributes progressAttributes = GradleProgressAttributes.builder(tokenSource, gradleBuild, monitor).forBackgroundProcess().withFilteredProgress().build();
        BuildLauncher launcher = gradleBuild.newBuildLauncher(runConfiguration, progressAttributes);
        launcher.forTasks(tasksToRun.toArray(new String[tasksToRun.size()])).run();
    }
}

