/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.collections;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public final class CollectionsUtils {
    private static final char SPACE = ' ';
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private CollectionsUtils() {
    }

    public static ImmutableList<String> splitBySpace(String string) {
        return Strings.isNullOrEmpty((String)string) ? ImmutableList.of() : ImmutableList.copyOf((Collection)Splitter.on((char)' ').omitEmptyStrings().splitToList((CharSequence)string));
    }

    public static String joinWithSpace(List<String> elements) {
        return Joiner.on((char)' ').join(elements);
    }

    public static String[] nullToEmpty(String[] array) {
        return array == null ? EMPTY_STRING_ARRAY : array;
    }
}

