/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.reporter;

import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.StatusCode;
import ch.epfl.scala.bsp4j.TaskFinishParams;
import ch.epfl.scala.bsp4j.TaskId;
import ch.epfl.scala.bsp4j.TaskProgressParams;
import ch.epfl.scala.bsp4j.TaskStartParams;
import com.microsoft.java.bs.core.internal.reporter.ProgressReporter;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.StartEvent;

public class DefaultProgressReporter
extends ProgressReporter {
    public DefaultProgressReporter(BuildClient client) {
        super(client, null);
    }

    public void statusChanged(ProgressEvent event) {
        if (this.client != null) {
            String taskPath = this.getTaskPath(event.getDescriptor());
            TaskId taskId = this.getTaskId(taskPath);
            if (event instanceof StartEvent) {
                this.taskStarted(taskId, event.getDisplayName());
            } else if (event instanceof FinishEvent) {
                OperationResult result = ((FinishEvent)event).getResult();
                StatusCode status = result instanceof FailureResult ? StatusCode.ERROR : StatusCode.OK;
                this.taskFinished(taskId, event.getDisplayName(), status);
            } else {
                this.taskInProgress(taskId, event.getDisplayName());
            }
        }
    }

    private void taskStarted(TaskId taskId, String message) {
        TaskStartParams startParam = new TaskStartParams(taskId);
        startParam.setEventTime(Long.valueOf(System.currentTimeMillis()));
        startParam.setMessage(message);
        this.client.onBuildTaskStart(startParam);
    }

    private void taskInProgress(TaskId taskId, String message) {
        TaskProgressParams progressParam = new TaskProgressParams(taskId);
        progressParam.setEventTime(Long.valueOf(System.currentTimeMillis()));
        progressParam.setMessage(message);
        this.client.onBuildTaskProgress(progressParam);
    }

    private void taskFinished(TaskId taskId, String message, StatusCode statusCode) {
        TaskFinishParams endParam = new TaskFinishParams(taskId, statusCode);
        endParam.setEventTime(Long.valueOf(System.currentTimeMillis()));
        endParam.setMessage(message);
        this.client.onBuildTaskFinish(endParam);
    }
}

