/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.gradle.model.impl;

import com.microsoft.java.bs.gradle.model.BuildTargetDependency;
import com.microsoft.java.bs.gradle.model.GradleSourceSet;
import java.util.Objects;

public class DefaultBuildTargetDependency
implements BuildTargetDependency {
    private static final long serialVersionUID = 1L;
    private String projectDir;
    private String sourceSetName;

    public DefaultBuildTargetDependency(String projectDir, String sourceSetName) {
        this.projectDir = projectDir;
        this.sourceSetName = sourceSetName;
    }

    public DefaultBuildTargetDependency(GradleSourceSet sourceSet) {
        this(sourceSet.getProjectDir().getAbsolutePath(), sourceSet.getSourceSetName());
    }

    public DefaultBuildTargetDependency(BuildTargetDependency buildTargetDependency) {
        this.projectDir = buildTargetDependency.getProjectDir();
        this.sourceSetName = buildTargetDependency.getSourceSetName();
    }

    @Override
    public String getProjectDir() {
        return this.projectDir;
    }

    public void setProjectDir(String projectDir) {
        this.projectDir = projectDir;
    }

    @Override
    public String getSourceSetName() {
        return this.sourceSetName;
    }

    public void setSourceSetName(String sourceSetName) {
        this.sourceSetName = sourceSetName;
    }

    public int hashCode() {
        return Objects.hash(this.projectDir, this.sourceSetName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultBuildTargetDependency other = (DefaultBuildTargetDependency)obj;
        return Objects.equals(this.projectDir, other.projectDir) && Objects.equals(this.sourceSetName, other.sourceSetName);
    }
}

