(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_notebook_lib_browser_notebook-frontend-module_js"],{

/***/ "../../node_modules/@theia/core/shared/markdown-it.js":
/*!************************************************************!*\
  !*** ../../node_modules/@theia/core/shared/markdown-it.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! markdown-it */ "../../node_modules/markdown-it/index.js");


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-color-contribution.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/contributions/notebook-color-contribution.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookColorContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const color_1 = __webpack_require__(/*! @theia/core/lib/common/color */ "../../node_modules/@theia/core/lib/common/color.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
let NotebookColorContribution = class NotebookColorContribution {
    registerColors(colors) {
        colors.register({
            id: 'notebook.cellBorderColor',
            defaults: {
                dark: color_1.Color.transparent('list.inactiveSelectionBackground', 1),
                light: color_1.Color.transparent('list.inactiveSelectionBackground', 1),
                hcDark: 'panel.border',
                hcLight: 'panel.border'
            },
            description: 'The border color for notebook cells.'
        }, {
            id: 'notebook.focusedEditorBorder',
            defaults: {
                dark: 'focusBorder',
                light: 'focusBorder',
                hcDark: 'focusBorder',
                hcLight: 'focusBorder'
            },
            description: 'The color of the notebook cell editor border.'
        }, {
            id: 'notebookStatusSuccessIcon.foreground',
            defaults: {
                dark: 'debugIcon.startForeground',
                light: 'debugIcon.startForeground',
                hcDark: 'debugIcon.startForeground',
                hcLight: 'debugIcon.startForeground'
            },
            description: 'The error icon color of notebook cells in the cell status bar.'
        }, {
            id: 'notebookEditorOverviewRuler.runningCellForeground',
            defaults: {
                dark: 'debugIcon.startForeground',
                light: 'debugIcon.startForeground',
                hcDark: 'debugIcon.startForeground',
                hcLight: 'debugIcon.startForeground'
            },
            description: 'The color of the running cell decoration in the notebook editor overview ruler.'
        }, {
            id: 'notebookStatusErrorIcon.foreground',
            defaults: {
                dark: 'errorForeground',
                light: 'errorForeground',
                hcDark: 'errorForeground',
                hcLight: 'errorForeground'
            },
            description: 'The error icon color of notebook cells in the cell status bar.'
        }, {
            id: 'notebookStatusRunningIcon.foreground',
            defaults: {
                dark: 'foreground',
                light: 'foreground',
                hcDark: 'foreground',
                hcLight: 'foreground'
            },
            description: 'The running icon color of notebook cells in the cell status bar.'
        }, {
            id: 'notebook.outputContainerBorderColor',
            defaults: {
                dark: undefined,
                light: undefined,
                hcDark: undefined,
                hcLight: undefined
            },
            description: 'The border color of the notebook output container.'
        }, {
            id: 'notebook.outputContainerBackgroundColor',
            defaults: {
                dark: undefined,
                light: undefined,
                hcDark: undefined,
                hcLight: undefined
            },
            description: 'The color of the notebook output container background.'
        }, {
            id: 'notebook.cellToolbarSeparator',
            defaults: {
                dark: color_1.Color.rgba(128, 128, 128, 0.35),
                light: color_1.Color.rgba(128, 128, 128, 0.35),
                hcDark: 'contrastBorder',
                hcLight: 'contrastBorder'
            },
            description: 'The color of the separator in the cell bottom toolbar'
        }, {
            id: 'notebook.focusedCellBackground',
            defaults: {
                dark: undefined,
                light: undefined,
                hcDark: undefined,
                hcLight: undefined
            },
            description: 'The background color of a cell when the cell is focused.'
        }, {
            id: 'notebook.selectedCellBackground',
            defaults: {
                dark: 'list.inactiveSelectionBackground',
                light: 'list.inactiveSelectionBackground',
                hcDark: undefined,
                hcLight: undefined
            },
            description: 'The background color of a cell when the cell is selected.'
        }, {
            id: 'notebook.cellHoverBackground',
            defaults: {
                dark: color_1.Color.transparent('notebook.focusedCellBackground', 0.5),
                light: color_1.Color.transparent('notebook.focusedCellBackground', 0.7),
                hcDark: undefined,
                hcLight: undefined
            },
            description: 'The background color of a cell when the cell is hovered.'
        }, {
            id: 'notebook.selectedCellBorder',
            defaults: {
                dark: 'notebook.cellBorderColor',
                light: 'notebook.cellBorderColor',
                hcDark: 'contrastBorder',
                hcLight: 'contrastBorder'
            },
            description: "The color of the cell's top and bottom border when the cell is selected but not focused."
        }, {
            id: 'notebook.inactiveSelectedCellBorder',
            defaults: {
                dark: undefined,
                light: undefined,
                hcDark: 'focusBorder',
                hcLight: 'focusBorder'
            },
            description: "The color of the cell's borders when multiple cells are selected."
        }, {
            id: 'notebook.focusedCellBorder',
            defaults: {
                dark: 'focusBorder',
                light: 'focusBorder',
                hcDark: 'focusBorder',
                hcLight: 'focusBorder'
            },
            description: "The color of the cell's focus indicator borders when the cell is focused."
        }, {
            id: 'notebook.inactiveFocusedCellBorder',
            defaults: {
                dark: 'notebook.cellBorderColor',
                light: 'notebook.cellBorderColor',
                hcDark: 'notebook.cellBorderColor',
                hcLight: 'notebook.cellBorderColor'
            },
            description: "The color of the cell's top and bottom border when a cell is focused while the primary focus is outside of the editor."
        }, {
            id: 'notebook.cellStatusBarItemHoverBackground',
            defaults: {
                dark: color_1.Color.rgba(0, 0, 0, 0.08),
                light: color_1.Color.rgba(255, 255, 255, 0.15),
                hcDark: color_1.Color.rgba(0, 0, 0, 0.08),
                hcLight: color_1.Color.rgba(255, 255, 255, 0.15)
            },
            description: 'The background color of notebook cell status bar items.'
        }, {
            id: 'notebook.cellInsertionIndicator',
            defaults: {
                dark: 'focusBorder',
                light: 'focusBorder',
                hcDark: 'focusBorder',
                hcLight: undefined
            },
            description: 'Notebook background color.'
        }, {
            id: 'notebookScrollbarSlider.background',
            defaults: {
                dark: 'scrollbarSlider.background',
                light: 'scrollbarSlider.background',
                hcDark: 'scrollbarSlider.background',
                hcLight: 'scrollbarSlider.background'
            },
            description: 'Notebook scrollbar slider background color.'
        }, {
            id: 'notebookScrollbarSlider.hoverBackground',
            defaults: {
                dark: 'scrollbarSlider.hoverBackground',
                light: 'scrollbarSlider.hoverBackground',
                hcDark: 'scrollbarSlider.hoverBackground',
                hcLight: 'scrollbarSlider.hoverBackground'
            },
            description: 'Notebook scrollbar slider background color when hovering.'
        }, {
            id: 'notebookScrollbarSlider.activeBackground',
            defaults: {
                dark: 'scrollbarSlider.activeBackground',
                light: 'scrollbarSlider.activeBackground',
                hcDark: 'scrollbarSlider.activeBackground',
                hcLight: 'scrollbarSlider.activeBackground'
            },
            description: 'Notebook scrollbar slider background color when clicked on.'
        }, {
            id: 'notebook.symbolHighlightBackground',
            defaults: {
                dark: color_1.Color.rgba(255, 255, 255, 0.04),
                light: color_1.Color.rgba(253, 255, 0, 0.2),
                hcDark: undefined,
                hcLight: undefined
            },
            description: 'Background color of highlighted cell'
        }, {
            id: 'notebook.cellEditorBackground',
            defaults: {
                dark: 'sideBar.background',
                light: 'sideBar.background',
                hcDark: undefined,
                hcLight: undefined
            },
            description: 'Cell editor background color.'
        }, {
            id: 'notebook.editorBackground',
            defaults: {
                dark: 'editorPane.background',
                light: 'editorPane.background',
                hcDark: undefined,
                hcLight: undefined
            },
            description: 'Notebook background color.'
        });
    }
};
exports.NotebookColorContribution = NotebookColorContribution;
exports.NotebookColorContribution = NotebookColorContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookColorContribution);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-label-provider-contribution.js":
/*!************************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/contributions/notebook-label-provider-contribution.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookLabelProviderContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const notebook_service_1 = __webpack_require__(/*! ../service/notebook-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-service.js");
const notebook_outline_contribution_1 = __webpack_require__(/*! ./notebook-outline-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-outline-contribution.js");
const markdownit = __webpack_require__(/*! @theia/core/shared/markdown-it */ "../../node_modules/@theia/core/shared/markdown-it.js");
let NotebookLabelProviderContribution = class NotebookLabelProviderContribution {
    constructor() {
        this.markdownIt = markdownit();
    }
    canHandle(element) {
        if (notebook_outline_contribution_1.NotebookCellOutlineNode.is(element)) {
            return 200;
        }
        return 0;
    }
    getIcon(element) {
        const cell = this.findCellByUri(element.uri);
        if (cell) {
            return cell.cellKind === common_1.CellKind.Markup ? (0, browser_1.codicon)('markdown') : (0, browser_1.codicon)('code');
        }
        return '';
    }
    getName(element) {
        const cell = this.findCellByUri(element.uri);
        if (cell) {
            return cell.cellKind === common_1.CellKind.Code ?
                cell.text.split('\n')[0] :
                this.extractPlaintext(this.markdownIt.parse(cell.text.split('\n')[0], {}));
        }
        return '';
    }
    getLongName(element) {
        const cell = this.findCellByUri(element.uri);
        if (cell) {
            return cell.cellKind === common_1.CellKind.Code ?
                cell.text.split('\n')[0] :
                this.extractPlaintext(this.markdownIt.parse(cell.text.split('\n')[0], {}));
        }
        return '';
    }
    extractPlaintext(parsedMarkdown) {
        return parsedMarkdown.map(token => token.children ? this.extractPlaintext(token.children) : token.content).join('');
    }
    findCellByUri(uri) {
        var _a;
        const parsed = common_1.CellUri.parse(uri);
        if (parsed) {
            return (_a = this.notebookService.getNotebookEditorModel(parsed.notebook)) === null || _a === void 0 ? void 0 : _a.cells.find(cell => cell.handle === (parsed === null || parsed === void 0 ? void 0 : parsed.handle));
        }
        return undefined;
    }
};
exports.NotebookLabelProviderContribution = NotebookLabelProviderContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_service_1.NotebookService),
    tslib_1.__metadata("design:type", notebook_service_1.NotebookService)
], NotebookLabelProviderContribution.prototype, "notebookService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], NotebookLabelProviderContribution.prototype, "labelProvider", void 0);
exports.NotebookLabelProviderContribution = NotebookLabelProviderContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookLabelProviderContribution);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-outline-contribution.js":
/*!*****************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/contributions/notebook-outline-contribution.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookOutlineContribution = exports.NotebookCellOutlineNode = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const notebook_editor_widget_service_1 = __webpack_require__(/*! ../service/notebook-editor-widget-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-editor-widget-service.js");
const outline_view_service_1 = __webpack_require__(/*! @theia/outline-view/lib/browser/outline-view-service */ "../../node_modules/@theia/outline-view/lib/browser/outline-view-service.js");
const outline_view_widget_1 = __webpack_require__(/*! @theia/outline-view/lib/browser/outline-view-widget */ "../../node_modules/@theia/outline-view/lib/browser/outline-view-widget.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const notebook_service_1 = __webpack_require__(/*! ../service/notebook-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-service.js");
var NotebookCellOutlineNode;
(function (NotebookCellOutlineNode) {
    function is(element) {
        return browser_1.TreeNode.is(element)
            && outline_view_widget_1.OutlineSymbolInformationNode.is(element)
            && (0, core_1.isObject)(element)
            && element.uri instanceof core_1.URI
            && element.uri.scheme === common_1.CellUri.cellUriScheme;
    }
    NotebookCellOutlineNode.is = is;
})(NotebookCellOutlineNode || (exports.NotebookCellOutlineNode = NotebookCellOutlineNode = {}));
let NotebookOutlineContribution = class NotebookOutlineContribution {
    constructor() {
        this.editorListeners = new core_1.DisposableCollection();
        this.editorModelListeners = new core_1.DisposableCollection();
    }
    onStart() {
        this.notebookEditorWidgetService.onDidChangeFocusedEditor(editor => this.updateOutline(editor));
        this.outlineViewService.onDidSelect(node => this.selectCell(node));
        this.outlineViewService.onDidTapNode(node => this.selectCell(node));
    }
    async updateOutline(editor) {
        if (editor && !editor.isDisposed) {
            await editor.ready;
            this.currentEditor = editor;
            this.editorListeners.dispose();
            this.editorListeners.push(editor.onDidChangeVisibility(() => {
                if (this.currentEditor === editor && !editor.isVisible) {
                    this.outlineViewService.publish([]);
                }
            }));
            if (editor.model) {
                this.editorModelListeners.dispose();
                this.editorModelListeners.push(editor.model.onDidChangeSelectedCell(() => {
                    if (editor === this.currentEditor) {
                        this.updateOutline(editor);
                    }
                }));
                const roots = editor && editor.model && await this.createRoots(editor.model);
                this.outlineViewService.publish(roots || []);
            }
        }
    }
    async createRoots(model) {
        return model.cells.map(cell => ({
            id: cell.uri.toString(),
            iconClass: cell.cellKind === common_1.CellKind.Markup ? (0, browser_1.codicon)('markdown') : (0, browser_1.codicon)('code'),
            parent: undefined,
            children: [],
            selected: model.selectedCell === cell,
            expanded: false,
            uri: cell.uri,
        }));
    }
    selectCell(node) {
        if (NotebookCellOutlineNode.is(node)) {
            const parsed = common_1.CellUri.parse(node.uri);
            const model = parsed && this.notebookService.getNotebookEditorModel(parsed.notebook);
            const cell = model === null || model === void 0 ? void 0 : model.cells.find(c => c.handle === (parsed === null || parsed === void 0 ? void 0 : parsed.handle));
            if (model && cell) {
                model.setSelectedCell(cell);
            }
        }
    }
};
exports.NotebookOutlineContribution = NotebookOutlineContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_editor_widget_service_1.NotebookEditorWidgetService),
    tslib_1.__metadata("design:type", notebook_editor_widget_service_1.NotebookEditorWidgetService)
], NotebookOutlineContribution.prototype, "notebookEditorWidgetService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(outline_view_service_1.OutlineViewService),
    tslib_1.__metadata("design:type", outline_view_service_1.OutlineViewService)
], NotebookOutlineContribution.prototype, "outlineViewService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], NotebookOutlineContribution.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_service_1.NotebookService),
    tslib_1.__metadata("design:type", notebook_service_1.NotebookService)
], NotebookOutlineContribution.prototype, "notebookService", void 0);
exports.NotebookOutlineContribution = NotebookOutlineContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookOutlineContribution);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-output-action-contribution.js":
/*!***********************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/contributions/notebook-output-action-contribution.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookOutputActionContribution = exports.NotebookOutputCommands = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const notebook_editor_widget_service_1 = __webpack_require__(/*! ../service/notebook-editor-widget-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-editor-widget-service.js");
const common_1 = __webpack_require__(/*! ../../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
var NotebookOutputCommands;
(function (NotebookOutputCommands) {
    NotebookOutputCommands.ENABLE_SCROLLING = {
        id: 'cellOutput.enableScrolling',
    };
    NotebookOutputCommands.OPEN_LARGE_OUTPUT = {
        id: 'workbench.action.openLargeOutput'
    };
})(NotebookOutputCommands || (exports.NotebookOutputCommands = NotebookOutputCommands = {}));
let NotebookOutputActionContribution = class NotebookOutputActionContribution {
    registerCommands(commands) {
        commands.registerCommand(NotebookOutputCommands.ENABLE_SCROLLING, {
            execute: outputId => {
                var _a;
                const [cell, output] = (_a = this.findOutputAndCell(outputId)) !== null && _a !== void 0 ? _a : [];
                if (cell && (output === null || output === void 0 ? void 0 : output.metadata)) {
                    output.metadata['scrollable'] = true;
                    cell.restartOutputRenderer(output.outputId);
                }
            }
        });
        commands.registerCommand(NotebookOutputCommands.OPEN_LARGE_OUTPUT, {
            execute: outputId => {
                var _a;
                const [cell, output] = (_a = this.findOutputAndCell(outputId)) !== null && _a !== void 0 ? _a : [];
                if (cell && output) {
                    this.editorManager.open(common_1.CellUri.generateCellOutputUri(common_1.CellUri.parse(cell.uri).notebook, output.outputId));
                }
            }
        });
    }
    findOutputAndCell(output) {
        var _a;
        const model = (_a = this.notebookEditorService.focusedEditor) === null || _a === void 0 ? void 0 : _a.model;
        if (!model) {
            return undefined;
        }
        const outputId = output.slice(0, output.lastIndexOf('-'));
        for (const cell of model.cells) {
            for (const outputModel of cell.outputs) {
                if (outputModel.outputId === outputId) {
                    return [cell, outputModel];
                }
            }
        }
    }
};
exports.NotebookOutputActionContribution = NotebookOutputActionContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_editor_widget_service_1.NotebookEditorWidgetService),
    tslib_1.__metadata("design:type", notebook_editor_widget_service_1.NotebookEditorWidgetService)
], NotebookOutputActionContribution.prototype, "notebookEditorService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.EditorManager),
    tslib_1.__metadata("design:type", browser_1.EditorManager)
], NotebookOutputActionContribution.prototype, "editorManager", void 0);
exports.NotebookOutputActionContribution = NotebookOutputActionContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookOutputActionContribution);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-status-bar-contribution.js":
/*!********************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/contributions/notebook-status-bar-contribution.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookStatusBarContribution = exports.NOTEBOOK_CELL_SELECTION_STATUS_BAR_ID = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const notebook_editor_widget_1 = __webpack_require__(/*! ../notebook-editor-widget */ "../../node_modules/@theia/notebook/lib/browser/notebook-editor-widget.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const notebook_actions_contribution_1 = __webpack_require__(/*! ./notebook-actions-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-actions-contribution.js");
exports.NOTEBOOK_CELL_SELECTION_STATUS_BAR_ID = 'notebook-cell-selection-position';
let NotebookStatusBarContribution = class NotebookStatusBarContribution {
    canHandle(widget) {
        return widget instanceof notebook_editor_widget_1.NotebookEditorWidget;
    }
    activate(statusBar, widget) {
        widget.ready.then(model => {
            this.onDeactivate = model.onDidChangeSelectedCell(() => {
                this.updateStatusbar(statusBar, widget);
            });
        });
        this.updateStatusbar(statusBar, widget);
    }
    deactivate(statusBar) {
        var _a;
        (_a = this.onDeactivate) === null || _a === void 0 ? void 0 : _a.dispose();
        this.updateStatusbar(statusBar);
    }
    async updateStatusbar(statusBar, editor) {
        const model = await (editor === null || editor === void 0 ? void 0 : editor.ready);
        if (!model || model.cells.length === 0 || !model.selectedCell) {
            statusBar.removeElement(exports.NOTEBOOK_CELL_SELECTION_STATUS_BAR_ID);
            return;
        }
        const selectedCellIndex = model.cells.indexOf(model.selectedCell) + 1;
        statusBar.setElement(exports.NOTEBOOK_CELL_SELECTION_STATUS_BAR_ID, {
            text: core_1.nls.localizeByDefault('Cell {0} of {1}', selectedCellIndex, model.cells.length),
            alignment: browser_1.StatusBarAlignment.RIGHT,
            priority: 100,
            command: notebook_actions_contribution_1.NotebookCommands.CENTER_ACTIVE_CELL.id,
            arguments: [editor]
        });
    }
};
exports.NotebookStatusBarContribution = NotebookStatusBarContribution;
exports.NotebookStatusBarContribution = NotebookStatusBarContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookStatusBarContribution);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-undo-redo-handler.js":
/*!**************************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/contributions/notebook-undo-redo-handler.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2024 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookUndoRedoHandler = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const notebook_editor_widget_1 = __webpack_require__(/*! ../notebook-editor-widget */ "../../node_modules/@theia/notebook/lib/browser/notebook-editor-widget.js");
let NotebookUndoRedoHandler = class NotebookUndoRedoHandler {
    constructor() {
        this.priority = 200;
    }
    select() {
        const current = this.applicationShell.currentWidget;
        if (current instanceof notebook_editor_widget_1.NotebookEditorWidget) {
            return current;
        }
        return undefined;
    }
    undo(item) {
        item.undo();
    }
    redo(item) {
        item.redo();
    }
};
exports.NotebookUndoRedoHandler = NotebookUndoRedoHandler;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    tslib_1.__metadata("design:type", browser_1.ApplicationShell)
], NotebookUndoRedoHandler.prototype, "applicationShell", void 0);
exports.NotebookUndoRedoHandler = NotebookUndoRedoHandler = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookUndoRedoHandler);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/notebook-cell-resource-resolver.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/notebook-cell-resource-resolver.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookOutputResourceResolver = exports.NotebookCellResourceResolver = exports.NotebookCellResource = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/notebook/lib/common/index.js");
const notebook_service_1 = __webpack_require__(/*! ./service/notebook-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-service.js");
class NotebookCellResource {
    get onDidChangeContents() {
        return this.onDidChangeContentsEmitter.event;
    }
    get onDidChangeReadOnly() {
        return this.notebook.onDidChangeReadOnly;
    }
    get readOnly() {
        return this.notebook.readOnly;
    }
    constructor(uri, notebook, cell) {
        this.onDidChangeContentsEmitter = new core_1.Emitter();
        this.uri = uri;
        this.notebook = notebook;
        this.cell = cell;
    }
    readContents(options) {
        return Promise.resolve(this.cell.source);
    }
    dispose() {
        this.onDidChangeContentsEmitter.dispose();
    }
}
exports.NotebookCellResource = NotebookCellResource;
let NotebookCellResourceResolver = class NotebookCellResourceResolver {
    async resolve(uri) {
        if (uri.scheme !== common_1.CellUri.cellUriScheme) {
            throw new Error(`Cannot resolve cell uri with scheme '${uri.scheme}'`);
        }
        const parsedUri = common_1.CellUri.parse(uri);
        if (!parsedUri) {
            throw new Error(`Cannot parse uri '${uri.toString()}'`);
        }
        const notebookModel = this.notebookService.getNotebookEditorModel(parsedUri.notebook);
        if (!notebookModel) {
            throw new Error(`No notebook found for uri '${parsedUri.notebook}'`);
        }
        const notebookCellModel = notebookModel.cells.find(cell => cell.handle === parsedUri.handle);
        if (!notebookCellModel) {
            throw new Error(`No cell found with handle '${parsedUri.handle}' in '${parsedUri.notebook}'`);
        }
        return new NotebookCellResource(uri, notebookModel, notebookCellModel);
    }
};
exports.NotebookCellResourceResolver = NotebookCellResourceResolver;
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_service_1.NotebookService),
    tslib_1.__metadata("design:type", notebook_service_1.NotebookService)
], NotebookCellResourceResolver.prototype, "notebookService", void 0);
exports.NotebookCellResourceResolver = NotebookCellResourceResolver = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookCellResourceResolver);
let NotebookOutputResourceResolver = class NotebookOutputResourceResolver {
    async resolve(uri) {
        if (uri.scheme !== common_1.CellUri.outputUriScheme) {
            throw new Error(`Cannot resolve output uri with scheme '${uri.scheme}'`);
        }
        const parsedUri = common_1.CellUri.parseCellOutputUri(uri);
        if (!parsedUri) {
            throw new Error(`Cannot parse uri '${uri.toString()}'`);
        }
        const notebookModel = this.notebookService.getNotebookEditorModel(parsedUri.notebook);
        if (!notebookModel) {
            throw new Error(`No notebook found for uri '${parsedUri.notebook}'`);
        }
        const ouputModel = notebookModel.cells.flatMap(cell => cell.outputs).find(output => output.outputId === parsedUri.outputId);
        if (!ouputModel) {
            throw new Error(`No output found with id '${parsedUri.outputId}' in '${parsedUri.notebook}'`);
        }
        return {
            uri: uri,
            dispose: () => { },
            readContents: async () => ouputModel.outputs[0].data.toString(),
            readOnly: true,
        };
    }
};
exports.NotebookOutputResourceResolver = NotebookOutputResourceResolver;
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_service_1.NotebookService),
    tslib_1.__metadata("design:type", notebook_service_1.NotebookService)
], NotebookOutputResourceResolver.prototype, "notebookService", void 0);
exports.NotebookOutputResourceResolver = NotebookOutputResourceResolver = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookOutputResourceResolver);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/notebook-editor-widget-factory.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/notebook-editor-widget-factory.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NotebookEditorWidgetFactory = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const notebook_editor_widget_1 = __webpack_require__(/*! ./notebook-editor-widget */ "../../node_modules/@theia/notebook/lib/browser/notebook-editor-widget.js");
const notebook_service_1 = __webpack_require__(/*! ./service/notebook-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-service.js");
const notebook_model_resolver_service_1 = __webpack_require__(/*! ./service/notebook-model-resolver-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-model-resolver-service.js");
const promise_util_1 = __webpack_require__(/*! @theia/core/lib/common/promise-util */ "../../node_modules/@theia/core/lib/common/promise-util.js");
let NotebookEditorWidgetFactory = class NotebookEditorWidgetFactory {
    constructor() {
        this.id = notebook_editor_widget_1.NotebookEditorWidget.ID;
    }
    async createWidget(options) {
        if (!options) {
            throw new Error('no options found for widget. Need at least uri and notebookType');
        }
        const uri = new core_1.URI(options.uri);
        await this.notebookService.willOpenNotebook(options.notebookType);
        const editor = await this.createEditor(uri, options.notebookType);
        this.setLabels(editor, uri);
        const labelListener = this.labelProvider.onDidChange(event => {
            if (event.affects(uri)) {
                this.setLabels(editor, uri);
            }
        });
        editor.onDidDispose(() => labelListener.dispose());
        return editor;
    }
    async createEditor(uri, notebookType) {
        const notebookData = new promise_util_1.Deferred();
        const resolverError = new promise_util_1.Deferred();
        this.notebookModelResolver.resolve(uri, notebookType).then(model => {
            notebookData.resolve(model);
        }).catch((reason) => {
            resolverError.resolve(reason.message);
        });
        return this.createNotebookEditorWidget({
            uri,
            notebookType,
            notebookData: notebookData.promise,
            error: resolverError.promise
        });
    }
    setLabels(editor, uri) {
        var _a;
        editor.title.caption = uri.path.fsPath();
        if ((_a = editor.model) === null || _a === void 0 ? void 0 : _a.readOnly) {
            editor.title.caption += ` • ${core_1.nls.localizeByDefault('Read-only')}`;
        }
        const icon = this.labelProvider.getIcon(uri);
        editor.title.label = this.labelProvider.getName(uri);
        editor.title.iconClass = icon + ' file-icon';
    }
};
exports.NotebookEditorWidgetFactory = NotebookEditorWidgetFactory;
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_service_1.NotebookService),
    tslib_1.__metadata("design:type", notebook_service_1.NotebookService)
], NotebookEditorWidgetFactory.prototype, "notebookService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_model_resolver_service_1.NotebookModelResolverService),
    tslib_1.__metadata("design:type", notebook_model_resolver_service_1.NotebookModelResolverService)
], NotebookEditorWidgetFactory.prototype, "notebookModelResolver", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], NotebookEditorWidgetFactory.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(notebook_editor_widget_1.NotebookEditorWidgetContainerFactory),
    tslib_1.__metadata("design:type", Function)
], NotebookEditorWidgetFactory.prototype, "createNotebookEditorWidget", void 0);
exports.NotebookEditorWidgetFactory = NotebookEditorWidgetFactory = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], NotebookEditorWidgetFactory);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/browser/notebook-frontend-module.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/browser/notebook-frontend-module.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
__webpack_require__(/*! ../../src/browser/style/index.css */ "../../node_modules/@theia/notebook/src/browser/style/index.css");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const color_application_contribution_1 = __webpack_require__(/*! @theia/core/lib/browser/color-application-contribution */ "../../node_modules/@theia/core/lib/browser/color-application-contribution.js");
const notebook_open_handler_1 = __webpack_require__(/*! ./notebook-open-handler */ "../../node_modules/@theia/notebook/lib/browser/notebook-open-handler.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const notebook_type_registry_1 = __webpack_require__(/*! ./notebook-type-registry */ "../../node_modules/@theia/notebook/lib/browser/notebook-type-registry.js");
const notebook_renderer_registry_1 = __webpack_require__(/*! ./notebook-renderer-registry */ "../../node_modules/@theia/notebook/lib/browser/notebook-renderer-registry.js");
const notebook_service_1 = __webpack_require__(/*! ./service/notebook-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-service.js");
const notebook_editor_widget_factory_1 = __webpack_require__(/*! ./notebook-editor-widget-factory */ "../../node_modules/@theia/notebook/lib/browser/notebook-editor-widget-factory.js");
const notebook_cell_resource_resolver_1 = __webpack_require__(/*! ./notebook-cell-resource-resolver */ "../../node_modules/@theia/notebook/lib/browser/notebook-cell-resource-resolver.js");
const notebook_model_resolver_service_1 = __webpack_require__(/*! ./service/notebook-model-resolver-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-model-resolver-service.js");
const notebook_cell_actions_contribution_1 = __webpack_require__(/*! ./contributions/notebook-cell-actions-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-cell-actions-contribution.js");
const notebook_model_1 = __webpack_require__(/*! ./view-model/notebook-model */ "../../node_modules/@theia/notebook/lib/browser/view-model/notebook-model.js");
const notebook_cell_model_1 = __webpack_require__(/*! ./view-model/notebook-cell-model */ "../../node_modules/@theia/notebook/lib/browser/view-model/notebook-cell-model.js");
const notebook_editor_widget_1 = __webpack_require__(/*! ./notebook-editor-widget */ "../../node_modules/@theia/notebook/lib/browser/notebook-editor-widget.js");
const notebook_actions_contribution_1 = __webpack_require__(/*! ./contributions/notebook-actions-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-actions-contribution.js");
const notebook_execution_service_1 = __webpack_require__(/*! ./service/notebook-execution-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-execution-service.js");
const notebook_execution_state_service_1 = __webpack_require__(/*! ./service/notebook-execution-state-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-execution-state-service.js");
const notebook_kernel_service_1 = __webpack_require__(/*! ./service/notebook-kernel-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-service.js");
const notebook_kernel_quick_pick_service_1 = __webpack_require__(/*! ./service/notebook-kernel-quick-pick-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-quick-pick-service.js");
const notebook_kernel_history_service_1 = __webpack_require__(/*! ./service/notebook-kernel-history-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-kernel-history-service.js");
const notebook_editor_widget_service_1 = __webpack_require__(/*! ./service/notebook-editor-widget-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-editor-widget-service.js");
const notebook_renderer_messaging_service_1 = __webpack_require__(/*! ./service/notebook-renderer-messaging-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-renderer-messaging-service.js");
const notebook_color_contribution_1 = __webpack_require__(/*! ./contributions/notebook-color-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-color-contribution.js");
const notebook_monaco_text_model_service_1 = __webpack_require__(/*! ./service/notebook-monaco-text-model-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-monaco-text-model-service.js");
const notebook_outline_contribution_1 = __webpack_require__(/*! ./contributions/notebook-outline-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-outline-contribution.js");
const notebook_label_provider_contribution_1 = __webpack_require__(/*! ./contributions/notebook-label-provider-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-label-provider-contribution.js");
const notebook_output_action_contribution_1 = __webpack_require__(/*! ./contributions/notebook-output-action-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-output-action-contribution.js");
const notebook_clipboard_service_1 = __webpack_require__(/*! ./service/notebook-clipboard-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-clipboard-service.js");
const notebook_preferences_1 = __webpack_require__(/*! ./contributions/notebook-preferences */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-preferences.js");
const notebook_options_1 = __webpack_require__(/*! ./service/notebook-options */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-options.js");
const notebook_undo_redo_handler_1 = __webpack_require__(/*! ./contributions/notebook-undo-redo-handler */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-undo-redo-handler.js");
const notebook_status_bar_contribution_1 = __webpack_require__(/*! ./contributions/notebook-status-bar-contribution */ "../../node_modules/@theia/notebook/lib/browser/contributions/notebook-status-bar-contribution.js");
const notebook_cell_editor_service_1 = __webpack_require__(/*! ./service/notebook-cell-editor-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-cell-editor-service.js");
const notebook_cell_status_bar_service_1 = __webpack_require__(/*! ./service/notebook-cell-status-bar-service */ "../../node_modules/@theia/notebook/lib/browser/service/notebook-cell-status-bar-service.js");
const monaco_text_model_service_1 = __webpack_require__(/*! @theia/monaco/lib/browser/monaco-text-model-service */ "../../node_modules/@theia/monaco/lib/browser/monaco-text-model-service.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(notebook_color_contribution_1.NotebookColorContribution).toSelf().inSingletonScope();
    bind(color_application_contribution_1.ColorContribution).toService(notebook_color_contribution_1.NotebookColorContribution);
    bind(notebook_open_handler_1.NotebookOpenHandler).toSelf().inSingletonScope();
    bind(browser_1.OpenHandler).toService(notebook_open_handler_1.NotebookOpenHandler);
    bind(notebook_type_registry_1.NotebookTypeRegistry).toSelf().inSingletonScope();
    bind(notebook_renderer_registry_1.NotebookRendererRegistry).toSelf().inSingletonScope();
    bind(browser_1.WidgetFactory).to(notebook_editor_widget_factory_1.NotebookEditorWidgetFactory).inSingletonScope();
    bind(notebook_service_1.NotebookService).toSelf().inSingletonScope();
    bind(notebook_editor_widget_service_1.NotebookEditorWidgetService).toSelf().inSingletonScope();
    bind(notebook_execution_service_1.NotebookExecutionService).toSelf().inSingletonScope();
    bind(notebook_execution_state_service_1.NotebookExecutionStateService).toSelf().inSingletonScope();
    bind(notebook_kernel_service_1.NotebookKernelService).toSelf().inSingletonScope();
    bind(notebook_renderer_messaging_service_1.NotebookRendererMessagingService).toSelf().inSingletonScope();
    bind(notebook_kernel_history_service_1.NotebookKernelHistoryService).toSelf().inSingletonScope();
    bind(notebook_kernel_quick_pick_service_1.NotebookKernelQuickPickService).toSelf().inSingletonScope();
    bind(notebook_clipboard_service_1.NotebookClipboardService).toSelf().inSingletonScope();
    bind(notebook_cell_editor_service_1.NotebookCellEditorService).toSelf().inSingletonScope();
    bind(notebook_cell_status_bar_service_1.NotebookCellStatusBarService).toSelf().inSingletonScope();
    bind(notebook_cell_resource_resolver_1.NotebookCellResourceResolver).toSelf().inSingletonScope();
    bind(core_1.ResourceResolver).toService(notebook_cell_resource_resolver_1.NotebookCellResourceResolver);
    bind(notebook_model_resolver_service_1.NotebookModelResolverService).toSelf().inSingletonScope();
    bind(notebook_model_1.NotebookModelResolverServiceProxy).toService(notebook_model_resolver_service_1.NotebookModelResolverService);
    bind(notebook_cell_resource_resolver_1.NotebookOutputResourceResolver).toSelf().inSingletonScope();
    bind(core_1.ResourceResolver).toService(notebook_cell_resource_resolver_1.NotebookOutputResourceResolver);
    bind(notebook_cell_actions_contribution_1.NotebookCellActionContribution).toSelf().inSingletonScope();
    bind(core_1.MenuContribution).toService(notebook_cell_actions_contribution_1.NotebookCellActionContribution);
    bind(core_1.CommandContribution).toService(notebook_cell_actions_contribution_1.NotebookCellActionContribution);
    bind(browser_1.KeybindingContribution).toService(notebook_cell_actions_contribution_1.NotebookCellActionContribution);
    bind(notebook_actions_contribution_1.NotebookActionsContribution).toSelf().inSingletonScope();
    bind(core_1.CommandContribution).toService(notebook_actions_contribution_1.NotebookActionsContribution);
    bind(core_1.MenuContribution).toService(notebook_actions_contribution_1.NotebookActionsContribution);
    bind(browser_1.KeybindingContribution).toService(notebook_actions_contribution_1.NotebookActionsContribution);
    bind(notebook_output_action_contribution_1.NotebookOutputActionContribution).toSelf().inSingletonScope();
    bind(core_1.CommandContribution).toService(notebook_output_action_contribution_1.NotebookOutputActionContribution);
    bind(notebook_editor_widget_1.NotebookEditorWidgetContainerFactory).toFactory(ctx => (props) => (0, notebook_editor_widget_1.createNotebookEditorWidgetContainer)(ctx.container, props).get(notebook_editor_widget_1.NotebookEditorWidget));
    bind(notebook_model_1.NotebookModelFactory).toFactory(ctx => (props) => (0, notebook_model_1.createNotebookModelContainer)(ctx.container, props).get(notebook_model_1.NotebookModel));
    bind(notebook_cell_model_1.NotebookCellModelFactory).toFactory(ctx => (props) => (0, notebook_cell_model_1.createNotebookCellModelContainer)(ctx.container, props).get(notebook_cell_model_1.NotebookCellModel));
    bind(notebook_monaco_text_model_service_1.NotebookMonacoTextModelService).toSelf().inSingletonScope();
    bind(notebook_monaco_text_model_service_1.NotebookMonacoEditorModelFilter).toSelf().inSingletonScope();
    bind(monaco_text_model_service_1.MonacoEditorModelFilter).toService(notebook_monaco_text_model_service_1.NotebookMonacoEditorModelFilter);
    bind(notebook_outline_contribution_1.NotebookOutlineContribution).toSelf().inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).toService(notebook_outline_contribution_1.NotebookOutlineContribution);
    bind(notebook_label_provider_contribution_1.NotebookLabelProviderContribution).toSelf().inSingletonScope();
    bind(browser_1.LabelProviderContribution).toService(notebook_label_provider_contribution_1.NotebookLabelProviderContribution);
    (0, notebook_preferences_1.bindNotebookPreferences)(bind);
    bind(notebook_options_1.NotebookOptionsService).toSelf().inSingletonScope();
    bind(notebook_undo_redo_handler_1.NotebookUndoRedoHandler).toSelf().inSingletonScope();
    bind(browser_1.UndoRedoHandler).toService(notebook_undo_redo_handler_1.NotebookUndoRedoHandler);
    bind(notebook_status_bar_contribution_1.NotebookStatusBarContribution).toSelf().inSingletonScope();
    bind(browser_1.WidgetStatusBarContribution).toService(notebook_status_bar_contribution_1.NotebookStatusBarContribution);
});


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/common/index.js":
/*!**************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/common/index.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./notebook-common */ "../../node_modules/@theia/notebook/lib/common/notebook-common.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./notebook-range */ "../../node_modules/@theia/notebook/lib/common/notebook-range.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/common/notebook-common.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/common/notebook-common.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var Buffer = __webpack_require__(/*! buffer */ "../../node_modules/buffer/index.js")["Buffer"];

// *****************************************************************************
// Copyright (C) 2023 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CellUri = exports.isTextStreamMime = exports.CellExecutionUpdateType = exports.NotebookCellExecutionState = exports.NotebookCellModelResource = exports.NotebookModelResource = exports.NotebookCellsChangeType = exports.CellKind = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const buffer_1 = __webpack_require__(/*! @theia/core/lib/common/buffer */ "../../node_modules/@theia/core/lib/common/buffer.js");
var CellKind;
(function (CellKind) {
    CellKind[CellKind["Markup"] = 1] = "Markup";
    CellKind[CellKind["Code"] = 2] = "Code";
})(CellKind || (exports.CellKind = CellKind = {}));
;
var NotebookCellsChangeType;
(function (NotebookCellsChangeType) {
    NotebookCellsChangeType[NotebookCellsChangeType["ModelChange"] = 1] = "ModelChange";
    NotebookCellsChangeType[NotebookCellsChangeType["Move"] = 2] = "Move";
    NotebookCellsChangeType[NotebookCellsChangeType["ChangeCellLanguage"] = 5] = "ChangeCellLanguage";
    NotebookCellsChangeType[NotebookCellsChangeType["Initialize"] = 6] = "Initialize";
    NotebookCellsChangeType[NotebookCellsChangeType["ChangeCellMetadata"] = 7] = "ChangeCellMetadata";
    NotebookCellsChangeType[NotebookCellsChangeType["Output"] = 8] = "Output";
    NotebookCellsChangeType[NotebookCellsChangeType["OutputItem"] = 9] = "OutputItem";
    NotebookCellsChangeType[NotebookCellsChangeType["ChangeCellContent"] = 10] = "ChangeCellContent";
    NotebookCellsChangeType[NotebookCellsChangeType["ChangeDocumentMetadata"] = 11] = "ChangeDocumentMetadata";
    NotebookCellsChangeType[NotebookCellsChangeType["ChangeCellInternalMetadata"] = 12] = "ChangeCellInternalMetadata";
    // ChangeCellMime = 13,
    NotebookCellsChangeType[NotebookCellsChangeType["Unknown"] = 100] = "Unknown";
})(NotebookCellsChangeType || (exports.NotebookCellsChangeType = NotebookCellsChangeType = {}));
var NotebookModelResource;
(function (NotebookModelResource) {
    function is(item) {
        return (0, core_1.isObject)(item) && item.notebookModelUri instanceof core_1.URI;
    }
    NotebookModelResource.is = is;
    function create(uri) {
        return { notebookModelUri: uri };
    }
    NotebookModelResource.create = create;
})(NotebookModelResource || (exports.NotebookModelResource = NotebookModelResource = {}));
var NotebookCellModelResource;
(function (NotebookCellModelResource) {
    function is(item) {
        return (0, core_1.isObject)(item) && item.notebookCellModelUri instanceof core_1.URI;
    }
    NotebookCellModelResource.is = is;
    function create(uri) {
        return { notebookCellModelUri: uri };
    }
    NotebookCellModelResource.create = create;
})(NotebookCellModelResource || (exports.NotebookCellModelResource = NotebookCellModelResource = {}));
var NotebookCellExecutionState;
(function (NotebookCellExecutionState) {
    NotebookCellExecutionState[NotebookCellExecutionState["Unconfirmed"] = 1] = "Unconfirmed";
    NotebookCellExecutionState[NotebookCellExecutionState["Pending"] = 2] = "Pending";
    NotebookCellExecutionState[NotebookCellExecutionState["Executing"] = 3] = "Executing";
})(NotebookCellExecutionState || (exports.NotebookCellExecutionState = NotebookCellExecutionState = {}));
var CellExecutionUpdateType;
(function (CellExecutionUpdateType) {
    CellExecutionUpdateType[CellExecutionUpdateType["Output"] = 1] = "Output";
    CellExecutionUpdateType[CellExecutionUpdateType["OutputItems"] = 2] = "OutputItems";
    CellExecutionUpdateType[CellExecutionUpdateType["ExecutionState"] = 3] = "ExecutionState";
})(CellExecutionUpdateType || (exports.CellExecutionUpdateType = CellExecutionUpdateType = {}));
/**
 * Whether the provided mime type is a text stream like `stdout`, `stderr`.
 */
function isTextStreamMime(mimeType) {
    return ['application/vnd.code.notebook.stdout', 'application/vnd.code.notebook.stderr'].includes(mimeType);
}
exports.isTextStreamMime = isTextStreamMime;
var CellUri;
(function (CellUri) {
    CellUri.cellUriScheme = 'vscode-notebook-cell';
    CellUri.outputUriScheme = 'vscode-notebook-cell-output';
    const _lengths = ['W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f'];
    const _padRegexp = new RegExp(`^[${_lengths.join('')}]+`);
    const _radix = 7;
    function generate(notebook, handle) {
        const s = handle.toString(_radix);
        const p = s.length < _lengths.length ? _lengths[s.length - 1] : 'z';
        const fragment = `${p}${s}s${Buffer.from(buffer_1.BinaryBuffer.fromString(notebook.scheme).buffer).toString('base64')}`;
        return notebook.withScheme(CellUri.cellUriScheme).withFragment(fragment);
    }
    CellUri.generate = generate;
    function parse(cell) {
        if (cell.scheme !== CellUri.cellUriScheme) {
            return undefined;
        }
        const idx = cell.fragment.indexOf('s');
        if (idx < 0) {
            return undefined;
        }
        const handle = parseInt(cell.fragment.substring(0, idx).replace(_padRegexp, ''), _radix);
        const parsedScheme = Buffer.from(cell.fragment.substring(idx + 1), 'base64').toString();
        if (isNaN(handle)) {
            return undefined;
        }
        return {
            handle,
            notebook: cell.withScheme(parsedScheme).withoutFragment()
        };
    }
    CellUri.parse = parse;
    function generateCellOutputUri(notebook, outputId) {
        return notebook
            .withScheme(CellUri.outputUriScheme)
            .withQuery(`op${outputId !== null && outputId !== void 0 ? outputId : ''},${notebook.scheme !== 'file' ? notebook.scheme : ''}`);
    }
    CellUri.generateCellOutputUri = generateCellOutputUri;
    ;
    function parseCellOutputUri(uri) {
        if (uri.scheme !== CellUri.outputUriScheme) {
            return;
        }
        const match = /^op([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})?\,(.*)$/i.exec(uri.query);
        if (!match) {
            return undefined;
        }
        const outputId = match[1] || undefined;
        const scheme = match[2];
        return {
            outputId,
            notebook: uri.withScheme(scheme || 'file').withoutQuery()
        };
    }
    CellUri.parseCellOutputUri = parseCellOutputUri;
    function generateCellPropertyUri(notebook, handle, cellScheme) {
        return CellUri.generate(notebook, handle).withScheme(cellScheme);
    }
    CellUri.generateCellPropertyUri = generateCellPropertyUri;
    function parseCellPropertyUri(uri, propertyScheme) {
        if (uri.scheme !== propertyScheme) {
            return undefined;
        }
        return CellUri.parse(uri.withScheme(CellUri.cellUriScheme));
    }
    CellUri.parseCellPropertyUri = parseCellPropertyUri;
})(CellUri || (exports.CellUri = CellUri = {}));


/***/ }),

/***/ "../../node_modules/@theia/notebook/lib/common/notebook-range.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@theia/notebook/lib/common/notebook-range.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2023 Typefox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),

/***/ "../../node_modules/@theia/notebook/src/browser/style/index.css":
/*!**********************************************************************!*\
  !*** ../../node_modules/@theia/notebook/src/browser/style/index.css ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "../../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !!../../../../../css-loader/dist/cjs.js!./index.css */ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/notebook/src/browser/style/index.css");

            

var options = {};

options.insert = "head";
options.singleton = false;

var update = _style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__["default"], options);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_css_loader_dist_cjs_js_index_css__WEBPACK_IMPORTED_MODULE_1__["default"].locals || {});

/***/ }),

/***/ "../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/notebook/src/browser/style/index.css":
/*!****************************************************************************************************************!*\
  !*** ../../node_modules/css-loader/dist/cjs.js!../../node_modules/@theia/notebook/src/browser/style/index.css ***!
  \****************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../css-loader/dist/runtime/api.js */ "../../node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `/********************************************************************************
 * Copyright (C) 2023 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
 ********************************************************************************/

:root {
  --theia-notebook-markdown-size: 17px;
  --theia-notebook-cell-editor-margin-right: 10px;
}

.theia-notebook-cell-list {
  position: absolute;
  top: 0;
  width: 100%;
  overflow-y: auto;
  list-style: none;
  padding-left: 0px;
  background-color: var(--theia-notebook-editorBackground);
  z-index: 0;
  pointer-events: none;
}

.theia-notebook-cell-output-webview {
  padding: 5px 0px;
  margin: 0px 15px 0px 50px;
  width: calc(100% - 60px);
  position: absolute;
  z-index: 0;
}

.theia-notebook-cell {
  display: flex;
  margin: 10px 0px;
}

.theia-notebook-cell:focus {
  outline: none;
}

.theia-notebook-cell.draggable {
  cursor: grab;
}

.theia-notebook-cell:hover .theia-notebook-cell-marker {
  visibility: visible;
}

.theia-notebook-cell-marker {
  background-color: var(--theia-notebook-inactiveFocusedCellBorder);
  width: 3px;
  margin: 0px 8px 0px 4px;
  border-radius: 4px;
  visibility: hidden;
}

.theia-notebook-cell-marker-selected {
  visibility: visible;
  background-color: var(--theia-notebook-focusedCellBorder);
}

.theia-notebook-cell-marker:hover {
  width: 5px;
  margin: 0px 6px 0px 4px;
}

.theia-notebook-cell-content {
  flex: 1;
  /* needs this set width because of monaco. 56px is sidebar + gap to sidebar  */
  width: calc(100% - 56px);
}

/* Rendered Markdown Content */

.theia-notebook-markdown-content {
  pointer-events: all;
  padding: 8px 16px 8px 0px;
  font-size: var(--theia-notebook-markdown-size);
}

.theia-notebook-markdown-content > * {
  font-weight: 400;
}

.theia-notebook-markdown-content > *:first-child {
  margin-top: 0;
  padding-top: 0;
}

.theia-notebook-markdown-content > *:last-child {
  margin-bottom: 0;
  padding-bottom: 0;
}

.theia-notebook-markdown-sidebar {
  width: 35px;
}

/* Markdown cell edit mode */
.theia-notebook-cell-content:has(
    .theia-notebook-markdown-editor-container > .theia-notebook-cell-editor
  ) {
  pointer-events: all;
  margin-right: var(--theia-notebook-cell-editor-margin-right);
  outline: 1px solid var(--theia-notebook-cellBorderColor);
}

/* Markdown cell edit mode focused */
.theia-notebook-cell.focused
  .theia-notebook-cell-content:has(
    .theia-notebook-markdown-editor-container > .theia-notebook-cell-editor
  ) {
  outline-color: var(--theia-notebook-focusedEditorBorder);
}

.theia-notebook-empty-markdown {
  opacity: 0.6;
}

.theia-notebook-cell-editor {
  padding: 10px 10px 0 10px;
}

.theia-notebook-cell-editor .monaco-editor {
  outline: none;
}

.theia-notebook-cell-editor-container {
  pointer-events: all;
  width: calc(100% - 46px);
  flex: 1;
  outline: 1px solid var(--theia-notebook-cellBorderColor);
  margin: 0px 16px 0px 10px;
}

/* Only mark an editor cell focused if the editor has focus */
.theia-notebook-cell-editor-container:has(.monaco-editor.focused) {
  outline-color: var(--theia-notebook-focusedEditorBorder);
}

.notebook-cell-status {
  display: flex;
  flex-direction: row;
  font-size: 12px;
  height: 16px;
}

.notebook-cell-status-left {
  display: flex;
  flex-direction: row;
  flex-grow: 1;
}

.notebook-cell-language-label {
  padding: 0 5px;
}

.notebook-cell-language-label:hover {
  cursor: pointer;
  background-color: var(--theia-toolbar-hoverBackground);
}

.notebook-cell-status-item {
  margin: 0 3px;
  padding: 0 3px;
  display: flex;
  align-items: center;
}

.theia-notebook-cell-toolbar {
  pointer-events: all;
  border: 1px solid var(--theia-notebook-cellToolbarSeparator);
  display: flex;
  position: absolute;
  margin: -20px 0 0 66px;
  padding: 2px;
  background-color: var(--theia-editor-background);
}

.theia-notebook-cell-sidebar-toolbar {
  display: flex;
  flex-direction: column;
  padding: 2px;
  flex-grow: 1;
}

.theia-notebook-cell-sidebar {
  pointer-events: all;
  display: flex;
}

.theia-notebook-cell-sidebar-actions {
  display: flex;
  flex-direction: column;
}

.theia-notebook-code-cell-execution-order {
  display: block;
  font-family: var(--monaco-monospace-font);
  font-size: 10px;
  opacity: 0.7;
  text-align: center;
  white-space: pre;
  padding: 5px 0;
}

.theia-notebook-cell-toolbar-item {
  height: 18px;
  width: 18px;
}

.theia-notebook-cell-toolbar-item:hover {
  background-color: var(--theia-toolbar-hoverBackground);
}

.theia-notebook-cell-toolbar-item:active {
  background-color: var(--theia-toolbar-active);
}

.theia-notebook-cell-divider {
  pointer-events: all;
  height: 25px;
  width: 100%;
}

.theia-notebook-cell-with-sidebar {
  display: flex;
  flex-direction: row;
}

.theia-notebook-main-container {
  display: flex;
  flex-direction: column;
  height: 100%;
  overflow: hidden;
}

.theia-notebook-main-container:focus {
  outline: none;
}

.theia-notebook-main-container .theia-notebook-main-loading-indicator {
  /* \`progress-animation\` is defined in \`packages/core/src/browser/style/progress-bar.css\` */
  animation: progress-animation 1.8s 0s infinite
    cubic-bezier(0.645, 0.045, 0.355, 1);
  background-color: var(--theia-progressBar-background);
  height: 2px;
}

.error-message {
  justify-content: center;
  margin: 0 50px;
  text-align: center;
}

.error-message > span {
  color: var(--theia-errorForeground);
  font-size: 40px !important;
}

.theia-notebook-viewport {
  display: flex;
  overflow: hidden;
  height: 100%;
}

.theia-notebook-scroll-container {
  flex: 1;
  overflow: hidden;
  position: relative;
}

.theia-notebook-main-toolbar {
  background: var(--theia-editor-background);
  display: flex;
  flex-direction: row;
  z-index: 1;
  /*needed to be on rendered on top of monaco editors*/
}

.theia-notebook-main-toolbar-item {
  height: 22px;
  display: flex;
  align-items: center;
  margin: 0 4px;
  padding: 2px;
  text-align: center;
  color: var(--theia-foreground) !important;
  cursor: pointer;
}

.theia-notebook-main-toolbar-item.theia-mod-disabled:hover {
  background-color: transparent;
  cursor: default;
}

.theia-notebook-main-toolbar-item-text {
  padding: 0 4px;
  white-space: nowrap;
}

.theia-notebook-toolbar-separator {
  width: 1px;
  background-color: var(--theia-notebook-cellToolbarSeparator);
  margin: 0 4px;
}

.theia-notebook-add-cell-buttons {
  justify-content: center;
  display: flex;
}

.theia-notebook-add-cell-button {
  border: 1px solid var(--theia-notebook-cellToolbarSeparator);
  background-color: var(--theia-editor-background);
  color: var(--theia-foreground);
  display: flex;
  height: 24px;
  margin: 0 8px;
  padding: 2px 4px;
}

.theia-notebook-add-cell-button:hover {
  background-color: var(--theia-toolbar-hoverBackground);
}

.theia-notebook-add-cell-button:active {
  background-color: var(--theia-toolbar-active);
}

.theia-notebook-add-cell-button > * {
  vertical-align: middle;
}

.theia-notebook-add-cell-button-icon::before {
  font: normal normal normal 14px/1 codicon;
}

.theia-notebook-add-cell-button-text {
  margin: 1px 0 0 4px;
}

.theia-notebook-cell-drop-indicator {
  height: 2px;
  background-color: var(--theia-notebook-focusedCellBorder);
  width: 100%;
}

.theia-notebook-collapsed-output-container {
  width: 0;
  overflow: visible;
}

.theia-notebook-collapsed-output {
  text-wrap: nowrap;
  padding: 4px 8px;
  color: var(--theia-foreground);
  margin-left: 30px;
  font-size: 14px;
  line-height: 22px;
  opacity: 0.7;
}

.theia-notebook-drag-ghost-image {
  position: absolute;
  top: -99999px;
  left: -99999px;
  max-height: 500px;
  min-height: 100px;
  background-color: var(--theia-editor-background);
}

/* Notebook Find Widget */

.theia-notebook-overlay {
  position: absolute;
  z-index: 100;
  right: 18px;
}

.theia-notebook-find-widget {
  /* position: absolute;
  z-index: 35;
  height: 33px;
  overflow: hidden; */
  line-height: 19px;
  transition: transform 200ms linear;
  display: flex;
  flex-direction: row;
  padding: 0 4px;
  box-sizing: border-box;
  box-shadow: 0 0 8px 2px var(--theia-widget-shadow);
  background-color: var(--theia-editorWidget-background);
  color: var(--theia-editorWidget-foreground);
  border-left: 1px solid var(--theia-widget-border);
  border-right: 1px solid var(--theia-widget-border);
  border-bottom: 1px solid var(--theia-widget-border);
  border-bottom-left-radius: 4px;
  border-bottom-right-radius: 4px;
}

.theia-notebook-find-widget.hidden {
  display: none;
  transform: translateY(calc(-100% - 10px));
}

.theia-notebook-find-widget.search-mode > * > *:nth-child(2) {
  display: none;
}

.theia-notebook-find-widget-expand {
  display: flex;
  flex-direction: row;
  align-items: center;
  cursor: pointer;
  border-radius: 0;
  margin-right: 4px;
}

.theia-notebook-find-widget-expand:focus {
  outline: 1px solid var(--theia-focusBorder);
}

.theia-notebook-find-widget-expand:hover {
  background-color: var(--theia-toolbar-hoverBackground);
}

.theia-notebook-find-widget-buttons-first {
  margin-bottom: 4px;
  height: 26px;
  display: flex;
  flex-direction: row;
  align-items: center;
}

.theia-notebook-find-widget-buttons-first > div,
.theia-notebook-find-widget-buttons-second > div {
  margin-right: 4px;
}

.theia-notebook-find-widget-buttons-second {
  height: 26px;
  display: flex;
  flex-direction: row;
  align-items: center;
}

.theia-notebook-find-widget-inputs {
  margin-top: 4px;
  display: flex;
  flex-direction: column;
}

.theia-notebook-find-widget-buttons {
  margin-top: 4px;
  margin-left: 4px;
  display: flex;
  flex-direction: column;
}

.theia-notebook-find-widget-matches-count {
  width: 72px;
  box-sizing: border-box;
  overflow: hidden;
  text-align: center;
  text-overflow: ellipsis;
  white-space: nowrap;
}

.theia-notebook-find-widget-input-wrapper {
  display: flex;
  align-items: center;
  background: var(--theia-input-background);
  border-style: solid;
  border-width: var(--theia-border-width);
  border-color: var(--theia-input-background);
  border-radius: 2px;
  margin-bottom: 4px;
}

.theia-notebook-find-widget-input-wrapper:focus-within {
  border-color: var(--theia-focusBorder);
}

.theia-notebook-find-widget-input-wrapper .option.enabled {
  color: var(--theia-inputOption-activeForeground);
  outline: 1px solid var(--theia-inputOption-activeBorder);
  background-color: var(--theia-inputOption-activeBackground);
}

.theia-notebook-find-widget-input-wrapper .option {
  margin: 2px;
}

.theia-notebook-find-widget-input-wrapper
  .theia-notebook-find-widget-input:focus {
  border: none;
  outline: none;
}

.theia-notebook-find-widget-input-wrapper .theia-notebook-find-widget-input {
  background: none;
  border: none;
}

.theia-notebook-find-widget-replace {
  margin-bottom: 4px;
}

.theia-notebook-find-widget-buttons .disabled {
  opacity: 0.5;
}

mark.theia-find-match {
  color: var(--theia-editor-findMatchHighlightForeground);
  background-color: var(--theia-editor-findMatchHighlightBackground);
}

mark.theia-find-match.theia-find-match-selected {
  color: var(--theia-editor-findMatchForeground);
  background-color: var(--theia-editor-findMatchBackground);
}

.cell-status-bar-item {
  align-items: center;
  display: flex;
  height: 16px;
  margin: 0 3px;
  overflow: hidden;
  padding: 0 3px;
  text-overflow: clip;
  white-space: pre;
}

.cell-status-item-has-command {
  cursor: pointer;
}

.cell-status-item-has-command:hover {
  background-color: var(--theia-toolbar-hoverBackground);
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/@theia/notebook/src/browser/style/index.css"],"names":[],"mappings":"AAAA;;;;;;;;;;;;;;iFAciF;;AAEjF;EACE,oCAAoC;EACpC,+CAA+C;AACjD;;AAEA;EACE,kBAAkB;EAClB,MAAM;EACN,WAAW;EACX,gBAAgB;EAChB,gBAAgB;EAChB,iBAAiB;EACjB,wDAAwD;EACxD,UAAU;EACV,oBAAoB;AACtB;;AAEA;EACE,gBAAgB;EAChB,yBAAyB;EACzB,wBAAwB;EACxB,kBAAkB;EAClB,UAAU;AACZ;;AAEA;EACE,aAAa;EACb,gBAAgB;AAClB;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE,iEAAiE;EACjE,UAAU;EACV,uBAAuB;EACvB,kBAAkB;EAClB,kBAAkB;AACpB;;AAEA;EACE,mBAAmB;EACnB,yDAAyD;AAC3D;;AAEA;EACE,UAAU;EACV,uBAAuB;AACzB;;AAEA;EACE,OAAO;EACP,8EAA8E;EAC9E,wBAAwB;AAC1B;;AAEA,8BAA8B;;AAE9B;EACE,mBAAmB;EACnB,yBAAyB;EACzB,8CAA8C;AAChD;;AAEA;EACE,gBAAgB;AAClB;;AAEA;EACE,aAAa;EACb,cAAc;AAChB;;AAEA;EACE,gBAAgB;EAChB,iBAAiB;AACnB;;AAEA;EACE,WAAW;AACb;;AAEA,4BAA4B;AAC5B;;;EAGE,mBAAmB;EACnB,4DAA4D;EAC5D,wDAAwD;AAC1D;;AAEA,oCAAoC;AACpC;;;;EAIE,wDAAwD;AAC1D;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,yBAAyB;AAC3B;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,mBAAmB;EACnB,wBAAwB;EACxB,OAAO;EACP,wDAAwD;EACxD,yBAAyB;AAC3B;;AAEA,6DAA6D;AAC7D;EACE,wDAAwD;AAC1D;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,eAAe;EACf,YAAY;AACd;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,YAAY;AACd;;AAEA;EACE,cAAc;AAChB;;AAEA;EACE,eAAe;EACf,sDAAsD;AACxD;;AAEA;EACE,aAAa;EACb,cAAc;EACd,aAAa;EACb,mBAAmB;AACrB;;AAEA;EACE,mBAAmB;EACnB,4DAA4D;EAC5D,aAAa;EACb,kBAAkB;EAClB,sBAAsB;EACtB,YAAY;EACZ,gDAAgD;AAClD;;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,YAAY;EACZ,YAAY;AACd;;AAEA;EACE,mBAAmB;EACnB,aAAa;AACf;;AAEA;EACE,aAAa;EACb,sBAAsB;AACxB;;AAEA;EACE,cAAc;EACd,yCAAyC;EACzC,eAAe;EACf,YAAY;EACZ,kBAAkB;EAClB,gBAAgB;EAChB,cAAc;AAChB;;AAEA;EACE,YAAY;EACZ,WAAW;AACb;;AAEA;EACE,sDAAsD;AACxD;;AAEA;EACE,6CAA6C;AAC/C;;AAEA;EACE,mBAAmB;EACnB,YAAY;EACZ,WAAW;AACb;;AAEA;EACE,aAAa;EACb,mBAAmB;AACrB;;AAEA;EACE,aAAa;EACb,sBAAsB;EACtB,YAAY;EACZ,gBAAgB;AAClB;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,0FAA0F;EAC1F;wCACsC;EACtC,qDAAqD;EACrD,WAAW;AACb;;AAEA;EACE,uBAAuB;EACvB,cAAc;EACd,kBAAkB;AACpB;;AAEA;EACE,mCAAmC;EACnC,0BAA0B;AAC5B;;AAEA;EACE,aAAa;EACb,gBAAgB;EAChB,YAAY;AACd;;AAEA;EACE,OAAO;EACP,gBAAgB;EAChB,kBAAkB;AACpB;;AAEA;EACE,0CAA0C;EAC1C,aAAa;EACb,mBAAmB;EACnB,UAAU;EACV,oDAAoD;AACtD;;AAEA;EACE,YAAY;EACZ,aAAa;EACb,mBAAmB;EACnB,aAAa;EACb,YAAY;EACZ,kBAAkB;EAClB,yCAAyC;EACzC,eAAe;AACjB;;AAEA;EACE,6BAA6B;EAC7B,eAAe;AACjB;;AAEA;EACE,cAAc;EACd,mBAAmB;AACrB;;AAEA;EACE,UAAU;EACV,4DAA4D;EAC5D,aAAa;AACf;;AAEA;EACE,uBAAuB;EACvB,aAAa;AACf;;AAEA;EACE,4DAA4D;EAC5D,gDAAgD;EAChD,8BAA8B;EAC9B,aAAa;EACb,YAAY;EACZ,aAAa;EACb,gBAAgB;AAClB;;AAEA;EACE,sDAAsD;AACxD;;AAEA;EACE,6CAA6C;AAC/C;;AAEA;EACE,sBAAsB;AACxB;;AAEA;EACE,yCAAyC;AAC3C;;AAEA;EACE,mBAAmB;AACrB;;AAEA;EACE,WAAW;EACX,yDAAyD;EACzD,WAAW;AACb;;AAEA;EACE,QAAQ;EACR,iBAAiB;AACnB;;AAEA;EACE,iBAAiB;EACjB,gBAAgB;EAChB,8BAA8B;EAC9B,iBAAiB;EACjB,eAAe;EACf,iBAAiB;EACjB,YAAY;AACd;;AAEA;EACE,kBAAkB;EAClB,aAAa;EACb,cAAc;EACd,iBAAiB;EACjB,iBAAiB;EACjB,gDAAgD;AAClD;;AAEA,yBAAyB;;AAEzB;EACE,kBAAkB;EAClB,YAAY;EACZ,WAAW;AACb;;AAEA;EACE;;;qBAGmB;EACnB,iBAAiB;EACjB,kCAAkC;EAClC,aAAa;EACb,mBAAmB;EACnB,cAAc;EACd,sBAAsB;EACtB,kDAAkD;EAClD,sDAAsD;EACtD,2CAA2C;EAC3C,iDAAiD;EACjD,kDAAkD;EAClD,mDAAmD;EACnD,8BAA8B;EAC9B,+BAA+B;AACjC;;AAEA;EACE,aAAa;EACb,yCAAyC;AAC3C;;AAEA;EACE,aAAa;AACf;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,mBAAmB;EACnB,eAAe;EACf,gBAAgB;EAChB,iBAAiB;AACnB;;AAEA;EACE,2CAA2C;AAC7C;;AAEA;EACE,sDAAsD;AACxD;;AAEA;EACE,kBAAkB;EAClB,YAAY;EACZ,aAAa;EACb,mBAAmB;EACnB,mBAAmB;AACrB;;AAEA;;EAEE,iBAAiB;AACnB;;AAEA;EACE,YAAY;EACZ,aAAa;EACb,mBAAmB;EACnB,mBAAmB;AACrB;;AAEA;EACE,eAAe;EACf,aAAa;EACb,sBAAsB;AACxB;;AAEA;EACE,eAAe;EACf,gBAAgB;EAChB,aAAa;EACb,sBAAsB;AACxB;;AAEA;EACE,WAAW;EACX,sBAAsB;EACtB,gBAAgB;EAChB,kBAAkB;EAClB,uBAAuB;EACvB,mBAAmB;AACrB;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,yCAAyC;EACzC,mBAAmB;EACnB,uCAAuC;EACvC,2CAA2C;EAC3C,kBAAkB;EAClB,kBAAkB;AACpB;;AAEA;EACE,sCAAsC;AACxC;;AAEA;EACE,gDAAgD;EAChD,wDAAwD;EACxD,2DAA2D;AAC7D;;AAEA;EACE,WAAW;AACb;;AAEA;;EAEE,YAAY;EACZ,aAAa;AACf;;AAEA;EACE,gBAAgB;EAChB,YAAY;AACd;;AAEA;EACE,kBAAkB;AACpB;;AAEA;EACE,YAAY;AACd;;AAEA;EACE,uDAAuD;EACvD,kEAAkE;AACpE;;AAEA;EACE,8CAA8C;EAC9C,yDAAyD;AAC3D;;AAEA;EACE,mBAAmB;EACnB,aAAa;EACb,YAAY;EACZ,aAAa;EACb,gBAAgB;EAChB,cAAc;EACd,mBAAmB;EACnB,gBAAgB;AAClB;;AAEA;EACE,eAAe;AACjB;;AAEA;EACE,sDAAsD;AACxD","sourcesContent":["/********************************************************************************\n * Copyright (C) 2023 TypeFox and others.\n *\n * This program and the accompanying materials are made available under the\n * terms of the Eclipse Public License v. 2.0 which is available at\n * http://www.eclipse.org/legal/epl-2.0.\n *\n * This Source Code may also be made available under the following Secondary\n * Licenses when the conditions for such availability set forth in the Eclipse\n * Public License v. 2.0 are satisfied: GNU General Public License, version 2\n * with the GNU Classpath Exception which is available at\n * https://www.gnu.org/software/classpath/license.html.\n *\n * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0\n ********************************************************************************/\n\n:root {\n  --theia-notebook-markdown-size: 17px;\n  --theia-notebook-cell-editor-margin-right: 10px;\n}\n\n.theia-notebook-cell-list {\n  position: absolute;\n  top: 0;\n  width: 100%;\n  overflow-y: auto;\n  list-style: none;\n  padding-left: 0px;\n  background-color: var(--theia-notebook-editorBackground);\n  z-index: 0;\n  pointer-events: none;\n}\n\n.theia-notebook-cell-output-webview {\n  padding: 5px 0px;\n  margin: 0px 15px 0px 50px;\n  width: calc(100% - 60px);\n  position: absolute;\n  z-index: 0;\n}\n\n.theia-notebook-cell {\n  display: flex;\n  margin: 10px 0px;\n}\n\n.theia-notebook-cell:focus {\n  outline: none;\n}\n\n.theia-notebook-cell.draggable {\n  cursor: grab;\n}\n\n.theia-notebook-cell:hover .theia-notebook-cell-marker {\n  visibility: visible;\n}\n\n.theia-notebook-cell-marker {\n  background-color: var(--theia-notebook-inactiveFocusedCellBorder);\n  width: 3px;\n  margin: 0px 8px 0px 4px;\n  border-radius: 4px;\n  visibility: hidden;\n}\n\n.theia-notebook-cell-marker-selected {\n  visibility: visible;\n  background-color: var(--theia-notebook-focusedCellBorder);\n}\n\n.theia-notebook-cell-marker:hover {\n  width: 5px;\n  margin: 0px 6px 0px 4px;\n}\n\n.theia-notebook-cell-content {\n  flex: 1;\n  /* needs this set width because of monaco. 56px is sidebar + gap to sidebar  */\n  width: calc(100% - 56px);\n}\n\n/* Rendered Markdown Content */\n\n.theia-notebook-markdown-content {\n  pointer-events: all;\n  padding: 8px 16px 8px 0px;\n  font-size: var(--theia-notebook-markdown-size);\n}\n\n.theia-notebook-markdown-content > * {\n  font-weight: 400;\n}\n\n.theia-notebook-markdown-content > *:first-child {\n  margin-top: 0;\n  padding-top: 0;\n}\n\n.theia-notebook-markdown-content > *:last-child {\n  margin-bottom: 0;\n  padding-bottom: 0;\n}\n\n.theia-notebook-markdown-sidebar {\n  width: 35px;\n}\n\n/* Markdown cell edit mode */\n.theia-notebook-cell-content:has(\n    .theia-notebook-markdown-editor-container > .theia-notebook-cell-editor\n  ) {\n  pointer-events: all;\n  margin-right: var(--theia-notebook-cell-editor-margin-right);\n  outline: 1px solid var(--theia-notebook-cellBorderColor);\n}\n\n/* Markdown cell edit mode focused */\n.theia-notebook-cell.focused\n  .theia-notebook-cell-content:has(\n    .theia-notebook-markdown-editor-container > .theia-notebook-cell-editor\n  ) {\n  outline-color: var(--theia-notebook-focusedEditorBorder);\n}\n\n.theia-notebook-empty-markdown {\n  opacity: 0.6;\n}\n\n.theia-notebook-cell-editor {\n  padding: 10px 10px 0 10px;\n}\n\n.theia-notebook-cell-editor .monaco-editor {\n  outline: none;\n}\n\n.theia-notebook-cell-editor-container {\n  pointer-events: all;\n  width: calc(100% - 46px);\n  flex: 1;\n  outline: 1px solid var(--theia-notebook-cellBorderColor);\n  margin: 0px 16px 0px 10px;\n}\n\n/* Only mark an editor cell focused if the editor has focus */\n.theia-notebook-cell-editor-container:has(.monaco-editor.focused) {\n  outline-color: var(--theia-notebook-focusedEditorBorder);\n}\n\n.notebook-cell-status {\n  display: flex;\n  flex-direction: row;\n  font-size: 12px;\n  height: 16px;\n}\n\n.notebook-cell-status-left {\n  display: flex;\n  flex-direction: row;\n  flex-grow: 1;\n}\n\n.notebook-cell-language-label {\n  padding: 0 5px;\n}\n\n.notebook-cell-language-label:hover {\n  cursor: pointer;\n  background-color: var(--theia-toolbar-hoverBackground);\n}\n\n.notebook-cell-status-item {\n  margin: 0 3px;\n  padding: 0 3px;\n  display: flex;\n  align-items: center;\n}\n\n.theia-notebook-cell-toolbar {\n  pointer-events: all;\n  border: 1px solid var(--theia-notebook-cellToolbarSeparator);\n  display: flex;\n  position: absolute;\n  margin: -20px 0 0 66px;\n  padding: 2px;\n  background-color: var(--theia-editor-background);\n}\n\n.theia-notebook-cell-sidebar-toolbar {\n  display: flex;\n  flex-direction: column;\n  padding: 2px;\n  flex-grow: 1;\n}\n\n.theia-notebook-cell-sidebar {\n  pointer-events: all;\n  display: flex;\n}\n\n.theia-notebook-cell-sidebar-actions {\n  display: flex;\n  flex-direction: column;\n}\n\n.theia-notebook-code-cell-execution-order {\n  display: block;\n  font-family: var(--monaco-monospace-font);\n  font-size: 10px;\n  opacity: 0.7;\n  text-align: center;\n  white-space: pre;\n  padding: 5px 0;\n}\n\n.theia-notebook-cell-toolbar-item {\n  height: 18px;\n  width: 18px;\n}\n\n.theia-notebook-cell-toolbar-item:hover {\n  background-color: var(--theia-toolbar-hoverBackground);\n}\n\n.theia-notebook-cell-toolbar-item:active {\n  background-color: var(--theia-toolbar-active);\n}\n\n.theia-notebook-cell-divider {\n  pointer-events: all;\n  height: 25px;\n  width: 100%;\n}\n\n.theia-notebook-cell-with-sidebar {\n  display: flex;\n  flex-direction: row;\n}\n\n.theia-notebook-main-container {\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n  overflow: hidden;\n}\n\n.theia-notebook-main-container:focus {\n  outline: none;\n}\n\n.theia-notebook-main-container .theia-notebook-main-loading-indicator {\n  /* `progress-animation` is defined in `packages/core/src/browser/style/progress-bar.css` */\n  animation: progress-animation 1.8s 0s infinite\n    cubic-bezier(0.645, 0.045, 0.355, 1);\n  background-color: var(--theia-progressBar-background);\n  height: 2px;\n}\n\n.error-message {\n  justify-content: center;\n  margin: 0 50px;\n  text-align: center;\n}\n\n.error-message > span {\n  color: var(--theia-errorForeground);\n  font-size: 40px !important;\n}\n\n.theia-notebook-viewport {\n  display: flex;\n  overflow: hidden;\n  height: 100%;\n}\n\n.theia-notebook-scroll-container {\n  flex: 1;\n  overflow: hidden;\n  position: relative;\n}\n\n.theia-notebook-main-toolbar {\n  background: var(--theia-editor-background);\n  display: flex;\n  flex-direction: row;\n  z-index: 1;\n  /*needed to be on rendered on top of monaco editors*/\n}\n\n.theia-notebook-main-toolbar-item {\n  height: 22px;\n  display: flex;\n  align-items: center;\n  margin: 0 4px;\n  padding: 2px;\n  text-align: center;\n  color: var(--theia-foreground) !important;\n  cursor: pointer;\n}\n\n.theia-notebook-main-toolbar-item.theia-mod-disabled:hover {\n  background-color: transparent;\n  cursor: default;\n}\n\n.theia-notebook-main-toolbar-item-text {\n  padding: 0 4px;\n  white-space: nowrap;\n}\n\n.theia-notebook-toolbar-separator {\n  width: 1px;\n  background-color: var(--theia-notebook-cellToolbarSeparator);\n  margin: 0 4px;\n}\n\n.theia-notebook-add-cell-buttons {\n  justify-content: center;\n  display: flex;\n}\n\n.theia-notebook-add-cell-button {\n  border: 1px solid var(--theia-notebook-cellToolbarSeparator);\n  background-color: var(--theia-editor-background);\n  color: var(--theia-foreground);\n  display: flex;\n  height: 24px;\n  margin: 0 8px;\n  padding: 2px 4px;\n}\n\n.theia-notebook-add-cell-button:hover {\n  background-color: var(--theia-toolbar-hoverBackground);\n}\n\n.theia-notebook-add-cell-button:active {\n  background-color: var(--theia-toolbar-active);\n}\n\n.theia-notebook-add-cell-button > * {\n  vertical-align: middle;\n}\n\n.theia-notebook-add-cell-button-icon::before {\n  font: normal normal normal 14px/1 codicon;\n}\n\n.theia-notebook-add-cell-button-text {\n  margin: 1px 0 0 4px;\n}\n\n.theia-notebook-cell-drop-indicator {\n  height: 2px;\n  background-color: var(--theia-notebook-focusedCellBorder);\n  width: 100%;\n}\n\n.theia-notebook-collapsed-output-container {\n  width: 0;\n  overflow: visible;\n}\n\n.theia-notebook-collapsed-output {\n  text-wrap: nowrap;\n  padding: 4px 8px;\n  color: var(--theia-foreground);\n  margin-left: 30px;\n  font-size: 14px;\n  line-height: 22px;\n  opacity: 0.7;\n}\n\n.theia-notebook-drag-ghost-image {\n  position: absolute;\n  top: -99999px;\n  left: -99999px;\n  max-height: 500px;\n  min-height: 100px;\n  background-color: var(--theia-editor-background);\n}\n\n/* Notebook Find Widget */\n\n.theia-notebook-overlay {\n  position: absolute;\n  z-index: 100;\n  right: 18px;\n}\n\n.theia-notebook-find-widget {\n  /* position: absolute;\n  z-index: 35;\n  height: 33px;\n  overflow: hidden; */\n  line-height: 19px;\n  transition: transform 200ms linear;\n  display: flex;\n  flex-direction: row;\n  padding: 0 4px;\n  box-sizing: border-box;\n  box-shadow: 0 0 8px 2px var(--theia-widget-shadow);\n  background-color: var(--theia-editorWidget-background);\n  color: var(--theia-editorWidget-foreground);\n  border-left: 1px solid var(--theia-widget-border);\n  border-right: 1px solid var(--theia-widget-border);\n  border-bottom: 1px solid var(--theia-widget-border);\n  border-bottom-left-radius: 4px;\n  border-bottom-right-radius: 4px;\n}\n\n.theia-notebook-find-widget.hidden {\n  display: none;\n  transform: translateY(calc(-100% - 10px));\n}\n\n.theia-notebook-find-widget.search-mode > * > *:nth-child(2) {\n  display: none;\n}\n\n.theia-notebook-find-widget-expand {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n  cursor: pointer;\n  border-radius: 0;\n  margin-right: 4px;\n}\n\n.theia-notebook-find-widget-expand:focus {\n  outline: 1px solid var(--theia-focusBorder);\n}\n\n.theia-notebook-find-widget-expand:hover {\n  background-color: var(--theia-toolbar-hoverBackground);\n}\n\n.theia-notebook-find-widget-buttons-first {\n  margin-bottom: 4px;\n  height: 26px;\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n}\n\n.theia-notebook-find-widget-buttons-first > div,\n.theia-notebook-find-widget-buttons-second > div {\n  margin-right: 4px;\n}\n\n.theia-notebook-find-widget-buttons-second {\n  height: 26px;\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n}\n\n.theia-notebook-find-widget-inputs {\n  margin-top: 4px;\n  display: flex;\n  flex-direction: column;\n}\n\n.theia-notebook-find-widget-buttons {\n  margin-top: 4px;\n  margin-left: 4px;\n  display: flex;\n  flex-direction: column;\n}\n\n.theia-notebook-find-widget-matches-count {\n  width: 72px;\n  box-sizing: border-box;\n  overflow: hidden;\n  text-align: center;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n\n.theia-notebook-find-widget-input-wrapper {\n  display: flex;\n  align-items: center;\n  background: var(--theia-input-background);\n  border-style: solid;\n  border-width: var(--theia-border-width);\n  border-color: var(--theia-input-background);\n  border-radius: 2px;\n  margin-bottom: 4px;\n}\n\n.theia-notebook-find-widget-input-wrapper:focus-within {\n  border-color: var(--theia-focusBorder);\n}\n\n.theia-notebook-find-widget-input-wrapper .option.enabled {\n  color: var(--theia-inputOption-activeForeground);\n  outline: 1px solid var(--theia-inputOption-activeBorder);\n  background-color: var(--theia-inputOption-activeBackground);\n}\n\n.theia-notebook-find-widget-input-wrapper .option {\n  margin: 2px;\n}\n\n.theia-notebook-find-widget-input-wrapper\n  .theia-notebook-find-widget-input:focus {\n  border: none;\n  outline: none;\n}\n\n.theia-notebook-find-widget-input-wrapper .theia-notebook-find-widget-input {\n  background: none;\n  border: none;\n}\n\n.theia-notebook-find-widget-replace {\n  margin-bottom: 4px;\n}\n\n.theia-notebook-find-widget-buttons .disabled {\n  opacity: 0.5;\n}\n\nmark.theia-find-match {\n  color: var(--theia-editor-findMatchHighlightForeground);\n  background-color: var(--theia-editor-findMatchHighlightBackground);\n}\n\nmark.theia-find-match.theia-find-match-selected {\n  color: var(--theia-editor-findMatchForeground);\n  background-color: var(--theia-editor-findMatchBackground);\n}\n\n.cell-status-bar-item {\n  align-items: center;\n  display: flex;\n  height: 16px;\n  margin: 0 3px;\n  overflow: hidden;\n  padding: 0 3px;\n  text-overflow: clip;\n  white-space: pre;\n}\n\n.cell-status-item-has-command {\n  cursor: pointer;\n}\n\n.cell-status-item-has-command:hover {\n  background-color: var(--theia-toolbar-hoverBackground);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_notebook_lib_browser_notebook-frontend-module_js.js.map