"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-anthropic_lib_browser_anthropic-frontend-module_js"],{

/***/ "../../node_modules/@theia/ai-anthropic/lib/browser/anthropic-frontend-application-contribution.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-anthropic/lib/browser/anthropic-frontend-application-contribution.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AnthropicFrontendApplicationContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/ai-anthropic/lib/common/index.js");
const anthropic_preferences_1 = __webpack_require__(/*! ./anthropic-preferences */ "../../node_modules/@theia/ai-anthropic/lib/browser/anthropic-preferences.js");
const ANTHROPIC_PROVIDER_ID = 'anthropic';
// Model-specific maxTokens values
const DEFAULT_MODEL_MAX_TOKENS = {
    'claude-3-opus-latest': 4096,
    'claude-3-5-haiku-latest': 8192,
    'claude-3-5-sonnet-latest': 8192,
    'claude-3-7-sonnet-latest': 64000
};
let AnthropicFrontendApplicationContribution = class AnthropicFrontendApplicationContribution {
    constructor() {
        this.prevModels = [];
    }
    onStart() {
        this.preferenceService.ready.then(() => {
            const apiKey = this.preferenceService.get(anthropic_preferences_1.API_KEY_PREF, undefined);
            this.manager.setApiKey(apiKey);
            const models = this.preferenceService.get(anthropic_preferences_1.MODELS_PREF, []);
            this.manager.createOrUpdateLanguageModels(...models.map(modelId => this.createAnthropicModelDescription(modelId)));
            this.prevModels = [...models];
            this.preferenceService.onPreferenceChanged(event => {
                if (event.preferenceName === anthropic_preferences_1.API_KEY_PREF) {
                    this.manager.setApiKey(event.newValue);
                }
                else if (event.preferenceName === anthropic_preferences_1.MODELS_PREF) {
                    this.handleModelChanges(event.newValue);
                }
            });
        });
    }
    handleModelChanges(newModels) {
        const oldModels = new Set(this.prevModels);
        const updatedModels = new Set(newModels);
        const modelsToRemove = [...oldModels].filter(model => !updatedModels.has(model));
        const modelsToAdd = [...updatedModels].filter(model => !oldModels.has(model));
        this.manager.removeLanguageModels(...modelsToRemove.map(model => `${ANTHROPIC_PROVIDER_ID}/${model}`));
        this.manager.createOrUpdateLanguageModels(...modelsToAdd.map(modelId => this.createAnthropicModelDescription(modelId)));
        this.prevModels = newModels;
    }
    createAnthropicModelDescription(modelId) {
        const id = `${ANTHROPIC_PROVIDER_ID}/${modelId}`;
        const maxTokens = DEFAULT_MODEL_MAX_TOKENS[modelId];
        const description = {
            id: id,
            model: modelId,
            apiKey: true,
            enableStreaming: true,
            useCaching: true
        };
        if (maxTokens !== undefined) {
            description.maxTokens = maxTokens;
        }
        return description;
    }
};
exports.AnthropicFrontendApplicationContribution = AnthropicFrontendApplicationContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], AnthropicFrontendApplicationContribution.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.AnthropicLanguageModelsManager),
    tslib_1.__metadata("design:type", Object)
], AnthropicFrontendApplicationContribution.prototype, "manager", void 0);
exports.AnthropicFrontendApplicationContribution = AnthropicFrontendApplicationContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AnthropicFrontendApplicationContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-anthropic/lib/browser/anthropic-frontend-module.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-anthropic/lib/browser/anthropic-frontend-module.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const anthropic_preferences_1 = __webpack_require__(/*! ./anthropic-preferences */ "../../node_modules/@theia/ai-anthropic/lib/browser/anthropic-preferences.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const anthropic_frontend_application_contribution_1 = __webpack_require__(/*! ./anthropic-frontend-application-contribution */ "../../node_modules/@theia/ai-anthropic/lib/browser/anthropic-frontend-application-contribution.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/ai-anthropic/lib/common/index.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    bind(browser_1.PreferenceContribution).toConstantValue({ schema: anthropic_preferences_1.AnthropicPreferencesSchema });
    bind(anthropic_frontend_application_contribution_1.AnthropicFrontendApplicationContribution).toSelf().inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).toService(anthropic_frontend_application_contribution_1.AnthropicFrontendApplicationContribution);
    bind(common_1.AnthropicLanguageModelsManager).toDynamicValue(ctx => {
        const provider = ctx.container.get(browser_1.RemoteConnectionProvider);
        return provider.createProxy(common_1.ANTHROPIC_LANGUAGE_MODELS_MANAGER_PATH);
    }).inSingletonScope();
});


/***/ }),

/***/ "../../node_modules/@theia/ai-anthropic/lib/browser/anthropic-preferences.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-anthropic/lib/browser/anthropic-preferences.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AnthropicPreferencesSchema = exports.MODELS_PREF = exports.API_KEY_PREF = void 0;
const ai_core_preferences_1 = __webpack_require__(/*! @theia/ai-core/lib/browser/ai-core-preferences */ "../../node_modules/@theia/ai-core/lib/browser/ai-core-preferences.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
exports.API_KEY_PREF = 'ai-features.anthropic.AnthropicApiKey';
exports.MODELS_PREF = 'ai-features.anthropic.AnthropicModels';
exports.AnthropicPreferencesSchema = {
    type: 'object',
    properties: {
        [exports.API_KEY_PREF]: {
            type: 'string',
            markdownDescription: core_1.nls.localize('theia/ai/anthropic/apiKey/description', 'Enter an API Key of your official Anthropic Account. **Please note:** By using this preference the Anthropic API key will be stored in clear text\
            on the machine running Theia. Use the environment variable `ANTHROPIC_API_KEY` to set the key securely.'),
            title: ai_core_preferences_1.AI_CORE_PREFERENCES_TITLE,
        },
        [exports.MODELS_PREF]: {
            type: 'array',
            description: core_1.nls.localize('theia/ai/anthropic/models/description', 'Official Anthropic models to use'),
            title: ai_core_preferences_1.AI_CORE_PREFERENCES_TITLE,
            default: ['claude-3-7-sonnet-latest', 'claude-3-5-sonnet-latest', 'claude-3-5-haiku-latest', 'claude-3-opus-latest'],
            items: {
                type: 'string'
            }
        },
    }
};


/***/ }),

/***/ "../../node_modules/@theia/ai-anthropic/lib/common/anthropic-language-models-manager.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-anthropic/lib/common/anthropic-language-models-manager.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AnthropicLanguageModelsManager = exports.ANTHROPIC_LANGUAGE_MODELS_MANAGER_PATH = void 0;
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
exports.ANTHROPIC_LANGUAGE_MODELS_MANAGER_PATH = '/services/anthropic/language-model-manager';
exports.AnthropicLanguageModelsManager = Symbol('AnthropicLanguageModelsManager');


/***/ }),

/***/ "../../node_modules/@theia/ai-anthropic/lib/common/index.js":
/*!******************************************************************!*\
  !*** ../../node_modules/@theia/ai-anthropic/lib/common/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
tslib_1.__exportStar(__webpack_require__(/*! ./anthropic-language-models-manager */ "../../node_modules/@theia/ai-anthropic/lib/common/anthropic-language-models-manager.js"), exports);


/***/ }),

/***/ "../../node_modules/@theia/ai-core/lib/browser/ai-core-preferences.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-core/lib/browser/ai-core-preferences.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getRequestSettingSpecificity = exports.bindAICorePreferences = exports.AICorePreferences = exports.aiCorePreferenceSchema = exports.PREFERENCE_NAME_REQUEST_SETTINGS = exports.PREFERENCE_NAME_PROMPT_TEMPLATES = exports.PREFERENCE_NAME_ENABLE_AI = exports.AI_CORE_PREFERENCES_TITLE = void 0;
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const injectable_preference_proxy_1 = __webpack_require__(/*! @theia/core/lib/browser/preferences/injectable-preference-proxy */ "../../node_modules/@theia/core/lib/browser/preferences/injectable-preference-proxy.js");
exports.AI_CORE_PREFERENCES_TITLE = core_1.nls.localize('theia/ai/core/prefs/title', '✨ AI Features [Alpha]');
exports.PREFERENCE_NAME_ENABLE_AI = 'ai-features.AiEnable.enableAI';
exports.PREFERENCE_NAME_PROMPT_TEMPLATES = 'ai-features.promptTemplates.promptTemplatesFolder';
exports.PREFERENCE_NAME_REQUEST_SETTINGS = 'ai-features.modelSettings.requestSettings';
exports.aiCorePreferenceSchema = {
    type: 'object',
    properties: {
        [exports.PREFERENCE_NAME_ENABLE_AI]: {
            title: exports.AI_CORE_PREFERENCES_TITLE,
            markdownDescription: core_1.nls.localize('theia/ai/core/enableAI/mdDescription', '❗ This setting allows you to access the latest AI capabilities (Alpha version).\
            \n\
            Please note that these features are in an alpha phase, which means they may \
            undergo changes and will be further improved. It is important to be aware that these features may generate\
            continuous requests to the language models (LLMs) you provide access to. This might incur costs that you\
            need to monitor closely. By enabling this option, you acknowledge these risks.\
            \n\
            **Please note! The settings below in this section will only take effect\n\
            once the main feature setting is enabled. After enabling the feature, you need to configure at least one\
            LLM provider below. Also see [the documentation](https://theia-ide.org/docs/user_ai/)**.'),
            type: 'boolean',
            default: false,
        },
        [exports.PREFERENCE_NAME_PROMPT_TEMPLATES]: {
            title: exports.AI_CORE_PREFERENCES_TITLE,
            description: core_1.nls.localize('theia/ai/core/promptTemplates/description', 'Folder for storing customized prompt templates. If not customized the user config directory is used. Please consider to use a folder, which is\
            under version control to manage your variants of prompt templates.'),
            type: 'string',
            default: '',
            typeDetails: {
                isFilepath: true,
                selectionProps: {
                    openLabel: 'Select Folder',
                    canSelectFiles: false,
                    canSelectFolders: true,
                    canSelectMany: false
                }
            },
        },
        [exports.PREFERENCE_NAME_REQUEST_SETTINGS]: {
            title: core_1.nls.localize('theia/ai/core/requestSettings/title', 'Custom Request Settings'),
            markdownDescription: core_1.nls.localize('theia/ai/core/requestSettings/mdDescription', 'Allows specifying custom request settings for multiple models.\n\
            Each setting consists of:\n\
            - `scope`: Defines when the setting applies:\n\
              - `modelId` (optional): The model ID to match\n\
              - `providerId` (optional): The provider ID to match (e.g., huggingface, openai, ollama, llamafile)\n\
              - `agentId` (optional): The agent ID to match\n\
            - `requestSettings`: Model-specific settings as key-value pairs\n\
            - `clientSettings`: Client-side message handling settings:\n\
              - `keepToolCalls` (boolean): Whether to keep tool calls in the context\n\
              - `keepThinking` (boolean): Whether to keep thinking messages\n\
            Settings are matched based on specificity (agent: 100, model: 10, provider: 1 points).\n\
            Refer to [our documentation](https://theia-ide.org/docs/user_ai/#custom-request-settings) for more information.'),
            type: 'array',
            items: {
                type: 'object',
                properties: {
                    scope: {
                        type: 'object',
                        properties: {
                            modelId: {
                                type: 'string',
                                description: 'The (optional) model id'
                            },
                            providerId: {
                                type: 'string',
                                description: 'The (optional) provider id to apply the settings to.',
                            }, agentId: {
                                type: 'string',
                                description: 'The (optional) agent id to apply the settings to.',
                            },
                        }
                    },
                    requestSettings: {
                        type: 'object',
                        additionalProperties: true,
                        description: 'Settings for the specific model ID.',
                    },
                    clientSettings: {
                        type: 'object',
                        additionalProperties: false,
                        description: 'Client settings for how to handle messages that are send back to the llm.',
                        properties: {
                            keepToolCalls: {
                                type: 'boolean',
                                default: true,
                                description: 'If set to false, all tool request and tool responses will be filtered \
                                before sending the next user request in a multi-turn conversation.'
                            },
                            keepThinking: {
                                type: 'boolean',
                                default: true,
                                description: 'If set to false, all thinking output will be filtered before sending the next user request in a multi-turn conversation.'
                            }
                        }
                    },
                },
                additionalProperties: false
            },
            default: [],
        }
    }
};
exports.AICorePreferences = Symbol('AICorePreferences');
function bindAICorePreferences(bind) {
    bind(exports.AICorePreferences).toDynamicValue(ctx => {
        const factory = ctx.container.get(injectable_preference_proxy_1.PreferenceProxyFactory);
        return factory(exports.aiCorePreferenceSchema);
    }).inSingletonScope();
    bind(browser_1.PreferenceContribution).toConstantValue({ schema: exports.aiCorePreferenceSchema });
}
exports.bindAICorePreferences = bindAICorePreferences;
/**
 * Calculates the specificity score of a RequestSetting for a given scope.
 * The score is calculated based on matching criteria:
 * - Agent match: 100 points
 * - Model match: 10 points
 * - Provider match: 1 point
 *
 * @param setting RequestSetting object to check against
 * @param scope Optional scope object containing modelId, providerId, and agentId
 * @returns Specificity score (-1 for non-match, or sum of matching criteria points)
 */
const getRequestSettingSpecificity = (setting, scope) => {
    // If no scope is defined in the setting, return default specificity
    if (!setting.scope) {
        return 0;
    }
    // If no matching criteria are defined in the scope, return default specificity
    if (!setting.scope.modelId && !setting.scope.providerId && !setting.scope.agentId) {
        return 0;
    }
    // Check for explicit non-matches (return -1)
    if ((scope === null || scope === void 0 ? void 0 : scope.modelId) && setting.scope.modelId && setting.scope.modelId !== scope.modelId) {
        return -1;
    }
    if ((scope === null || scope === void 0 ? void 0 : scope.providerId) && setting.scope.providerId && setting.scope.providerId !== scope.providerId) {
        return -1;
    }
    if ((scope === null || scope === void 0 ? void 0 : scope.agentId) && setting.scope.agentId && setting.scope.agentId !== scope.agentId) {
        return -1;
    }
    let specificity = 0;
    // Check provider match (1 point)
    if ((scope === null || scope === void 0 ? void 0 : scope.providerId) && setting.scope.providerId === scope.providerId) {
        specificity += 1;
    }
    // Check model match (10 points)
    if ((scope === null || scope === void 0 ? void 0 : scope.modelId) && setting.scope.modelId === scope.modelId) {
        specificity += 10;
    }
    // Check agent match (100 points)
    if ((scope === null || scope === void 0 ? void 0 : scope.agentId) && setting.scope.agentId === scope.agentId) {
        specificity += 100;
    }
    return specificity;
};
exports.getRequestSettingSpecificity = getRequestSettingSpecificity;


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-anthropic_lib_browser_anthropic-frontend-module_js.js.map