/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.cds;

import java.util.ArrayList;

public class CDSOptions {
    public String xShareMode = "on";
    public String archiveName;
    public ArrayList<String> prefix = new ArrayList();
    public ArrayList<String> suffix = new ArrayList();
    public boolean useSystemArchive = false;
    public String appJar;
    public String appJarDir;
    public String[] classList;
    public boolean useVersion = true;
    static ArrayList<String> disabledRuntimePrefixes = new ArrayList();

    public CDSOptions addPrefix(String ... prefix) {
        for (String s : prefix) {
            this.prefix.add(s);
        }
        return this;
    }

    public CDSOptions addPrefix(String[] prefix, String ... extra) {
        for (String s : prefix) {
            this.prefix.add(s);
        }
        for (String s : extra) {
            this.prefix.add(s);
        }
        return this;
    }

    public CDSOptions addSuffix(ArrayList<String> suffix) {
        for (String s : suffix) {
            this.suffix.add(s);
        }
        return this;
    }

    public CDSOptions addSuffix(String ... suffix) {
        for (String s : suffix) {
            this.suffix.add(s);
        }
        return this;
    }

    public CDSOptions addSuffix(String[] suffix, String ... extra) {
        for (String s : suffix) {
            this.suffix.add(s);
        }
        for (String s : extra) {
            this.suffix.add(s);
        }
        return this;
    }

    public CDSOptions setXShareMode(String mode) {
        this.xShareMode = mode;
        return this;
    }

    public CDSOptions setArchiveName(String name) {
        this.archiveName = name;
        return this;
    }

    public CDSOptions setUseVersion(boolean use) {
        this.useVersion = use;
        return this;
    }

    public CDSOptions setUseSystemArchive(boolean use) {
        this.useSystemArchive = use;
        return this;
    }

    public CDSOptions setClassList(String[] list) {
        this.classList = list;
        return this;
    }

    public CDSOptions setClassList(ArrayList<String> list) {
        String[] array = new String[list.size()];
        list.toArray(array);
        this.classList = array;
        return this;
    }

    public CDSOptions setAppJar(String appJar) {
        this.appJar = appJar;
        return this;
    }

    public CDSOptions setAppJarDir(String appJarDir) {
        this.appJarDir = appJarDir;
        return this;
    }

    private static void disableRuntimePrefix(String s) {
        disabledRuntimePrefixes.add(s);
    }

    public static void disableRuntimePrefixForEpsilonGC() {
        CDSOptions.disableRuntimePrefix("-XX:+UseEpsilonGC");
    }
}

