/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class MetalworksDocumentFrame
extends JInternalFrame {
    static int openFrameCount = 0;
    static final int offset = 30;

    public MetalworksDocumentFrame() {
        super("", true, true, true, true);
        this.setTitle("Untitled Message " + ++openFrameCount);
        JPanel top = new JPanel();
        top.setBorder(new EmptyBorder(10, 10, 10, 10));
        top.setLayout(new BorderLayout());
        top.add((Component)this.buildAddressPanel(), "North");
        JTextArea content = new JTextArea(15, 30);
        content.setBorder(new EmptyBorder(0, 5, 0, 5));
        content.setLineWrap(true);
        JScrollPane textScroller = new JScrollPane(content, 22, 30);
        top.add((Component)textScroller, "Center");
        this.setContentPane(top);
        this.pack();
        this.setLocation(30 * openFrameCount, 30 * openFrameCount);
    }

    private JPanel buildAddressPanel() {
        JPanel p = new JPanel();
        p.setLayout(new LabeledPairLayout());
        JLabel toLabel = new JLabel("To: ", 4);
        JTextField toField = new JTextField(25);
        p.add((Component)toLabel, "label");
        p.add((Component)toField, "field");
        JLabel subLabel = new JLabel("Subj: ", 4);
        JTextField subField = new JTextField(25);
        p.add((Component)subLabel, "label");
        p.add((Component)subField, "field");
        JLabel ccLabel = new JLabel("cc: ", 4);
        JTextField ccField = new JTextField(25);
        p.add((Component)ccLabel, "label");
        p.add((Component)ccField, "field");
        return p;
    }

    class LabeledPairLayout
    implements LayoutManager {
        List<Component> labels = new ArrayList<Component>();
        List<Component> fields = new ArrayList<Component>();
        int yGap = 2;
        int xGap = 2;

        LabeledPairLayout() {
        }

        @Override
        public void addLayoutComponent(String s, Component c) {
            if (s.equals("label")) {
                this.labels.add(c);
            } else {
                this.fields.add(c);
            }
        }

        @Override
        public void layoutContainer(Container c) {
            Insets insets = c.getInsets();
            int labelWidth = 0;
            for (Component comp : this.labels) {
                labelWidth = Math.max(labelWidth, comp.getPreferredSize().width);
            }
            int yPos = insets.top;
            ListIterator<Component> fieldIter = this.fields.listIterator();
            ListIterator<Component> labelIter = this.labels.listIterator();
            while (labelIter.hasNext() && fieldIter.hasNext()) {
                JComponent label = (JComponent)labelIter.next();
                JComponent field = (JComponent)fieldIter.next();
                int height = Math.max(label.getPreferredSize().height, field.getPreferredSize().height);
                label.setBounds(insets.left, yPos, labelWidth, height);
                field.setBounds(insets.left + labelWidth + this.xGap, yPos, c.getSize().width - (labelWidth + this.xGap + insets.left + insets.right), height);
                yPos += height + this.yGap;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Insets insets = c.getInsets();
            int labelWidth = 0;
            for (Component comp : this.labels) {
                labelWidth = Math.max(labelWidth, comp.getPreferredSize().width);
            }
            int yPos = insets.top;
            ListIterator<Component> labelIter = this.labels.listIterator();
            ListIterator<Component> fieldIter = this.fields.listIterator();
            while (labelIter.hasNext() && fieldIter.hasNext()) {
                Component label = (Component)labelIter.next();
                Component field = (Component)fieldIter.next();
                int height = Math.max(label.getPreferredSize().height, field.getPreferredSize().height);
                yPos += height + this.yGap;
            }
            return new Dimension(labelWidth * 3, yPos);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            Dimension d = this.minimumLayoutSize(c);
            d.width *= 2;
            return d;
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }
    }
}

