/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.tar.TarEntry;
import org.eclipse.wst.server.core.internal.tar.TarInputStream;

public class InstallableRuntime2
implements IInstallableRuntime {
    private IConfigurationElement element;
    private byte[] BUFFER = null;
    private int DEFAULT_DOWNLOAD_SIZE = 10000000;
    private int DEFAULT_FILE_COUNT = 1000;

    public InstallableRuntime2(IConfigurationElement element) {
        this.element = element;
    }

    @Override
    public String getId() {
        try {
            return this.element.getAttribute("id");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getName() {
        return this.getArchivePath();
    }

    public String getArchiveUrl() {
        try {
            return this.element.getAttribute("archiveUrl");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getArchivePath() {
        try {
            return this.element.getAttribute("archivePath");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getArchiveSize() {
        try {
            String size = this.element.getAttribute("archiveSize");
            return Integer.parseInt(size);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getFileCount() {
        try {
            String size = this.element.getAttribute("fileCount");
            return Integer.parseInt(size);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getLicenseURL() {
        try {
            return this.element.getAttribute("licenseUrl");
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public String getLicense(IProgressMonitor monitor) throws CoreException {
        String licenseURL;
        ByteArrayOutputStream out;
        URL url;
        block16: {
            url = null;
            out = null;
            licenseURL = this.getLicenseURL();
            if (licenseURL != null) break block16;
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
            return null;
        }
        url = new URL(licenseURL);
        URLConnection connection = url.openConnection();
        String possibleNewURL = connection.getHeaderField("Location");
        while (possibleNewURL != null) {
            connection = new URL(possibleNewURL).openConnection();
            possibleNewURL = connection.getHeaderField("Location");
        }
        InputStream in = connection.getInputStream();
        out = new ByteArrayOutputStream();
        this.copyWithSize(in, out, null, 0);
        String string = new String(out.toByteArray());
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (Exception e) {
            try {
                if (Trace.WARNING) {
                    Trace.trace("/warning", "Error loading license", e);
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
    }

    @Override
    public void install(final IPath path) {
        Job installRuntimeJob = new Job(Messages.jobInstallingRuntime){

            public boolean belongsTo(Object family) {
                return "org.eclipse.wst.server.core".equals(family);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    InstallableRuntime2.this.install(path, monitor);
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        installRuntimeJob.schedule();
    }

    private void copyWithSize(InputStream in, OutputStream out, IProgressMonitor monitor, int size) throws IOException {
        if (this.BUFFER == null) {
            this.BUFFER = new byte[8192];
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)size);
        int r = in.read(this.BUFFER);
        while (r >= 0) {
            out.write(this.BUFFER, 0, r);
            progress.worked(r);
            r = in.read(this.BUFFER);
        }
    }

    private void download(InputStream in, OutputStream out, IProgressMonitor monitor, String name, int size) throws IOException {
        if (this.BUFFER == null) {
            this.BUFFER = new byte[8192];
        }
        String msg = NLS.bind((String)(size > 0 ? Messages.taskDownloadSizeKnown : Messages.taskDownloadSizeUnknown), (Object[])new Object[]{name, "{0}", Integer.toString(size / 1024)});
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)msg, (Object)"0"), (int)(size > 0 ? size : this.DEFAULT_DOWNLOAD_SIZE));
        int r = in.read(this.BUFFER);
        int total = 0;
        int lastTotal = 0;
        while (r >= 0) {
            out.write(this.BUFFER, 0, r);
            if ((total += r) >= lastTotal + 8192) {
                lastTotal = total;
                progress.subTask(NLS.bind((String)msg, (Object)Integer.toString(lastTotal / 1024)));
            }
            progress.worked(r);
            if (size <= 0) {
                progress.setWorkRemaining(this.DEFAULT_DOWNLOAD_SIZE);
            }
            if (progress.isCanceled()) break;
            r = in.read(this.BUFFER);
        }
    }

    @Override
    public void install(IPath path, IProgressMonitor monitor) throws CoreException {
        InputStream in;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        URL url = null;
        File temp = null;
        try {
            url = new URL(this.getArchiveUrl());
            temp = File.createTempFile("runtime", "");
            temp.deleteOnExit();
        }
        catch (IOException e) {
            if (monitor != null) {
                monitor.done();
            }
            if (Trace.WARNING) {
                Trace.trace("/warning", "Error creating url and temp file", e);
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
        }
        String name = url.getQuery() != null ? url.getQuery() : url.getPath();
        int slashIdx = name.lastIndexOf(47);
        if (slashIdx >= 0) {
            name = name.substring(slashIdx + 1);
        }
        int archiveSize = this.getArchiveSize();
        FileOutputStream fout = null;
        try {
            try {
                in = url.openStream();
                fout = new FileOutputStream(temp);
                this.download(in, fout, (IProgressMonitor)progress.newChild(500), name, archiveSize);
                progress.setWorkRemaining(500);
            }
            catch (Exception e) {
                if (monitor != null) {
                    monitor.done();
                }
                if (Trace.WARNING) {
                    Trace.trace("/warning", "Error downloading runtime", e);
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (fout != null) {
                fout.close();
            }
        }
        catch (IOException iOException) {}
        if (progress.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        in = null;
        try {
            try {
                in = new FileInputStream(temp);
                if (name.endsWith("zip")) {
                    this.unzip(in, path, (IProgressMonitor)progress.newChild(500));
                } else if (name.endsWith("tar")) {
                    this.untar(in, path, (IProgressMonitor)progress.newChild(500));
                } else if (name.endsWith("tar.gz")) {
                    File tarFile = File.createTempFile("runtime", ".tar");
                    tarFile.deleteOnExit();
                    String tarName = name;
                    if (slashIdx >= 0) {
                        tarName = name.substring(0, name.length() - 3);
                    }
                    progress.subTask(NLS.bind((String)Messages.taskUncompressing, (Object)tarName));
                    int tempSize = Integer.MAX_VALUE;
                    if (temp.length() < Integer.MAX_VALUE) {
                        tempSize = (int)temp.length();
                    }
                    this.ungzip(in, tarFile, (IProgressMonitor)progress.newChild(250), tempSize);
                    progress.setWorkRemaining(250);
                    if (!progress.isCanceled()) {
                        in = new FileInputStream(tarFile);
                        this.untar(in, path, (IProgressMonitor)progress.newChild(250));
                    }
                }
            }
            catch (Exception e) {
                if (Trace.SEVERE) {
                    Trace.trace("/severe", "Error uncompressing runtime", e);
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    ((FileInputStream)in).close();
                }
            }
            catch (IOException iOException) {}
            progress.done();
            throw throwable;
        }
        try {
            if (in != null) {
                ((FileInputStream)in).close();
            }
        }
        catch (IOException iOException) {}
        progress.done();
    }

    private void unzip(InputStream in, IPath path, IProgressMonitor monitor) throws IOException {
        int fileCnt = this.getFileCount();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(fileCnt > 0 ? fileCnt : this.DEFAULT_FILE_COUNT));
        this.getArchivePath();
        BufferedInputStream bin = new BufferedInputStream(in);
        ZipInputStream zin = new ZipInputStream(bin);
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            progress.subTask(NLS.bind((String)Messages.taskUncompressing, (Object)name));
            if (name != null && name.length() > 0) {
                if (entry.isDirectory()) {
                    path.append(name).toFile().mkdirs();
                } else {
                    FileOutputStream fout = new FileOutputStream(path.append(name).toFile());
                    this.copyWithSize(zin, fout, (IProgressMonitor)progress.newChild(1), (int)entry.getSize());
                    fout.close();
                    if (fileCnt <= 0) {
                        progress.setWorkRemaining(this.DEFAULT_FILE_COUNT);
                    }
                }
            }
            zin.closeEntry();
            entry = zin.getNextEntry();
        }
        zin.close();
    }

    protected void untar(InputStream in, IPath path, IProgressMonitor monitor) throws IOException {
        int fileCnt = this.getFileCount();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(fileCnt > 0 ? fileCnt : 500));
        this.getArchivePath();
        BufferedInputStream bin = new BufferedInputStream(in);
        TarInputStream zin = new TarInputStream(bin);
        TarEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            progress.subTask(NLS.bind((String)Messages.taskUncompressing, (Object)name));
            if (name != null && name.length() > 0) {
                if (entry.getFileType() == 53) {
                    path.append(name).toFile().mkdirs();
                } else {
                    File dir = path.append(name).removeLastSegments(1).toFile();
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    FileOutputStream fout = new FileOutputStream(path.append(name).toFile());
                    this.copyWithSize(zin, fout, (IProgressMonitor)progress.newChild(1), (int)entry.getSize());
                    fout.close();
                    if (fileCnt <= 0) {
                        progress.setWorkRemaining(500);
                    }
                }
            }
            entry = zin.getNextEntry();
        }
        zin.close();
    }

    protected void ungzip(InputStream in, File tarFile, IProgressMonitor monitor, int size) throws IOException {
        GZIPInputStream gzin = null;
        FileOutputStream fout = null;
        try {
            gzin = new GZIPInputStream(in);
            fout = new FileOutputStream(tarFile);
            this.copyWithSize(gzin, fout, monitor, size);
        }
        catch (Throwable throwable) {
            if (gzin != null) {
                try {
                    gzin.close();
                }
                catch (IOException iOException) {}
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            throw throwable;
        }
        if (gzin != null) {
            try {
                gzin.close();
            }
            catch (IOException iOException) {}
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String toString() {
        return "InstallableRuntime2[" + this.getId() + "]";
    }
}

