/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.databinding;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.ValueProperty;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.databinding.ListeningValue;

public class ActiveWindowProperty<S extends IWorkbench>
extends ValueProperty<S, IWorkbenchWindow> {
    public Object getValueType() {
        return IWorkbenchWindow.class;
    }

    protected IWorkbenchWindow doGetValue(S source) {
        return source.getActiveWorkbenchWindow();
    }

    protected void doSetValue(S source, IWorkbenchWindow value) {
        throw new UnsupportedOperationException();
    }

    public IObservableValue<IWorkbenchWindow> observe(Realm realm, final S source) {
        return new ListeningValue<IWorkbenchWindow>(realm){
            private final IWindowListener listener;
            {
                super($anonymous0);
                this.listener = new IWindowListener(){

                    @Override
                    public void windowActivated(IWorkbenchWindow window) {
                        this.protectedSetValue(window);
                    }

                    @Override
                    public void windowDeactivated(IWorkbenchWindow window) {
                        if (window == this.doGetValue()) {
                            this.protectedSetValue(null);
                        }
                    }

                    @Override
                    public void windowClosed(IWorkbenchWindow window) {
                    }

                    @Override
                    public void windowOpened(IWorkbenchWindow window) {
                    }
                };
            }

            @Override
            protected void startListening() {
                source.addWindowListener(this.listener);
            }

            @Override
            protected void stopListening() {
                source.removeWindowListener(this.listener);
            }

            @Override
            protected IWorkbenchWindow calculate() {
                return (IWorkbenchWindow)ActiveWindowProperty.this.getValue(source);
            }

            public Object getValueType() {
                return ActiveWindowProperty.this.getValueType();
            }
        };
    }
}

