/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.command;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.genericeditor.target.extension.model.LocationNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.Node;
import org.eclipse.pde.internal.genericeditor.target.extension.model.RepositoryCache;
import org.eclipse.pde.internal.genericeditor.target.extension.model.UnitNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.xml.Parser;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class UpdateUnitVersions
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDocument document = this.getDocument();
        return CompletableFuture.supplyAsync(() -> {
            if (document == null) {
                return null;
            }
            Node rootNode = null;
            Parser parser = Parser.getDefault();
            try {
                rootNode = parser.parse(document);
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
            if (rootNode == null) {
                return null;
            }
            List<Node> locationsNode = rootNode.getChildNodesByTag("locations");
            if (locationsNode == null || locationsNode.isEmpty()) {
                return null;
            }
            int offsetChange = 0;
            Object documentText = document.get();
            List<LocationNode> locationNodes = locationsNode.get(0).getChildNodesByTag("location").stream().map(LocationNode.class::cast).toList();
            locationNodes.stream().map(LocationNode::getRepositoryLocations).flatMap(Collection::stream).forEach(RepositoryCache::prefetchP2MetadataOfRepository);
            for (LocationNode locationNode : locationNodes) {
                List<String> repositoryLocations = locationNode.getRepositoryLocations();
                if (repositoryLocations.isEmpty()) continue;
                Map<String, List<IVersionedId>> repositoryUnits = RepositoryCache.fetchP2UnitsFromRepos(repositoryLocations);
                for (Node n2 : locationNode.getChildNodesByTag("unit")) {
                    String version;
                    List<IVersionedId> versions;
                    UnitNode unitNode = (UnitNode)n2;
                    String declaredVersion = unitNode.getVersion();
                    boolean isValidExplicitVersion = VersionUtil.validateVersion((String)declaredVersion).isOK();
                    if (declaredVersion == null || !isValidExplicitVersion || (versions = repositoryUnits.get(unitNode.getId())) == null || versions.isEmpty() || (version = versions.get(0).getVersion().toString()).isEmpty() || version.equals(declaredVersion)) continue;
                    String nodeString = ((String)documentText).substring(unitNode.getOffsetStart() + offsetChange, unitNode.getOffsetEnd() + offsetChange);
                    nodeString = nodeString.replaceFirst("version=\"" + declaredVersion + "\"", "version=\"" + version + "\"");
                    documentText = ((String)documentText).substring(0, unitNode.getOffsetStart() + offsetChange) + nodeString + ((String)documentText).substring(unitNode.getOffsetEnd() + offsetChange, ((String)documentText).length());
                    offsetChange += version.length() - declaredVersion.length();
                }
            }
            if (document.get().equals(documentText)) {
                Display.getDefault().asyncExec(() -> MessageDialog.openInformation(null, (String)"No Version Updates", (String)"There are no version updates required for this document."));
            } else {
                String newText = documentText;
                Display.getDefault().asyncExec(() -> document.set(newText));
            }
            return documentText;
        });
    }

    private IDocument getDocument() {
        IPageChangeProvider pageChangeProvider;
        Object object;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IDocumentProvider provider = null;
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            provider = textEditor.getDocumentProvider();
        } else if (editor instanceof IPageChangeProvider && (object = (pageChangeProvider = (IPageChangeProvider)editor).getSelectedPage()) instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)object;
            provider = textEditor.getDocumentProvider();
        }
        if (provider == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        return provider.getDocument((Object)input);
    }
}

