/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessorCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;

public final class AddAllMissingJavadocTagsProposalCore
extends LinkedCorrectionProposalCore {
    private final ASTNode fDecl;

    public AddAllMissingJavadocTagsProposalCore(String label, ICompilationUnit cu, ASTNode decl, int relevance) {
        super(label, cu, (ASTRewrite)null, relevance);
        this.fDecl = decl;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        ASTRewrite rewrite = ASTRewrite.create((AST)this.fDecl.getAST());
        if (this.fDecl instanceof MethodDeclaration) {
            this.insertAllMissingMethodTags(rewrite, (MethodDeclaration)this.fDecl);
        } else if (this.fDecl instanceof RecordDeclaration) {
            this.insertAllMissingRecordTypeTags(rewrite, (RecordDeclaration)this.fDecl);
        } else {
            this.insertAllMissingTypeTags(rewrite, (TypeDeclaration)this.fDecl);
        }
        return rewrite;
    }

    private void insertAllMissingMethodTags(ASTRewrite rewriter, MethodDeclaration methodDecl) {
        Type type;
        AST ast = methodDecl.getAST();
        Javadoc javadoc = methodDecl.getJavadoc();
        ListRewrite tagsRewriter = rewriter.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
        List typeParams = methodDecl.typeParameters();
        ArrayList<CallSite> typeParamNames = new ArrayList<CallSite>();
        int i = typeParams.size() - 1;
        while (i >= 0) {
            TypeParameter decl = (TypeParameter)typeParams.get(i);
            String name = "<" + decl.getName().getIdentifier() + ">";
            if (JavadocTagsSubProcessorCore.findTag(javadoc, "@param", name) == null) {
                TagElement newTag = ast.newTagElement();
                newTag.setTagName("@param");
                TextElement text = ast.newTextElement();
                text.setText(name);
                newTag.fragments().add(text);
                this.insertTabStop(rewriter, newTag.fragments(), "typeParam" + i);
                JavadocTagsSubProcessorCore.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessorCore.getPreviousTypeParamNames(typeParams, (ASTNode)decl));
            }
            typeParamNames.add((CallSite)((Object)name));
            --i;
        }
        List params = methodDecl.parameters();
        int i2 = params.size() - 1;
        while (i2 >= 0) {
            SingleVariableDeclaration decl = (SingleVariableDeclaration)params.get(i2);
            String name = decl.getName().getIdentifier();
            if (JavadocTagsSubProcessorCore.findTag(javadoc, "@param", name) == null) {
                TagElement newTag = ast.newTagElement();
                newTag.setTagName("@param");
                newTag.fragments().add(ast.newSimpleName(name));
                this.insertTabStop(rewriter, newTag.fragments(), "methParam" + i2);
                Set<String> sameKindLeadingNames = JavadocTagsSubProcessorCore.getPreviousParamNames(params, (ASTNode)decl);
                sameKindLeadingNames.addAll(typeParamNames);
                JavadocTagsSubProcessorCore.insertTag(tagsRewriter, newTag, sameKindLeadingNames);
            }
            --i2;
        }
        if (!(methodDecl.isConstructor() || (type = methodDecl.getReturnType2()).isPrimitiveType() && ((PrimitiveType)type).getPrimitiveTypeCode() == PrimitiveType.VOID || JavadocTagsSubProcessorCore.findTag(javadoc, "@return", null) != null)) {
            TagElement newTag = ast.newTagElement();
            newTag.setTagName("@return");
            this.insertTabStop(rewriter, newTag.fragments(), "return");
            JavadocTagsSubProcessorCore.insertTag(tagsRewriter, newTag, null);
        }
        List thrownExceptions = methodDecl.thrownExceptionTypes();
        int i3 = thrownExceptions.size() - 1;
        while (i3 >= 0) {
            String name;
            Type exception = (Type)thrownExceptions.get(i3);
            ITypeBinding binding = exception.resolveBinding();
            if (binding != null && JavadocTagsSubProcessorCore.findThrowsTag(javadoc, name = binding.getName()) == null) {
                TagElement newTag = ast.newTagElement();
                newTag.setTagName("@throws");
                TextElement excNode = ast.newTextElement();
                excNode.setText(ASTNodes.getQualifiedTypeName(exception));
                newTag.fragments().add(excNode);
                this.insertTabStop(rewriter, newTag.fragments(), "exception" + i3);
                JavadocTagsSubProcessorCore.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessorCore.getPreviousExceptionNames(thrownExceptions, (ASTNode)exception));
            }
            --i3;
        }
    }

    private void insertAllMissingTypeTags(ASTRewrite rewriter, TypeDeclaration typeDecl) {
        AST ast = typeDecl.getAST();
        Javadoc javadoc = typeDecl.getJavadoc();
        ListRewrite tagsRewriter = rewriter.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
        List typeParams = typeDecl.typeParameters();
        int i = typeParams.size() - 1;
        while (i >= 0) {
            TypeParameter decl = (TypeParameter)typeParams.get(i);
            String name = "<" + decl.getName().getIdentifier() + ">";
            if (JavadocTagsSubProcessorCore.findTag(javadoc, "@param", name) == null) {
                TagElement newTag = ast.newTagElement();
                newTag.setTagName("@param");
                TextElement text = ast.newTextElement();
                text.setText(name);
                newTag.fragments().add(text);
                this.insertTabStop(rewriter, newTag.fragments(), "typeParam" + i);
                JavadocTagsSubProcessorCore.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessorCore.getPreviousTypeParamNames(typeParams, (ASTNode)decl));
            }
            --i;
        }
    }

    private void insertAllMissingRecordTypeTags(ASTRewrite rewriter, RecordDeclaration recDecl) {
        AST ast = recDecl.getAST();
        Javadoc javadoc = recDecl.getJavadoc();
        ListRewrite tagsRewriter = rewriter.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
        List recComps = recDecl.recordComponents();
        int i = recComps.size() - 1;
        while (i >= 0) {
            SingleVariableDeclaration decl = (SingleVariableDeclaration)recComps.get(i);
            String name = decl.getName().getIdentifier();
            if (JavadocTagsSubProcessorCore.findTag(javadoc, "@param", name) == null) {
                TagElement newTag = ast.newTagElement();
                newTag.setTagName("@param");
                TextElement text = ast.newTextElement();
                text.setText(name);
                newTag.fragments().add(text);
                this.insertTabStop(rewriter, newTag.fragments(), "recComps" + i);
                JavadocTagsSubProcessorCore.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessorCore.getPreviousParamNames(recComps, (ASTNode)decl));
            }
            --i;
        }
        List typeParams = recDecl.typeParameters();
        int i2 = typeParams.size() - 1;
        while (i2 >= 0) {
            TypeParameter decl = (TypeParameter)typeParams.get(i2);
            String name = "<" + decl.getName().getIdentifier() + ">";
            if (JavadocTagsSubProcessorCore.findTag(javadoc, "@param", name) == null) {
                TagElement newTag = ast.newTagElement();
                newTag.setTagName("@param");
                TextElement text = ast.newTextElement();
                text.setText(name);
                newTag.fragments().add(text);
                this.insertTabStop(rewriter, newTag.fragments(), "typeParam" + i2);
                JavadocTagsSubProcessorCore.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessorCore.getPreviousTypeParamNames(typeParams, (ASTNode)decl));
            }
            --i2;
        }
    }

    private void insertTabStop(ASTRewrite rewriter, List<ASTNode> fragments, String linkedName) {
        TextElement textElement = rewriter.getAST().newTextElement();
        textElement.setText("");
        fragments.add((ASTNode)textElement);
        this.addLinkedPosition(rewriter.track((ASTNode)textElement), false, linkedName);
    }
}

