/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.design.editparts;

import java.util.Iterator;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Font;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.CenteredConnectionAnchor;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.ColumnEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.StructureEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.TypeReferenceConnection;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.FocusTypeColumn;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IComplexType;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IType;

public class ComplexTypeEditPart
extends StructureEditPart {
    private Font italicFont;

    protected boolean shouldDrawConnection() {
        if (this.getParent().getModel() instanceof FocusTypeColumn) {
            IComplexType complexType = (IComplexType)this.getModel();
            return complexType.getSuperType() != null;
        }
        return false;
    }

    private EditPart getTargetEditPart(IType type) {
        ColumnEditPart columnEditPart = null;
        ComplexTypeEditPart editPart = this;
        while (editPart != null) {
            if (editPart instanceof ColumnEditPart) {
                columnEditPart = (ColumnEditPart)((Object)editPart);
                break;
            }
            editPart = editPart.getParent();
        }
        if (columnEditPart != null) {
            Iterator i = columnEditPart.getChildren().iterator();
            while (i.hasNext()) {
                EditPart child = (EditPart)i.next();
                if (child.getModel() != type) continue;
                return child;
            }
        }
        return null;
    }

    public TypeReferenceConnection createConnectionFigure() {
        AbstractGraphicalEditPart referenceTypePart;
        this.connectionFigure = null;
        IComplexType complexType = (IComplexType)this.getModel();
        IType type = complexType.getSuperType();
        if (type != null && (referenceTypePart = (AbstractGraphicalEditPart)this.getTargetEditPart(type)) != null) {
            this.connectionFigure = new TypeReferenceConnection(true);
            this.connectionFigure.setSourceAnchor((ConnectionAnchor)new CenteredConnectionAnchor(this.getFigure(), 0, 1));
            this.connectionFigure.setTargetAnchor((ConnectionAnchor)new CenteredConnectionAnchor(referenceTypePart.getFigure(), 1, 0, 0));
            this.connectionFigure.setConnectionRouter((ConnectionRouter)new ManhattanConnectionRouter());
            ((CenteredConnectionAnchor)this.connectionFigure.getSourceAnchor()).setOther((CenteredConnectionAnchor)this.connectionFigure.getTargetAnchor());
            this.connectionFigure.setHighlight(false);
        }
        return this.connectionFigure;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        Label label = this.getNameLabelFigure();
        IComplexType complexType = (IComplexType)this.getModel();
        if (complexType.isAbstract()) {
            if (this.italicFont == null) {
                Font font = label.getFont();
                this.italicFont = this.getItalicFont(font);
            }
            if (this.italicFont != null) {
                label.setFont(this.italicFont);
            }
        } else {
            label.setFont(label.getParent().getFont());
        }
    }

    public void deactivate() {
        if (this.italicFont != null) {
            this.italicFont.dispose();
            this.italicFont = null;
        }
        super.deactivate();
    }
}

