/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.archive;

import java.beans.Statement;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.eclipse.jgit.archive.internal.ArchiveText;
import org.eclipse.jgit.util.StringUtils;

public class BaseFormat {
    protected static final String COMPRESSION_LEVEL = "compression-level";

    protected ArchiveOutputStream<? extends ArchiveEntry> applyFormatOptions(ArchiveOutputStream<? extends ArchiveEntry> s, Map<String, Object> o) throws IOException {
        for (Map.Entry<String, Object> p : o.entrySet()) {
            try {
                if (p.getKey().equals(COMPRESSION_LEVEL)) continue;
                new Statement(s, "set" + StringUtils.capitalize((String)p.getKey()), new Object[]{p.getValue()}).execute();
            }
            catch (Exception e) {
                throw new IOException(MessageFormat.format(ArchiveText.get().cannotSetOption, p.getKey()), e);
            }
        }
        return s;
    }

    protected int getCompressionLevel(Map<String, Object> o) {
        if (!o.containsKey(COMPRESSION_LEVEL)) {
            return -1;
        }
        Object option = o.get(COMPRESSION_LEVEL);
        try {
            Integer compressionLevel = (Integer)option;
            return compressionLevel;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(MessageFormat.format(ArchiveText.get().invalidCompressionLevel, option), e);
        }
    }
}

