/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.viewmodel;

import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.VMViewerUpdateTracing;
import org.eclipse.cdt.dsf.internal.DsfPlugin;
import org.eclipse.cdt.dsf.internal.LoggingUtils;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.ui.viewmodel.VMViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.jface.viewers.TreePath;

public class VMChildrenCountUpdate
extends VMViewerUpdate
implements IChildrenCountUpdate {
    private final DataRequestMonitor<Integer> fCountRequestMonitor;

    public VMChildrenCountUpdate(IViewerUpdate clientUpdate, DataRequestMonitor<Integer> rm) {
        super(clientUpdate, (RequestMonitor)rm);
        this.fCountRequestMonitor = rm;
    }

    public VMChildrenCountUpdate(IModelDelta delta, IPresentationContext presentationContext, DataRequestMonitor<Integer> rm) {
        super(delta, presentationContext, (RequestMonitor)rm);
        this.fCountRequestMonitor = rm;
    }

    public VMChildrenCountUpdate(TreePath elementPath, Object viewerInput, IPresentationContext presentationContext, DataRequestMonitor<Integer> rm) {
        super(elementPath, viewerInput, presentationContext, (RequestMonitor)rm);
        this.fCountRequestMonitor = rm;
    }

    public void setChildCount(int count) {
        this.fCountRequestMonitor.setData((Object)count);
    }

    public String toString() {
        return "VMChildrenCountUpdate: " + String.valueOf(this.getElement());
    }

    @Override
    public void done() {
        assert (this.isCanceled() || this.fCountRequestMonitor.getData() != null || !this.fCountRequestMonitor.isSuccess());
        if (VMViewerUpdateTracing.DEBUG_VMUPDATES && !this.isCanceled() && VMViewerUpdateTracing.matchesFilterRegex(((Object)((Object)this)).getClass())) {
            Integer data = (Integer)this.fCountRequestMonitor.getData();
            DsfUIPlugin.debug(DsfPlugin.getDebugTime() + " " + LoggingUtils.toString((Object)((Object)this)) + " marked done; element = " + LoggingUtils.toString((Object)this.getElement()) + "\n   child count = " + String.valueOf(data != null ? data : "<unset>"));
        }
        super.done();
    }
}

