/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotatableType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.RedundantNullnessTypeAnnotationsFilter;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsFixCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class NullAnnotationsRewriteOperations {
    static final String TYPE_USE_NAME = ElementType.class.getName() + "." + ElementType.TYPE_USE.name();

    private NullAnnotationsRewriteOperations() {
    }

    static class AddMissingDefaultNullnessRewriteOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private IProblemLocation fProblem;
        private CompilationUnit fCompilationUnit;

        public AddMissingDefaultNullnessRewriteOperation(CompilationUnit compilationUnit, IProblemLocation problem) {
            this.fCompilationUnit = compilationUnit;
            this.fProblem = problem;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            PackageDeclaration packageDeclaration;
            if (this.fProblem.getProblemId() == 536871825 && (packageDeclaration = this.fCompilationUnit.getPackage()) != null) {
                String nonNullByDefaultAnnotationname = NullAnnotationsFixCore.getNonNullByDefaultAnnotationName(this.fCompilationUnit.getJavaElement(), true);
                String label = Messages.format(FixMessages.NullAnnotationsRewriteOperations_add_missing_default_nullness_annotation, new String[]{nonNullByDefaultAnnotationname});
                TextEditGroup group = this.createTextEditGroup(label, cuRewrite);
                ASTRewrite astRewrite = cuRewrite.getASTRewrite();
                AST ast = cuRewrite.getRoot().getAST();
                ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)packageDeclaration, PackageDeclaration.ANNOTATIONS_PROPERTY);
                MarkerAnnotation newAnnotation = ast.newMarkerAnnotation();
                String annotationToAdd = NullAnnotationsFixCore.getNonNullByDefaultAnnotationName(this.fCompilationUnit.getJavaElement(), false);
                newAnnotation.setTypeName(ast.newName(annotationToAdd));
                listRewrite.insertLast((ASTNode)newAnnotation, group);
                return;
            }
        }
    }

    public static class Builder {
        IProblemLocation fProblem;
        ChangeKind fChangeKind;
        CompilationUnit fUnit;
        String fAnnotationToAdd;
        String fAnnotationToRemove;
        boolean fAllowRemove;
        boolean fAffectsParameter;
        boolean fUseNullTypeAnnotations;

        public Builder(IProblemLocation problem, CompilationUnit unit, String annotationToAdd, String annotationToRemove, boolean allowRemove, boolean affectsParameter, ChangeKind changeKind) {
            this.fChangeKind = changeKind;
            this.fUnit = unit;
            this.fAnnotationToAdd = annotationToAdd;
            this.fAnnotationToRemove = annotationToRemove;
            this.fAllowRemove = allowRemove;
            this.fAffectsParameter = affectsParameter;
            this.fProblem = problem;
            this.fUseNullTypeAnnotations = this.usesNullTypeAnnotations(unit.getJavaElement(), annotationToAdd);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private boolean usesNullTypeAnnotations(IJavaElement cu, String annotationName) {
            IJavaProject project = (IJavaProject)cu.getAncestor(2);
            try {
                IType annotationType = project.findType(annotationName);
                if (annotationType == null) {
                    return false;
                }
                IAnnotation[] iAnnotationArray = annotationType.getAnnotations();
                int n = iAnnotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotation annotation = iAnnotationArray[n2];
                    if (annotationType.isBinary()) {
                        if (annotation.getElementName().equals(Target.class.getName())) {
                            IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
                            int n3 = iMemberValuePairArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IMemberValuePair valuePair = iMemberValuePairArray[n4];
                                Object value = valuePair.getValue();
                                if (value instanceof Object[]) {
                                    Object[] objectArray = (Object[])value;
                                    int n5 = objectArray.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        Object val = objectArray[n6];
                                        if (TYPE_USE_NAME.equals(val)) {
                                            return true;
                                        }
                                        ++n6;
                                    }
                                } else if (TYPE_USE_NAME.equals(value)) {
                                    return true;
                                }
                                ++n4;
                            }
                            return false;
                        }
                    } else {
                        String[][] resolveType = annotationType.resolveType(annotation.getElementName());
                        if (resolveType != null && resolveType.length == 1 && resolveType[0][0].equals(Target.class.getPackage().getName()) && resolveType[0][1].equals(Target.class.getSimpleName())) {
                            IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
                            int n7 = iMemberValuePairArray.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                IMemberValuePair valuePair = iMemberValuePairArray[n8];
                                Object value = valuePair.getValue();
                                if (value instanceof String) {
                                    if (((String)value).endsWith(ElementType.TYPE_USE.name())) {
                                        return true;
                                    }
                                } else if (value instanceof Object[]) {
                                    Object[] objectArray = (Object[])value;
                                    int n9 = objectArray.length;
                                    int n10 = 0;
                                    while (n10 < n9) {
                                        Object v = objectArray[n10];
                                        if (v instanceof String && ((String)v).endsWith(ElementType.TYPE_USE.name())) {
                                            return true;
                                        }
                                        ++n10;
                                    }
                                }
                                ++n8;
                            }
                            return false;
                        }
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                JavaManipulationPlugin.log(e);
            }
            return false;
        }

        public boolean requiresExplicitAnnotation() {
            switch (this.fProblem.getProblemId()) {
                case 67109803: 
                case 67109804: {
                    return this.fChangeKind != ChangeKind.OVERRIDDEN;
                }
            }
            return false;
        }

        public void swapAnnotations() {
            String tmp = this.fAnnotationToAdd;
            this.fAnnotationToAdd = this.fAnnotationToRemove;
            this.fAnnotationToRemove = tmp;
        }

        public ASTNode getCoveringNode() {
            return this.fProblem.getCoveringNode(this.fUnit);
        }

        public SignatureAnnotationRewriteOperation createAddAnnotationOperation(Set<String> handledPositions, boolean thisUnitOnly, ChangeKind changeKind) {
            SignatureAnnotationRewriteOperation result = changeKind == ChangeKind.OVERRIDDEN ? this.createAddAnnotationToOverriddenOperation() : this.createAddAnnotationOperation(changeKind == ChangeKind.TARGET, thisUnitOnly);
            if (handledPositions != null && result != null) {
                if (handledPositions.contains(result.getKey())) {
                    return null;
                }
                handledPositions.add(result.getKey());
            }
            return result;
        }

        private SignatureAnnotationRewriteOperation createAddAnnotationOperation(boolean changeTargetMethod, boolean thisUnitOnly) {
            ASTNode selectedNode = this.getCoveringNode();
            if (selectedNode == null) {
                return null;
            }
            ICompilationUnit cu = (ICompilationUnit)this.fUnit.getJavaElement();
            ASTNode declaringNode = Builder.getDeclaringNode(selectedNode);
            switch (this.fProblem.getProblemId()) {
                case 67109780: {
                    break;
                }
                case 67109778: {
                    if (declaringNode != null) break;
                    declaringNode = selectedNode;
                    break;
                }
                default: {
                    if (this.fAllowRemove || !NullAnnotationsFixCore.hasExplicitNullAnnotation(cu, this.fProblem.getOffset())) break;
                    return null;
                }
            }
            String annotationNameLabel = this.fAnnotationToAdd;
            int lastDot = annotationNameLabel.lastIndexOf(46);
            if (lastDot != -1) {
                annotationNameLabel = annotationNameLabel.substring(lastDot + 1);
            }
            annotationNameLabel = BasicElementLabels.getJavaElementName(annotationNameLabel);
            if (changeTargetMethod) {
                MethodInvocation methodInvocation = null;
                if (this.fAffectsParameter) {
                    if (selectedNode.getParent() instanceof MethodInvocation) {
                        methodInvocation = (MethodInvocation)selectedNode.getParent();
                    }
                } else if (selectedNode instanceof MethodInvocation) {
                    methodInvocation = (MethodInvocation)selectedNode;
                }
                if (methodInvocation != null) {
                    int paramIdx = methodInvocation.arguments().indexOf(selectedNode);
                    IMethodBinding methodBinding = methodInvocation.resolveMethodBinding();
                    MethodDeclaration methodDecl = this.findMethodDeclarationInUnit(cu, methodBinding, thisUnitOnly);
                    if (methodDecl == null) {
                        return null;
                    }
                    if (this.fAffectsParameter) {
                        if (methodBinding.isVarargs() && paramIdx >= methodDecl.parameters().size() - 1) {
                            return null;
                        }
                        String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_target_method_parameter_nullness, new Object[]{methodInvocation.getName(), annotationNameLabel});
                        return new ParameterAnnotationRewriteOperation(methodDecl, paramIdx, message, this);
                    }
                    MethodDeclaration declaration = methodDecl;
                    String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_return_nullness, new String[]{declaration.getName().getIdentifier(), annotationNameLabel});
                    return new ReturnAnnotationRewriteOperation(declaration, message, this);
                }
            } else if (declaringNode instanceof MethodDeclaration || declaringNode instanceof LambdaExpression) {
                switch (this.fProblem.getProblemId()) {
                    case 67109779: 
                    case 67109780: 
                    case 67109781: 
                    case 67109782: {
                        ParameterAnnotationRewriteOperation.IndexedParameter parameter = this.findParameterDeclaration(selectedNode);
                        if (parameter == null) break;
                        switch (parameter.declaration.getNodeType()) {
                            case 31: {
                                MethodDeclaration method = (MethodDeclaration)parameter.declaration;
                                String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_parameter_nullness, new Object[]{parameter.name, annotationNameLabel});
                                return new ParameterAnnotationRewriteOperation(method, parameter.index, message, this);
                            }
                            case 86: {
                                LambdaExpression lambda = (LambdaExpression)parameter.declaration;
                                String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_parameter_nullness, new Object[]{parameter.name, annotationNameLabel});
                                return ParameterAnnotationRewriteOperation.create(lambda, parameter, message, this);
                            }
                        }
                        return null;
                    }
                    case 16778126: 
                    case 16778127: 
                    case 16778128: 
                    case 67109803: 
                    case 67109804: 
                    case 536871843: 
                    case 536871844: 
                    case 536871845: 
                    case 536871873: 
                    case 536871898: {
                        if (this.fAffectsParameter) {
                            ParameterAnnotationRewriteOperation.IndexedParameter parameter;
                            if (!(selectedNode instanceof SimpleName) || (parameter = this.findReferencedParameter(selectedNode)) == null) break;
                            switch (parameter.declaration.getNodeType()) {
                                case 31: {
                                    MethodDeclaration declaration = (MethodDeclaration)parameter.declaration;
                                    String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_parameter_nullness, new Object[]{parameter.name, annotationNameLabel});
                                    return new ParameterAnnotationRewriteOperation(declaration, parameter.index, message, this);
                                }
                                case 86: {
                                    LambdaExpression lambda = (LambdaExpression)parameter.declaration;
                                    String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_parameter_nullness, new Object[]{parameter.name, annotationNameLabel});
                                    return ParameterAnnotationRewriteOperation.create(lambda, parameter, message, this);
                                }
                            }
                            return null;
                        }
                    }
                    case 67109778: {
                        if (declaringNode.getNodeType() != 31) break;
                        MethodDeclaration declaration = (MethodDeclaration)declaringNode;
                        String name = declaration.getName().getIdentifier();
                        String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_method_return_nullness, new String[]{name, annotationNameLabel});
                        return new ReturnAnnotationRewriteOperation(declaration, message, this);
                    }
                    default: {
                        return null;
                    }
                }
            }
            return null;
        }

        private SignatureAnnotationRewriteOperation createAddAnnotationToOverriddenOperation() {
            ASTNode selectedNode = this.getCoveringNode();
            if (selectedNode == null) {
                return null;
            }
            ICompilationUnit cu = (ICompilationUnit)this.fUnit.getJavaElement();
            ASTNode declaringNode = Builder.getDeclaringNode(selectedNode);
            switch (this.fProblem.getProblemId()) {
                case 67109779: 
                case 67109780: {
                    break;
                }
                case 67109778: 
                case 67109803: {
                    if (declaringNode != null) break;
                    declaringNode = selectedNode;
                    break;
                }
                default: {
                    return null;
                }
            }
            String annotationNameLabel = this.fAnnotationToAdd;
            int lastDot = annotationNameLabel.lastIndexOf(46);
            if (lastDot != -1) {
                annotationNameLabel = annotationNameLabel.substring(lastDot + 1);
            }
            annotationNameLabel = BasicElementLabels.getJavaElementName(annotationNameLabel);
            if (declaringNode instanceof MethodDeclaration) {
                MethodDeclaration declaration = (MethodDeclaration)declaringNode;
                switch (this.fProblem.getProblemId()) {
                    case 67109778: {
                        if (!this.hasNullAnnotation(declaration)) {
                            return null;
                        }
                    }
                    case 67109779: 
                    case 67109780: 
                    case 67109803: {
                        if (this.fAffectsParameter) {
                            return this.createChangeOverriddenParameterOperation(cu, declaration, selectedNode, annotationNameLabel);
                        }
                        return this.createChangeOverriddenReturnOperation(cu, declaration, annotationNameLabel);
                    }
                }
                return null;
            }
            return null;
        }

        private SignatureAnnotationRewriteOperation createChangeOverriddenParameterOperation(ICompilationUnit cu, MethodDeclaration declaration, ASTNode selectedNode, String annotationNameLabel) {
            IMethodBinding methodDeclBinding = declaration.resolveBinding();
            if (methodDeclBinding == null) {
                return null;
            }
            IMethodBinding overridden = Bindings.findOverriddenMethod(methodDeclBinding, false);
            if (overridden == null) {
                return null;
            }
            MethodDeclaration overriddenDeclaration = this.findMethodDeclarationInUnit(cu, overridden, false);
            if (overriddenDeclaration == null) {
                return null;
            }
            String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_overridden_parameter_nullness, new String[]{overridden.getName(), annotationNameLabel});
            ParameterAnnotationRewriteOperation.IndexedParameter parameter = this.findParameterDeclaration(selectedNode);
            if (parameter == null) {
                return null;
            }
            return new ParameterAnnotationRewriteOperation(overriddenDeclaration, parameter.index, message, this);
        }

        private ParameterAnnotationRewriteOperation.IndexedParameter findParameterDeclaration(ASTNode selectedNode) {
            VariableDeclaration argDecl;
            VariableDeclaration variableDeclaration = argDecl = selectedNode instanceof VariableDeclaration ? (VariableDeclaration)selectedNode : ASTNodes.getParent(selectedNode, VariableDeclaration.class);
            if (argDecl != null) {
                StructuralPropertyDescriptor locationInParent = argDecl.getLocationInParent();
                if (!locationInParent.isChildListProperty()) {
                    return null;
                }
                ASTNode declaration = argDecl.getParent();
                if (declaration != null && (declaration.getNodeType() == 31 || declaration.getNodeType() == 86)) {
                    List containingList = (List)declaration.getStructuralProperty(locationInParent);
                    return new ParameterAnnotationRewriteOperation.IndexedParameter(declaration, containingList.indexOf(argDecl), argDecl.getName().getIdentifier());
                }
            }
            return null;
        }

        private ParameterAnnotationRewriteOperation.IndexedParameter findReferencedParameter(ASTNode selectedNode) {
            IBinding binding;
            if (selectedNode.getNodeType() == 42 && (binding = ((SimpleName)selectedNode).resolveBinding()).getKind() == 3 && ((IVariableBinding)binding).isParameter()) {
                ASTNode current = selectedNode.getParent();
                while (current != null) {
                    List parameters = null;
                    switch (current.getNodeType()) {
                        case 31: {
                            parameters = ((MethodDeclaration)current).parameters();
                            break;
                        }
                        case 86: {
                            parameters = ((LambdaExpression)current).parameters();
                        }
                    }
                    if (parameters != null) {
                        int i = 0;
                        while (i < parameters.size()) {
                            VariableDeclaration parameter = (VariableDeclaration)parameters.get(i);
                            if (parameter.resolveBinding() == binding) {
                                return new ParameterAnnotationRewriteOperation.IndexedParameter(current, i, binding.getName());
                            }
                            ++i;
                        }
                    }
                    current = current.getParent();
                }
            }
            return null;
        }

        private boolean hasNullAnnotation(MethodDeclaration decl) {
            List modifiers = decl.modifiers();
            String nonnull = NullAnnotationsFixCore.getNonNullAnnotationName(decl.resolveBinding().getJavaElement(), false);
            String nullable = NullAnnotationsFixCore.getNullableAnnotationName(decl.resolveBinding().getJavaElement(), false);
            for (Object mod : modifiers) {
                if (!(mod instanceof Annotation)) continue;
                Name annotationName = ((Annotation)mod).getTypeName();
                String fullyQualifiedName = annotationName.getFullyQualifiedName();
                if (annotationName.isSimpleName() ? nonnull.endsWith(fullyQualifiedName) : fullyQualifiedName.equals(nonnull)) {
                    return true;
                }
                if (!(annotationName.isSimpleName() ? nullable.endsWith(fullyQualifiedName) : fullyQualifiedName.equals(nullable))) continue;
                return true;
            }
            return false;
        }

        private SignatureAnnotationRewriteOperation createChangeOverriddenReturnOperation(ICompilationUnit cu, MethodDeclaration declaration, String annotationNameLabel) {
            IMethodBinding methodDeclBinding = declaration.resolveBinding();
            if (methodDeclBinding == null) {
                return null;
            }
            IMethodBinding overridden = Bindings.findOverriddenMethod(methodDeclBinding, false);
            if (overridden == null) {
                return null;
            }
            declaration = this.findMethodDeclarationInUnit(cu, overridden, false);
            if (declaration == null) {
                return null;
            }
            String message = Messages.format(FixMessages.NullAnnotationsRewriteOperations_change_overridden_return_nullness, new String[]{overridden.getName(), annotationNameLabel});
            return new ReturnAnnotationRewriteOperation(declaration, message, this);
        }

        private MethodDeclaration findMethodDeclarationInUnit(ICompilationUnit cu, IMethodBinding method, boolean sameUnitOnly) {
            CompilationUnit compilationUnit = this.findCUForMethod(this.fUnit, cu, method = method.getMethodDeclaration());
            if (compilationUnit == null) {
                return null;
            }
            if (sameUnitOnly && !compilationUnit.getJavaElement().equals(cu)) {
                return null;
            }
            ASTNode methodDecl = compilationUnit.findDeclaringNode(method.getKey());
            if (methodDecl == null) {
                return null;
            }
            this.fUnit = compilationUnit;
            return (MethodDeclaration)methodDecl;
        }

        private CompilationUnit findCUForMethod(CompilationUnit compilationUnit, ICompilationUnit cu, IMethodBinding methodBinding) {
            ASTNode methodDecl = compilationUnit.findDeclaringNode((IBinding)methodBinding.getMethodDeclaration());
            if (methodDecl == null) {
                ITypeBinding declaringTypeDecl = methodBinding.getDeclaringClass().getTypeDeclaration();
                if (declaringTypeDecl.isFromSource()) {
                    ICompilationUnit targetCU = null;
                    try {
                        targetCU = ASTResolving.findCompilationUnitForBinding(cu, compilationUnit, declaringTypeDecl);
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                    if (targetCU != null) {
                        return ASTResolving.createQuickFixAST(targetCU, null);
                    }
                }
                return null;
            }
            return compilationUnit;
        }

        private static ASTNode getDeclaringNode(ASTNode selectedNode) {
            while (selectedNode != null) {
                switch (selectedNode.getNodeType()) {
                    case 31: 
                    case 86: {
                        return selectedNode;
                    }
                }
                selectedNode = selectedNode.getParent();
            }
            return null;
        }
    }

    public static enum ChangeKind {
        LOCAL,
        INVERSE,
        OVERRIDDEN,
        TARGET;

    }

    static enum DefaultLocation {
        PARAMETER,
        RETURN_TYPE;

    }

    static class ParameterAnnotationRewriteOperation
    extends SignatureAnnotationRewriteOperation {
        private SingleVariableDeclaration fArgument;
        private int fParameterRank;

        static ParameterAnnotationRewriteOperation create(LambdaExpression lambda, IndexedParameter parameter, String message, Builder builder) {
            IMethodBinding lambdaMethodBinding = lambda.resolveMethodBinding();
            List parameters = lambda.parameters();
            if (parameters.size() > parameter.index) {
                Object param = parameters.get(parameter.index);
                if (!(param instanceof SingleVariableDeclaration)) {
                    return null;
                }
                return new ParameterAnnotationRewriteOperation(lambdaMethodBinding, parameters, parameter.index, message, builder);
            }
            throw new RuntimeException("Argument " + parameter.name + " not found in method " + lambda.toString());
        }

        ParameterAnnotationRewriteOperation(MethodDeclaration method, int paramIdx, String message, Builder builder) {
            this(method.resolveBinding(), method.parameters(), paramIdx, message, builder);
        }

        private ParameterAnnotationRewriteOperation(IMethodBinding methodBinding, List<?> parameters, int paramIdx, String message, Builder builder) {
            super(builder);
            this.fKey = methodBinding.getKey();
            this.fArgument = (SingleVariableDeclaration)parameters.get(paramIdx);
            this.fParameterRank = paramIdx;
            this.fKey = String.valueOf(this.fKey) + this.fArgument.getName().getIdentifier();
            this.fMessage = message;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            SimpleType simpleType;
            AST ast = cuRewrite.getRoot().getAST();
            Type argType = this.fArgument.getType();
            TextEditGroup group = this.createTextEditGroup(this.fMessage, cuRewrite);
            if (argType instanceof SimpleType && (simpleType = (SimpleType)argType).getName().isQualifiedName()) {
                Name name2 = simpleType.getName();
                QualifiedName qualifiedName = (QualifiedName)name2;
                ASTRewrite astRewrite = cuRewrite.getASTRewrite();
                Name qualifier = (Name)astRewrite.createMoveTarget((ASTNode)qualifiedName.getQualifier());
                SimpleName name = (SimpleName)astRewrite.createMoveTarget((ASTNode)qualifiedName.getName());
                NameQualifiedType nameQualifiedType = astRewrite.getAST().newNameQualifiedType(qualifier, name);
                MarkerAnnotation newAnnotation = ast.newMarkerAnnotation();
                ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                String resolvableName = importRewrite.addImport(this.fAnnotationToAdd);
                newAnnotation.setTypeName(ast.newName(resolvableName));
                nameQualifiedType.annotations().add(newAnnotation);
                astRewrite.replace((ASTNode)simpleType, (ASTNode)nameQualifiedType, group);
            } else if (argType instanceof NameQualifiedType) {
                NameQualifiedType nameQualifiedType = (NameQualifiedType)argType;
                ASTRewrite astRewrite = cuRewrite.getASTRewrite();
                ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)nameQualifiedType, NameQualifiedType.ANNOTATIONS_PROPERTY);
                MarkerAnnotation newAnnotation = ast.newMarkerAnnotation();
                ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                String resolvableName = importRewrite.addImport(this.fAnnotationToAdd);
                newAnnotation.setTypeName(ast.newName(resolvableName));
                listRewrite.insertLast((ASTNode)newAnnotation, group);
            } else {
                ListRewrite listRewrite = this.getAnnotationListRewrite(this.fArgument.getType(), cuRewrite, (ASTNode)this.fArgument, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
                if (!this.checkExisting(listRewrite, group)) {
                    return;
                }
                if (!this.fRequireExplicitAnnotation && this.hasNonNullDefault((ASTNode)this.fArgument, (IBinding)this.fArgument.resolveBinding(), this.fParameterRank, DefaultLocation.PARAMETER)) {
                    return;
                }
                MarkerAnnotation newAnnotation = ast.newMarkerAnnotation();
                ImportRewrite importRewrite = cuRewrite.getImportRewrite();
                String resolvableName = importRewrite.addImport(this.fAnnotationToAdd);
                newAnnotation.setTypeName(ast.newName(resolvableName));
                listRewrite.insertLast((ASTNode)newAnnotation, group);
            }
        }

        static class IndexedParameter {
            ASTNode declaration;
            int index;
            String name;

            IndexedParameter(ASTNode declaration, int index, String name) {
                this.declaration = declaration;
                this.index = index;
                this.name = name;
            }
        }
    }

    static class RemoveRedundantAnnotationRewriteOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private IProblemLocation fProblem;
        private CompilationUnit fCompilationUnit;

        public RemoveRedundantAnnotationRewriteOperation(CompilationUnit compilationUnit, IProblemLocation problem) {
            this.fCompilationUnit = compilationUnit;
            this.fProblem = problem;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.NullAnnotationsRewriteOperations_remove_redundant_nullness_annotation, cuRewrite);
            ASTRewrite astRewrite = cuRewrite.getASTRewrite();
            ImportRemover remover = cuRewrite.getImportRemover();
            CompilationUnit astRoot = this.fCompilationUnit;
            ASTNode selectedNode = this.fProblem.getCoveringNode(astRoot);
            if (this.fProblem.getProblemId() == 67109786) {
                List modifiers;
                if (selectedNode instanceof SingleVariableDeclaration) {
                    SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)selectedNode;
                    modifiers = singleVariableDeclaration.modifiers();
                } else if (selectedNode instanceof FieldDeclaration) {
                    FieldDeclaration fieldDeclaration = (FieldDeclaration)selectedNode;
                    modifiers = fieldDeclaration.modifiers();
                } else if (selectedNode instanceof MethodDeclaration) {
                    MethodDeclaration methodDeclaration = (MethodDeclaration)selectedNode;
                    modifiers = methodDeclaration.modifiers();
                } else if (selectedNode instanceof AnnotatableType) {
                    AnnotatableType annotatableType = (AnnotatableType)selectedNode;
                    modifiers = annotatableType.annotations();
                } else {
                    return;
                }
                for (IExtendedModifier modifier : modifiers) {
                    MarkerAnnotation annotation;
                    IAnnotationBinding annotationBinding;
                    String name;
                    if (!(modifier instanceof MarkerAnnotation) || !(name = (annotationBinding = (annotation = (MarkerAnnotation)modifier).resolveAnnotationBinding()).getName()).equals(NullAnnotationsFixCore.getNonNullAnnotationName(this.fCompilationUnit.getJavaElement(), true))) continue;
                    astRewrite.remove((ASTNode)annotation, group);
                    remover.registerRemovedNode((ASTNode)annotation);
                }
            } else {
                if (!(selectedNode instanceof Annotation)) {
                    return;
                }
                Annotation annotation = (Annotation)selectedNode;
                IAnnotationBinding annotationBinding = annotation.resolveAnnotationBinding();
                String name = annotationBinding.getName();
                if (name.equals(NullAnnotationsFixCore.getNonNullByDefaultAnnotationName(this.fCompilationUnit.getJavaElement(), true))) {
                    astRewrite.remove((ASTNode)annotation, group);
                }
            }
        }
    }

    static class ReturnAnnotationRewriteOperation
    extends SignatureAnnotationRewriteOperation {
        private final MethodDeclaration fBodyDeclaration;

        ReturnAnnotationRewriteOperation(MethodDeclaration method, String message, Builder builder) {
            super(builder);
            this.fKey = method.resolveBinding().getKey() + "<return>";
            this.fBodyDeclaration = method;
            this.fMessage = message;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            TextEditGroup group;
            AST ast = cuRewrite.getRoot().getAST();
            ListRewrite listRewrite = this.getAnnotationListRewrite(this.fBodyDeclaration.getReturnType2(), cuRewrite, (ASTNode)this.fBodyDeclaration, this.fBodyDeclaration.getModifiersProperty());
            if (!this.checkExisting(listRewrite, group = this.createTextEditGroup(this.fMessage, cuRewrite))) {
                return;
            }
            if (!this.fRequireExplicitAnnotation && this.hasNonNullDefault((ASTNode)this.fBodyDeclaration, (IBinding)this.fBodyDeclaration.resolveBinding(), -1, DefaultLocation.RETURN_TYPE)) {
                return;
            }
            MarkerAnnotation newAnnotation = ast.newMarkerAnnotation();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            String resolvableName = importRewrite.addImport(this.fAnnotationToAdd);
            newAnnotation.setTypeName(ast.newName(resolvableName));
            listRewrite.insertLast((ASTNode)newAnnotation, group);
        }
    }

    static abstract class SignatureAnnotationRewriteOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        protected CompilationUnit fUnit;
        protected String fAnnotationToAdd;
        protected String fAnnotationToRemove;
        protected boolean fAllowRemove;
        protected boolean fUseNullTypeAnnotations;
        protected boolean fRequireExplicitAnnotation;
        protected String fKey;
        protected String fMessage;
        boolean fRemoveIfNonNullByDefault;
        Set<String> fNonNullByDefaultNames;

        protected SignatureAnnotationRewriteOperation(Builder builder) {
            this.fUnit = builder.fUnit;
            this.fAnnotationToAdd = builder.fAnnotationToAdd;
            this.fAnnotationToRemove = builder.fAnnotationToRemove;
            this.fAllowRemove = builder.fAllowRemove;
            this.fUseNullTypeAnnotations = builder.fUseNullTypeAnnotations;
            this.fRequireExplicitAnnotation = builder.requiresExplicitAnnotation();
        }

        public String getKey() {
            return this.fKey;
        }

        public CompilationUnit getCompilationUnit() {
            return this.fUnit;
        }

        protected ListRewrite getAnnotationListRewrite(Type type, CompilationUnitRewrite cuRewrite, ASTNode declaration, ChildListPropertyDescriptor declAnnotationsProperty) {
            List dimensions;
            if (this.fUseNullTypeAnnotations && type.isArrayType() && !(dimensions = ((ArrayType)type).dimensions()).isEmpty()) {
                Dimension outerDim = (Dimension)dimensions.get(0);
                return cuRewrite.getASTRewrite().getListRewrite((ASTNode)outerDim, Dimension.ANNOTATIONS_PROPERTY);
            }
            return cuRewrite.getASTRewrite().getListRewrite(declaration, declAnnotationsProperty);
        }

        boolean checkExisting(ListRewrite listRewrite, TextEditGroup editGroup) {
            List existingModifiers = listRewrite.getOriginalList();
            for (IExtendedModifier mod : existingModifiers) {
                if (!(mod instanceof MarkerAnnotation)) continue;
                MarkerAnnotation annotation = (MarkerAnnotation)mod;
                String existingName = annotation.getTypeName().getFullyQualifiedName();
                int lastDot = this.fAnnotationToRemove.lastIndexOf(46);
                if (existingName.equals(this.fAnnotationToRemove) || lastDot != -1 && this.fAnnotationToRemove.substring(lastDot + 1).equals(existingName)) {
                    if (!this.fAllowRemove) {
                        return false;
                    }
                    listRewrite.remove((ASTNode)annotation, editGroup);
                    return true;
                }
                lastDot = this.fAnnotationToAdd.lastIndexOf(46);
                if (!existingName.equals(this.fAnnotationToAdd) && (lastDot == -1 || !this.fAnnotationToAdd.substring(lastDot + 1).equals(existingName))) continue;
                return false;
            }
            return true;
        }

        boolean hasNonNullDefault(ASTNode astNode, IBinding enclosingElement, int parameterRank, DefaultLocation defaultLocation) {
            if (!this.fRemoveIfNonNullByDefault || this.fNonNullByDefaultNames == null) {
                return false;
            }
            ITypeBinding affectedType = null;
            if (enclosingElement instanceof IMethodBinding) {
                switch (defaultLocation) {
                    case RETURN_TYPE: {
                        affectedType = ((IMethodBinding)enclosingElement).getReturnType();
                        break;
                    }
                    case PARAMETER: {
                        affectedType = ((IMethodBinding)enclosingElement).getParameterTypes()[parameterRank];
                    }
                }
            } else if (enclosingElement instanceof IVariableBinding) {
                affectedType = ((IVariableBinding)enclosingElement).getType();
            }
            if (affectedType != null && (affectedType.isTypeVariable() || affectedType.isWildcardType())) {
                return false;
            }
            EnumSet<ImportRewrite.TypeLocation> nonNullByDefaultLocations = RedundantNullnessTypeAnnotationsFilter.determineNonNullByDefaultLocations(astNode, this.fNonNullByDefaultNames);
            switch (defaultLocation) {
                case PARAMETER: {
                    return nonNullByDefaultLocations.contains(ImportRewrite.TypeLocation.PARAMETER);
                }
                case RETURN_TYPE: {
                    return nonNullByDefaultLocations.contains(ImportRewrite.TypeLocation.RETURN_TYPE);
                }
            }
            return false;
        }

        public String getMessage() {
            return this.fMessage;
        }
    }
}

