/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.internal.ui.actions.OpenActionUtil;
import org.eclipse.dltk.internal.ui.util.StringMatcher;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.CustomFiltersActionGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.LegacyHandlerSubmissionExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;

public abstract class AbstractInformationControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    private Text fFilterText;
    private TreeViewer fTreeViewer;
    protected StringMatcher fStringMatcher;
    private Command fInvokingCommand;
    private TriggerSequence[] fInvokingCommandKeySequences;
    private Composite fViewMenuButtonComposite;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    private String[] fKeyBindingScopes;
    private IAction fShowViewMenuAction;
    private IHandlerActivation fShowViewMenuHandlerSubmission;
    private int fTreeStyle;

    public AbstractInformationControl(Shell parent, int shellStyle, int treeStyle, String invokingCommandId, boolean showStatusField) {
        super(parent, shellStyle, true, true, true, true, true, null, null);
        if (invokingCommandId != null) {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            this.fInvokingCommand = commandService.getCommand(invokingCommandId);
            if (this.fInvokingCommand != null && !this.fInvokingCommand.isDefined()) {
                this.fInvokingCommand = null;
            } else {
                this.getInvokingCommandKeySequences();
            }
        }
        this.fTreeStyle = treeStyle;
        if (this.hasHeader()) {
            this.setTitleText("");
        }
        this.setInfoText("");
        if (this.isEarlyCreate()) {
            this.create();
        }
    }

    public void create() {
        super.create();
        this.setInfoText(this.getStatusFieldText());
    }

    protected boolean isEarlyCreate() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.fTreeViewer = this.createTreeViewer(parent, this.fTreeStyle);
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup(this.getId(), (StructuredViewer)this.fTreeViewer);
        final Tree tree = this.fTreeViewer.getTree();
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }
        });
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractInformationControl.this.gotoSelectedElement();
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                TreeItem o;
                if (tree.equals(e.getSource()) && (o = tree.getItem(new Point(e.x, e.y))) instanceof TreeItem) {
                    if (!o.equals(this.fLastItem)) {
                        this.fLastItem = o;
                        tree.setSelection(new TreeItem[]{this.fLastItem});
                    } else if (e.y < tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = AbstractInformationControl.this.fTreeViewer.scrollUp(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    } else if (e.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = AbstractInformationControl.this.fTreeViewer.scrollDown(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    }
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        AbstractInformationControl.this.gotoSelectedElement();
                    }
                }
            }
        });
        this.installFilter();
        this.addDisposeListener(this);
        return this.fTreeViewer.getControl();
    }

    public AbstractInformationControl(Shell parent, int shellStyle, int treeStyle) {
        this(parent, shellStyle, treeStyle, null, false);
    }

    protected abstract TreeViewer createTreeViewer(Composite var1, int var2);

    protected abstract String getId();

    protected TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    protected boolean hasHeader() {
        return false;
    }

    protected Text getFilterText() {
        return this.fFilterText;
    }

    protected Text createFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        GridData data = new GridData(768);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)data);
        this.fFilterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    AbstractInformationControl.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    AbstractInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    AbstractInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }
        });
        return this.fFilterText;
    }

    protected void createHorizontalSeparator(Composite parent) {
        Label separator = new Label(parent, 259);
        separator.setLayoutData((Object)new GridData(768));
    }

    protected void updateStatusFieldText() {
        this.setInfoText(this.getStatusFieldText());
    }

    protected void handleStatusFieldClicked() {
    }

    protected String getStatusFieldText() {
        return "";
    }

    private void installFilter() {
        this.fFilterText.setText("");
        this.fFilterText.addModifyListener(e -> {
            Object text = ((Text)e.widget).getText();
            int length = ((String)text).length();
            if (length > 0 && ((String)text).charAt(length - 1) != '*') {
                text = (String)text + "*";
            }
            this.setMatcherString((String)text, true);
        });
    }

    protected void stringMatcherUpdated() {
        this.fTreeViewer.getControl().setRedraw(false);
        this.fTreeViewer.refresh();
        this.fTreeViewer.expandAll();
        this.selectFirstMatch();
        this.fTreeViewer.getControl().setRedraw(true);
    }

    protected void setMatcherString(String pattern, boolean update) {
        if (pattern.length() == 0) {
            this.fStringMatcher = null;
        } else {
            boolean ignoreCase = pattern.toLowerCase().equals(pattern);
            this.fStringMatcher = new StringMatcher(pattern, ignoreCase, false);
        }
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    protected StringMatcher getMatcher() {
        return this.fStringMatcher;
    }

    protected Object getSelectedElement() {
        if (this.fTreeViewer == null) {
            return null;
        }
        return this.fTreeViewer.getStructuredSelection().getFirstElement();
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            try {
                this.dispose();
                OpenActionUtil.open(selectedElement, true);
            }
            catch (CoreException ex) {
                DLTKUIPlugin.log(ex);
            }
        }
    }

    protected void selectFirstMatch() {
        Tree tree = this.fTreeViewer.getTree();
        IModelElement element = this.findElement(tree.getItems());
        if (element != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
        } else {
            this.fTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private IModelElement findElement(TreeItem[] items) {
        ILabelProvider labelProvider = (ILabelProvider)this.fTreeViewer.getLabelProvider();
        int i = 0;
        while (i < items.length) {
            String label;
            IModelElement element = (IModelElement)items[i].getData();
            if (this.fStringMatcher == null) {
                return element;
            }
            if (element != null && this.fStringMatcher.match(label = labelProvider.getText((Object)element))) {
                return element;
            }
            element = this.findElement(items[i].getItems());
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public void setInformation(String information) {
    }

    public abstract void setInput(Object var1);

    protected void fillViewMenu(IMenuManager viewMenu) {
        this.fCustomFiltersActionGroup.fillViewMenu(viewMenu);
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        this.fillViewMenu(dialogMenu);
    }

    protected void inputChanged(Object newInput, Object newSelection) {
        this.fFilterText.setText("");
        this.fTreeViewer.setInput(newInput);
        if (newSelection != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(newSelection));
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.addHandlerAndKeyBindingSupport();
            this.open();
        } else {
            this.removeHandlerAndKeyBindingSupport();
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
            this.removeHandlerAndKeyBindingSupport();
        }
    }

    public final void dispose() {
        this.close();
    }

    public void widgetDisposed(DisposeEvent event) {
        this.removeHandlerAndKeyBindingSupport();
        this.fTreeViewer = null;
        this.fFilterText = null;
    }

    protected void addHandlerAndKeyBindingSupport() {
        if (this.fShowViewMenuHandlerSubmission == null) {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            LegacyHandlerSubmissionExpression expression = new LegacyHandlerSubmissionExpression(null, this.getShell(), null);
            this.fShowViewMenuHandlerSubmission = handlerService.activateHandler(this.fShowViewMenuAction.getActionDefinitionId(), (IHandler)new ActionHandler(this.fShowViewMenuAction), (Expression)expression);
        }
    }

    protected void removeHandlerAndKeyBindingSupport() {
        if (this.fShowViewMenuHandlerSubmission != null) {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            handlerService.deactivateHandler(this.fShowViewMenuHandlerSubmission);
            this.fShowViewMenuHandlerSubmission = null;
        }
    }

    public boolean hasContents() {
        return this.fTreeViewer != null && this.fTreeViewer.getInput() != null;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void setLocation(Point location) {
        if (!this.getPersistLocation() || !this.getPersistSize() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public boolean isFocusControl() {
        return this.fTreeViewer.getControl().isFocusControl() || this.fFilterText.isFocusControl();
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.fFilterText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    protected final Command getInvokingCommand() {
        return this.fInvokingCommand;
    }

    protected final TriggerSequence[] getInvokingCommandKeySequences() {
        if (this.fInvokingCommandKeySequences == null && this.getInvokingCommand() != null) {
            IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
            this.fInvokingCommandKeySequences = bindingService.getActiveBindingsFor(this.getInvokingCommand().getId());
            return this.fInvokingCommandKeySequences;
        }
        return this.fInvokingCommandKeySequences;
    }

    protected IDialogSettings getDialogSettings() {
        String sectionName = this.getId();
        IDialogSettings settings = DLTKUIPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = DLTKUIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    protected Control createTitleMenuArea(Composite parent) {
        this.fViewMenuButtonComposite = (Composite)super.createTitleMenuArea(parent);
        if (this.hasHeader()) {
            this.fFilterText = this.createFilterText(parent);
        }
        this.fShowViewMenuAction = new Action("showViewMenu"){

            public void run() {
                AbstractInformationControl.this.showDialogMenu();
            }
        };
        this.fShowViewMenuAction.setEnabled(true);
        this.fShowViewMenuAction.setActionDefinitionId("org.eclipse.ui.window.showViewMenu");
        this.addHandlerAndKeyBindingSupport();
        return this.fViewMenuButtonComposite;
    }

    protected Control createTitleControl(Composite parent) {
        if (this.hasHeader()) {
            return super.createTitleControl(parent);
        }
        this.fFilterText = this.createFilterText(parent);
        return this.fFilterText;
    }

    protected void setTabOrder(Composite composite) {
        if (this.hasHeader()) {
            composite.setTabList(new Control[]{this.fFilterText, this.fTreeViewer.getTree()});
        } else {
            this.fViewMenuButtonComposite.setTabList(new Control[]{this.fFilterText});
            composite.setTabList(new Control[]{this.fViewMenuButtonComposite, this.fTreeViewer.getTree()});
        }
    }

    protected class NamePatternFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            StringMatcher matcher = AbstractInformationControl.this.getMatcher();
            if (matcher == null || !(viewer instanceof TreeViewer)) {
                return true;
            }
            TreeViewer treeViewer = (TreeViewer)viewer;
            String matchName = ((ILabelProvider)treeViewer.getLabelProvider()).getText(element);
            if (matchName != null && matcher.match(matchName)) {
                return true;
            }
            return this.hasUnfilteredChild(treeViewer, element);
        }

        private boolean hasUnfilteredChild(TreeViewer viewer, Object element) {
            if (element instanceof IParent) {
                Object[] children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(element);
                int i = 0;
                while (i < children.length) {
                    if (this.select((Viewer)viewer, element, children[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

