/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.time.Duration;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ConditionalHandler;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject
public class QoSHandler
extends ConditionalHandler.Abstract {
    private static final Logger LOG = LoggerFactory.getLogger(QoSHandler.class);
    private static final String EXPIRED_ATTRIBUTE_NAME = QoSHandler.class.getName() + ".expired";
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicInteger state = new AtomicInteger();
    private final Map<Integer, Queue<Entry>> queues = new ConcurrentHashMap<Integer, Queue<Entry>>();
    private final Set<Integer> priorities = new ConcurrentSkipListSet(Comparator.reverseOrder());
    private final AtomicLong totalCount = new AtomicLong();
    private final AtomicLong suspendedCount = new AtomicLong();
    private final AtomicLong resumedCount = new AtomicLong();
    private final AtomicLong expiredCount = new AtomicLong();
    private final AtomicLong exceededCount = new AtomicLong();
    private CyclicTimeouts<Entry> timeouts;
    private int maxRequests;
    private int maxSuspendedRequests = 1024;
    private Duration maxSuspend = Duration.ZERO;
    private int rejectStatusCode = 503;

    public QoSHandler() {
        this((Handler)null);
    }

    public QoSHandler(Handler handler) {
        super(false, handler);
    }

    @ManagedAttribute(value="The maximum number of concurrent requests", readonly=true)
    public int getMaxRequestCount() {
        return this.maxRequests;
    }

    public void setMaxRequestCount(int maxRequests) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot change maxRequests: " + String.valueOf(this));
        }
        this.maxRequests = maxRequests;
    }

    @ManagedAttribute(value="The maximum number of suspended requests", readonly=true)
    public int getMaxSuspendedRequestCount() {
        return this.maxSuspendedRequests;
    }

    public void setMaxSuspendedRequestCount(int maxSuspendedRequests) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot change maxSuspendedRequests: " + String.valueOf(this));
        }
        this.maxSuspendedRequests = maxSuspendedRequests;
    }

    public Duration getMaxSuspend() {
        return this.maxSuspend;
    }

    public void setMaxSuspend(Duration maxSuspend) {
        if (maxSuspend.isNegative()) {
            throw new IllegalArgumentException("Invalid maxSuspend duration");
        }
        this.maxSuspend = maxSuspend;
    }

    @ManagedAttribute(value="The reject HTTP status code")
    public int getRejectStatusCode() {
        return this.rejectStatusCode;
    }

    public void setRejectStatusCode(int rejectStatusCode) {
        this.rejectStatusCode = rejectStatusCode;
    }

    @ManagedAttribute(value="The current number of suspended requests")
    public int getSuspendedRequestCount() {
        int permits = this.state.get();
        return Math.max(0, -permits);
    }

    @ManagedAttribute(value="The total number of processed requests")
    public long getTotalRequestCount() {
        return this.totalCount.get();
    }

    @ManagedAttribute(value="The total number of resumed requests")
    public long getTotalSuspendedRequestCount() {
        return this.suspendedCount.get();
    }

    @ManagedAttribute(value="The total number of resumed requests")
    public long getTotalResumedRequestCount() {
        return this.resumedCount.get();
    }

    @ManagedAttribute(value="The total number of requests that expired while suspended")
    public long getTotalExpiredRequestCount() {
        return this.expiredCount.get();
    }

    @ManagedAttribute(value="The total number of requests that exceeded the maximum number of suspended requests")
    public long getTotalExceededRequestCount() {
        return this.exceededCount.get();
    }

    @Override
    protected void doStart() throws Exception {
        this.timeouts = new Timeouts(this.getServer().getScheduler());
        this.addBean(this.timeouts);
        int maxRequests = this.getMaxRequestCount();
        if (maxRequests <= 0) {
            ThreadPool threadPool = this.getServer().getThreadPool();
            if (threadPool instanceof ThreadPool.SizedThreadPool) {
                ThreadPool.SizedThreadPool sized = (ThreadPool.SizedThreadPool)threadPool;
                maxRequests = sized.getMaxThreads() / 2;
            } else {
                maxRequests = ProcessorUtils.availableProcessors();
            }
            this.setMaxRequestCount(maxRequests);
        }
        this.state.set(maxRequests);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} initialized maxRequests={}", (Object)this, (Object)maxRequests);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.timeouts);
        this.timeouts.destroy();
    }

    @Override
    public boolean onConditionsMet(Request request, Response response, Callback callback) throws Exception {
        return this.process(request, response, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean process(Request request, Response response, Callback callback) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} processing {}", (Object)this, (Object)request);
        }
        this.totalCount.incrementAndGet();
        boolean tooManyRequests = false;
        boolean expiredReHandled = false;
        this.lock.readLock().lock();
        try {
            int permits = this.state.decrementAndGet();
            if (permits < 0) {
                int maxSuspended = this.getMaxSuspendedRequestCount();
                if (maxSuspended >= 0 && Math.abs(permits) > maxSuspended) {
                    this.state.incrementAndGet();
                    tooManyRequests = true;
                } else {
                    if (request.getAttribute(EXPIRED_ATTRIBUTE_NAME) == null) {
                        this.suspend(request, response, callback);
                        boolean bl = true;
                        return bl;
                    }
                    this.state.incrementAndGet();
                    expiredReHandled = true;
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (tooManyRequests) {
            return this.tooManyRequests(request, response, callback);
        }
        if (expiredReHandled) {
            return this.expiredReHandled(request, response, callback);
        }
        return this.handleWithPermit(request, response, callback);
    }

    @Override
    protected boolean onConditionsNotMet(Request request, Response response, Callback callback) throws Exception {
        return this.nextHandler(request, response, callback);
    }

    private boolean tooManyRequests(Request request, Response response, Callback callback) {
        this.exceededCount.incrementAndGet();
        return this.notAvailable(request, response, callback);
    }

    private boolean expiredReHandled(Request request, Response response, Callback callback) {
        return this.notAvailable(request, response, callback);
    }

    private boolean notAvailable(Request request, Response response, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} rejecting {}", (Object)this, (Object)response.getRequest());
        }
        if (response.isCommitted()) {
            callback.failed((Throwable)new IllegalStateException("Response already committed"));
        } else {
            this.reject(request, response, callback, this.getRejectStatusCode());
        }
        return true;
    }

    protected void reject(Request request, Response response, Callback callback, int status) {
        Response.writeError(request, response, callback, status);
    }

    protected int getPriority(Request request) {
        return 0;
    }

    protected void failSuspended(Request request, Response response, Callback callback, int status, Throwable failure) {
        Response.writeError(request, response, callback, status, null, failure);
    }

    protected void expireSuspended(Request request, Response response, Callback callback) {
        this.expiredCount.incrementAndGet();
        this.failSuspended(request, response, callback, this.getRejectStatusCode(), new TimeoutException());
    }

    private boolean handleWithPermit(Request request, Response response, Callback callback) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} forwarding {}", (Object)this, (Object)request);
        }
        Request.addCompletionListener(request, this::resume);
        return this.nextHandler(request, response, callback);
    }

    private void suspend(Request request, Response response, Callback callback) {
        this.suspendedCount.incrementAndGet();
        int priority = Math.max(0, this.getPriority(request));
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} suspending priority={} {}", new Object[]{this, priority, request});
        }
        Entry entry = new Entry(request, response, callback, priority);
        this.queues.compute(priority, (k, v) -> {
            if (v == null) {
                this.priorities.add(priority);
                v = new ConcurrentLinkedQueue<Entry>();
            }
            v.offer(entry);
            return v;
        });
        this.timeouts.schedule((CyclicTimeouts.Expirable)entry);
    }

    private void resume(Throwable x) {
        this.lock.readLock().lock();
        try {
            int permits = this.state.incrementAndGet();
            if (permits > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.atDebug().setCause(x).log("{} no suspended requests to resume", (Object)this);
                }
                return;
            }
            while (true) {
                if (this.resumeSuspended()) {
                    return;
                }
                Thread.onSpinWait();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean resumeSuspended() {
        for (Integer priority : this.priorities) {
            Queue<Entry> queue = this.queues.get(priority);
            if (queue == null) {
                return false;
            }
            Entry entry = queue.poll();
            if (entry == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} resuming {}", (Object)this, (Object)entry.request);
            }
            this.execute(entry.request, entry);
            return true;
        }
        return false;
    }

    private void execute(Request request, Runnable task) {
        request.getContext().execute(task);
    }

    public String toString() {
        return "%s[maxReq=%d,maxSus=%d,sus/res/tot/exp/exc=(%d,%d)/%d/%d/%d/%d]".formatted(super.toString(), this.getMaxRequestCount(), this.getMaxSuspendedRequestCount(), this.getSuspendedRequestCount(), this.getTotalSuspendedRequestCount(), this.getTotalResumedRequestCount(), this.getTotalRequestCount(), this.getTotalExpiredRequestCount(), this.getTotalExceededRequestCount());
    }

    private class Timeouts
    extends CyclicTimeouts<Entry> {
        private Timeouts(Scheduler scheduler) {
            super(scheduler);
        }

        protected Iterator<Entry> iterator() {
            return QoSHandler.this.queues.values().stream().flatMap(Collection::stream).iterator();
        }

        protected boolean onExpired(Entry entry) {
            entry.expire();
            return false;
        }
    }

    private class Entry
    implements CyclicTimeouts.Expirable,
    Runnable {
        private final Request request;
        private final Response response;
        private final Callback callback;
        private final int priority;
        private final long expireNanoTime;

        private Entry(Request request, Response response, Callback callback, int priority) {
            this.request = request;
            this.response = response;
            this.callback = callback;
            this.priority = priority;
            this.expireNanoTime = CyclicTimeouts.Expirable.calcExpireNanoTime((long)QoSHandler.this.getMaxSuspend().toMillis());
        }

        public long getExpireNanoTime() {
            return this.expireNanoTime;
        }

        private void expire() {
            boolean removed;
            QoSHandler.this.lock.writeLock().lock();
            try {
                removed = QoSHandler.this.queues.get(this.priority).remove(this);
                if (removed) {
                    QoSHandler.this.state.incrementAndGet();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} timeout {}", (Object)QoSHandler.this, (Object)this.request);
                    }
                    this.request.setAttribute(EXPIRED_ATTRIBUTE_NAME, true);
                }
            }
            finally {
                QoSHandler.this.lock.writeLock().unlock();
            }
            if (removed) {
                QoSHandler.this.execute(this.request, () -> QoSHandler.this.expireSuspended(this.request, this.response, this.callback));
            }
        }

        @Override
        public void run() {
            try {
                QoSHandler.this.resumedCount.incrementAndGet();
                boolean handled = QoSHandler.this.handleWithPermit(this.request, this.response, this.callback);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} handled={} {}", new Object[]{QoSHandler.this, handled, this.request});
                }
                if (!handled) {
                    QoSHandler.this.failSuspended(this.request, this.response, this.callback, 404, null);
                }
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.atDebug().setCause(x).log("{} failed {}", (Object)QoSHandler.this, (Object)this.request);
                }
                QoSHandler.this.failSuspended(this.request, this.response, this.callback, 500, x);
            }
        }
    }
}

