/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class OneBorderComposite
extends Composite {
    private static final int POSITION_MASK = 148608;
    private int borderPosition;
    private Control border;
    private Control clientControl;
    private GridLayout layout = UIUtil.createGridLayout(1);
    private GridData borderData;
    private GridData clientControlData;

    public OneBorderComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)this.layout);
        this.clientControlData = UIUtil.createGridData();
        this.clientControl = this.createUI(this);
        this.clientControl.setLayoutData((Object)this.clientControlData);
    }

    public OneBorderComposite(Composite parent, int borderPosition) {
        this(parent);
        this.setBorderPosition(borderPosition);
    }

    public Control getClientControl() {
        return this.clientControl;
    }

    public int getBorderPosition() {
        return this.borderPosition;
    }

    public void setBorderPosition(int borderPosition) {
        if (Integer.bitCount(borderPosition &= 0x24480) != 1) {
            throw new IllegalArgumentException("borderPosition: " + borderPosition);
        }
        if (this.borderPosition != borderPosition) {
            this.borderPosition = borderPosition;
            switch (borderPosition) {
                case 16384: {
                    this.setBorder(true, true);
                    break;
                }
                case 131072: {
                    this.setBorder(true, false);
                    break;
                }
                case 128: {
                    this.setBorder(false, true);
                    break;
                }
                case 1024: {
                    this.setBorder(false, false);
                    break;
                }
                default: {
                    return;
                }
            }
            this.layout();
        }
    }

    public void swapBorderPosition() {
        switch (this.borderPosition) {
            case 16384: {
                this.setBorderPosition(128);
                break;
            }
            case 131072: {
                this.setBorderPosition(1024);
                break;
            }
            case 128: {
                this.setBorderPosition(16384);
                break;
            }
            case 1024: {
                this.setBorderPosition(131072);
            }
        }
    }

    public String toString() {
        switch (this.borderPosition) {
            case 16384: {
                return "LEFT";
            }
            case 131072: {
                return "RIGHT";
            }
            case 128: {
                return "TOP";
            }
            case 1024: {
                return "BOTTOM";
            }
        }
        return super.toString();
    }

    protected abstract Control createUI(Composite var1);

    private void setBorder(boolean vertical, boolean beginning) {
        if (this.border != null) {
            this.border.dispose();
        }
        this.layout.numColumns = vertical ? 2 : 1;
        this.borderData = UIUtil.createGridData();
        this.borderData.widthHint = vertical ? 1 : -1;
        this.borderData.heightHint = vertical ? -1 : 1;
        this.borderData.grabExcessHorizontalSpace = !vertical;
        this.borderData.grabExcessVerticalSpace = vertical;
        int orientation = vertical ? 512 : 256;
        this.border = new Label((Composite)this, 2 | orientation);
        this.border.setLayoutData((Object)this.borderData);
        if (beginning) {
            this.border.moveAbove(null);
        }
    }
}

