/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lsp;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.JvmTypeChangeDispatcher;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.IClassMirror;
import org.eclipse.xtext.common.types.descriptions.TypeResourceDescription;
import org.eclipse.xtext.ide.server.ProjectManager;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lsp.ClasspathPropertiesBasedFileSystemScanner;
import org.eclipse.xtext.xbase.lsp.ForwardingClassLoader;

public class ClasspathPropertiesBasedXbaseProjectManager
extends ProjectManager {
    private static final Predicate<String> CP = Pattern.compile("^\\w+\\.(bin|cp).\\d+$").asPredicate();
    private static final Logger LOGGER = Logger.getLogger(ClasspathPropertiesBasedFileSystemScanner.class);
    @Inject
    private ClasspathPropertiesBasedFileSystemScanner classpathScanner;
    @Inject
    private IJvmTypeProvider.Factory typeProviderFactory;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    private final ForwardingClassLoader classpathURIContext = new ForwardingClassLoader();
    private Properties projectClasspath;

    public void initialize(ProjectDescription description, IProjectConfig projectConfig, Procedures.Procedure2<? super URI, ? super Iterable<Issue>> acceptor, IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider, Provider<Map<String, ResourceDescriptionsData>> indexProvider, CancelIndicator cancelIndicator) {
        super.initialize(description, projectConfig, acceptor, openedDocumentsContentProvider, indexProvider, cancelIndicator);
        this.projectClasspath = this.classpathScanner.getProjectClasspath(projectConfig.getPath());
        this.updateClassLoader();
    }

    protected void updateClassLoader() {
        if (this.projectClasspath != null) {
            LinkedHashSet urls = new LinkedHashSet();
            this.projectClasspath.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = (String)k;
                String value = (String)v;
                if (CP.test(key)) {
                    urls.add(value);
                }
            }));
            URL[] cp = (URL[])urls.stream().map(p -> {
                try {
                    return new File((String)p).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
            }).filter(Objects::nonNull).toArray(URL[]::new);
            this.classpathURIContext.setDelegate(new URLClassLoader(cp, ClassLoader.getPlatformClassLoader()));
            this.clearTypesCache();
        }
    }

    protected void clearTypesCache() {
        XtextResourceSet resourceSet = this.getResourceSet();
        if (resourceSet != null) {
            IJvmTypeProvider typeProvider = this.typeProviderFactory.findTypeProvider((ResourceSet)resourceSet);
            if (typeProvider != null) {
                typeProvider.clearCache();
            }
            JvmTypeChangeDispatcher dispatcher = JvmTypeChangeDispatcher.findResourceChangeDispatcher((Notifier)resourceSet);
            EObject dummy = EcoreFactory.eINSTANCE.createEObject();
            dispatcher.requestNotificationOnChange((Notifier)dummy, () -> {});
            dummy.eNotify((Notification)new NotificationImpl(3, true, false));
        }
    }

    protected BuildRequest newBuildRequest(List<URI> changedFiles, List<URI> deletedFiles, List<IResourceDescription.Delta> externalDeltas, CancelIndicator cancelIndicator) {
        Map<String, List<URI>> locationToTypeURI = null;
        ArrayList<URI> changedTypeResources = new ArrayList<URI>();
        for (URI changedFile : changedFiles) {
            List<URI> resources;
            if ("xtext.classpath".equals(changedFile.lastSegment())) {
                Properties prev = this.projectClasspath;
                this.projectClasspath = this.classpathScanner.getProjectClasspath(this.getProjectConfig().getPath());
                this.updateClassLoader();
                if (locationToTypeURI == null) {
                    locationToTypeURI = this.collectLocationURIs();
                }
                changedTypeResources.addAll(this.collectAffectedTypeResources(prev, this.projectClasspath, locationToTypeURI));
                continue;
            }
            if (!"class".equals(changedFile.fileExtension())) continue;
            if (locationToTypeURI == null) {
                locationToTypeURI = this.collectLocationURIs();
            }
            if ((resources = locationToTypeURI.get(changedFile.toFileString())) == null) continue;
            changedTypeResources.addAll(resources);
        }
        if (!changedTypeResources.isEmpty()) {
            changedFiles.addAll(changedTypeResources);
            for (URI changedTypeResource : changedTypeResources) {
                QualifiedName qn = this.qualifiedNameConverter.toQualifiedName(changedTypeResource.lastSegment());
                externalDeltas.add((IResourceDescription.Delta)new TypeResourceDescription.ChangedDelta(qn));
            }
            this.clearTypesCache();
        }
        return super.newBuildRequest(changedFiles, deletedFiles, externalDeltas, cancelIndicator);
    }

    private Map<String, List<URI>> collectLocationURIs() {
        HashMap<String, List<URI>> result = new HashMap<String, List<URI>>();
        XtextResourceSet resourceSet = this.getResourceSet();
        if (resourceSet != null) {
            for (Resource resource : resourceSet.getResources()) {
                String locationString;
                URI locationURI;
                IMirror mirror;
                if (!(resource instanceof TypeResource) || !((mirror = ((TypeResource)resource).getMirror()) instanceof IClassMirror) || (locationURI = ((IClassMirror)mirror).getLocationURI(resource)) == null) continue;
                if (locationURI.isArchive()) {
                    String authority = locationURI.authority();
                    locationString = URI.createURI((String)authority.substring(0, authority.length() - 1), (boolean)true).toFileString();
                } else {
                    locationString = new UriExtensions().withEmptyAuthority(locationURI).toFileString();
                }
                if (locationString == null) continue;
                result.computeIfAbsent(locationString, any -> new ArrayList()).add(resource.getURI());
            }
        }
        return result;
    }

    protected List<URI> collectAffectedTypeResources(Properties oldClasspath, Properties newClasspath, Map<String, List<URI>> locationToTypeURI) {
        ArrayList<URI> result = new ArrayList<URI>();
        if (locationToTypeURI != null && oldClasspath != null) {
            List<URI> resources;
            Map<String, String> oldHashes = ClasspathPropertiesBasedXbaseProjectManager.locationHashes(oldClasspath);
            Map<String, String> newHashes = ClasspathPropertiesBasedXbaseProjectManager.locationHashes(newClasspath);
            MapDifference difference = Maps.difference(oldHashes, newHashes);
            for (String diff : difference.entriesDiffering().keySet()) {
                resources = locationToTypeURI.get(diff);
                if (resources == null) continue;
                result.addAll(resources);
            }
            for (String diff : difference.entriesOnlyOnLeft().keySet()) {
                resources = locationToTypeURI.get(diff);
                if (resources == null) continue;
                result.addAll(resources);
            }
        }
        return result;
    }

    protected static Map<String, String> locationHashes(Properties config) {
        HashMap<String, String> result = new HashMap<String, String>();
        config.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String hash;
            String key = (String)k;
            String value = (String)v;
            if (CP.test(key) && (hash = (String)config.get(String.valueOf(k) + ".hash")) != null) {
                result.put(value, hash);
            }
        }));
        return result;
    }

    protected XtextResourceSet createFreshResourceSet(ResourceDescriptionsData newIndex) {
        XtextResourceSet result = super.createFreshResourceSet(newIndex);
        return result;
    }

    public XtextResourceSet createNewResourceSet(ResourceDescriptionsData newIndex) {
        XtextResourceSet result = super.createNewResourceSet(newIndex);
        result.setClasspathURIContext((Object)this.classpathURIContext);
        this.typeProviderFactory.createTypeProvider((ResourceSet)result);
        return result;
    }
}

