/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.m2e.wtp.DomUtils;
import org.eclipse.m2e.wtp.internal.StringUtils;

public abstract class AbstractFilteringSupportMavenPlugin {
    private Xpp3Dom configuration;

    public final void setConfiguration(Xpp3Dom configuration) {
        this.configuration = configuration;
    }

    public Xpp3Dom getConfiguration() {
        return this.configuration;
    }

    public String getEscapeString() {
        Xpp3Dom config = this.getConfiguration();
        if (config != null) {
            return DomUtils.getChildValue(config, "escapeString");
        }
        return null;
    }

    public Xpp3Dom[] getNonfilteredExtensions() {
        Xpp3Dom extensionsNode;
        Xpp3Dom config = this.getConfiguration();
        if (config != null && (extensionsNode = config.getChild("nonFilteredFileExtensions")) != null && extensionsNode.getChildCount() > 0) {
            return extensionsNode.getChildren();
        }
        return new Xpp3Dom[0];
    }

    public Collection<String> getFilters() {
        Xpp3Dom filtersNode;
        Xpp3Dom config = this.getConfiguration();
        if (config != null && (filtersNode = config.getChild("filters")) != null && filtersNode.getChildCount() > 0) {
            ArrayList<String> filters = new ArrayList<String>(filtersNode.getChildCount());
            Xpp3Dom[] xpp3DomArray = filtersNode.getChildren("filter");
            int n = xpp3DomArray.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom filterNode = xpp3DomArray[n2];
                String filter = filterNode.getValue();
                if (!StringUtils.nullOrEmpty(filter)) {
                    filters.add(filter);
                }
                ++n2;
            }
            return filters;
        }
        return Collections.emptyList();
    }

    public boolean isFilteringDeploymentDescriptorsEnabled() {
        Xpp3Dom configuration = this.getConfiguration();
        if (configuration == null) {
            return false;
        }
        return DomUtils.getBooleanChildValue(configuration, this.getFilteringAttribute());
    }

    protected abstract String getFilteringAttribute();
}

