/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.Database;

public interface DatabaseObject {
    public static final Transformer<DatabaseObject, String> NAME_TRANSFORMER = new NameTransformer();
    public static final Transformer<DatabaseObject, String> IDENTIFIER_TRANSFORMER = new IdentifierTransformer();
    public static final Comparator<DatabaseObject> DEFAULT_COMPARATOR = new DefaultComparator();

    public String getName();

    public String getIdentifier();

    public String getIdentifier(String var1);

    public Database getDatabase();

    public ConnectionProfile getConnectionProfile();

    public void refresh();

    public static class DefaultComparator
    implements Comparator<DatabaseObject> {
        @Override
        public int compare(DatabaseObject dbObject1, DatabaseObject dbObject2) {
            return Collator.getInstance().compare(dbObject1.getName(), dbObject2.getName());
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }
    }

    public static class IdentifierTransformer
    extends TransformerAdapter<DatabaseObject, String> {
        public String transform(DatabaseObject dbObject) {
            return dbObject.getIdentifier();
        }
    }

    public static class NameTransformer
    extends TransformerAdapter<DatabaseObject, String> {
        public String transform(DatabaseObject dbObject) {
            return dbObject.getName();
        }
    }
}

