/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.cm.strategy;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.internal.managedobject.IManagedObject;
import org.eclipse.jst.jsf.common.internal.managedobject.ObjectManager;
import org.eclipse.jst.jsf.common.internal.resource.ResourceSingletonObjectManager;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.cm.AttributeCMAdapter;
import org.eclipse.jst.jsf.facelet.core.internal.cm.ExternalTagInfo;
import org.eclipse.jst.jsf.facelet.core.internal.cm.TagInfo;
import org.eclipse.jst.jsf.facelet.core.internal.cm.addtagmd.AddTagMDPackage;
import org.eclipse.jst.jsf.facelet.core.internal.cm.addtagmd.AttributeData;
import org.eclipse.jst.jsf.facelet.core.internal.cm.addtagmd.AttributeUsage;
import org.eclipse.jst.jsf.facelet.core.internal.cm.addtagmd.ElementData;
import org.eclipse.jst.jsf.facelet.core.internal.cm.addtagmd.provider.IResourceProvider;
import org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.AbstractExternalMetadataStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.IExternalMetadataStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.InternalNamedNodeMap;
import org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.Messages;
import org.eclipse.jst.jsf.facelet.core.internal.util.TagMetadataLoader;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

public class MDExternalMetadataStrategy
extends AbstractExternalMetadataStrategy
implements IManagedObject {
    private static MySingletonManager MANAGER = new MySingletonManager();
    public static final String STRATEGY_ID = "org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.MDExternalMetadataStrategy";
    private final IProject _project;
    private final TagMetadataLoader _tagMetadataLoader;
    private final Map<String, MDExternalTagInfo> _cached;
    private final AtomicBoolean _isDisposed = new AtomicBoolean(false);
    private static final InternalNamedNodeMap.NullInternalNamedNodeMap NULL_INSTANCE = new InternalNamedNodeMap.NullInternalNamedNodeMap();
    static final Map<String, InternalNamedNodeMap> _faceletData;

    static {
        HashMap map = new HashMap();
        _faceletData = Collections.unmodifiableMap(map);
    }

    public static IExternalMetadataStrategy create(IProject project) {
        try {
            return (IExternalMetadataStrategy)MANAGER.getInstance((IResource)project);
        }
        catch (ObjectManager.ManagedObjectException e) {
            FaceletCorePlugin.log("Getting managed instance of tag metadata strategy", e);
            return new IExternalMetadataStrategy.NullExternalMetadataStrategy();
        }
    }

    private MDExternalMetadataStrategy(IProject project) {
        super(STRATEGY_ID, Messages.MDExternalMetadataStrategy_DisplayName);
        this._project = project;
        this._tagMetadataLoader = new TagMetadataLoader(this._project);
        this._cached = new HashMap<String, MDExternalTagInfo>();
    }

    public void checkpoint() {
    }

    public void destroy() {
    }

    public void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            this._cached.clear();
        }
    }

    @Override
    public TagInfo perform(TagIdentifier input) throws Exception {
        MDExternalTagInfo tagInfo = this._cached.get(input.getUri());
        if (tagInfo == null) {
            tagInfo = new MDExternalTagInfo(input.getUri(), this._tagMetadataLoader);
            this._cached.put(input.getUri(), tagInfo);
        }
        return tagInfo;
    }

    private static CMAttributeDeclaration createAttribute(AttributeData attributeData) {
        AttributeCMAdapter attribute = new AttributeCMAdapter(attributeData.getName(), MDExternalMetadataStrategy.convertUsageEnum(attributeData.getUsage()));
        ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        Adapter provider = factory.adapt((Notifier)attributeData, IResourceProvider.class);
        String description = attributeData.getDescription();
        if (provider instanceof IResourceProvider) {
            IResourceProvider resProvider = (IResourceProvider)provider;
            String translated = resProvider.getTranslatedString(attributeData, (EStructuralFeature)AddTagMDPackage.eINSTANCE.getAttributeData_Description());
            description = translated != null ? translated : description;
        }
        attribute.setDescription(description);
        return attribute;
    }

    private static int convertUsageEnum(AttributeUsage usage) {
        switch (usage) {
            case OPTIONAL: {
                return 1;
            }
            case REQUIRED: {
                return 2;
            }
            case FIXED: {
                return 3;
            }
            case PROHIBITED: {
                return 4;
            }
        }
        return 1;
    }

    public boolean isDisposed() {
        return this._isDisposed.get();
    }

    private static class MDExternalTagInfo
    extends ExternalTagInfo {
        private final String _uri;
        private final TagMetadataLoader _tagMetadataLoader;
        private final Map<String, InternalNamedNodeMap> _attributes;

        public MDExternalTagInfo(String uri, TagMetadataLoader tagMetadataLoader) {
            this._uri = uri;
            this._tagMetadataLoader = tagMetadataLoader;
            this._attributes = new HashMap<String, InternalNamedNodeMap>();
        }

        @Override
        public CMNamedNodeMap getAttributes(final String tagName) {
            InternalNamedNodeMap nodeMap = this._attributes.get(tagName);
            final InternalNamedNodeMap[] innerClassNodeMap = new InternalNamedNodeMap[]{nodeMap};
            if (nodeMap == null) {
                SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() {
                        ElementData data = _tagMetadataLoader.getElementData(_uri, tagName);
                        if (data != null) {
                            innerClassNodeMap[0] = new InternalNamedNodeMap();
                            for (AttributeData attribute : data.getAttributes()) {
                                innerClassNodeMap[0].add((CMNode)MDExternalMetadataStrategy.createAttribute(attribute));
                            }
                            _attributes.put(tagName, innerClassNodeMap[0]);
                        } else {
                            _attributes.put(tagName, NULL_INSTANCE);
                        }
                    }

                    public void handleException(Throwable exception) {
                        FaceletCorePlugin.log("While loading attribute meta-data", exception);
                    }
                });
            }
            if (innerClassNodeMap[0] == NULL_INSTANCE) {
                return null;
            }
            return innerClassNodeMap[0];
        }

        @Override
        public Object getTagProperty(final String tagName, final String key) {
            final Object[] value = new Object[]{null};
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void run() {
                    if ("description".equals(key)) {
                        value[0] = _tagMetadataLoader.getDescription(_uri, tagName);
                    }
                }

                public void handleException(Throwable exception) {
                    FaceletCorePlugin.log("While loading tag property meta-data", exception);
                }
            });
            return value[0];
        }
    }

    private static class MySingletonManager
    extends ResourceSingletonObjectManager<MDExternalMetadataStrategy, IProject> {
        protected MySingletonManager() {
            super(ResourcesPlugin.getWorkspace());
        }

        protected MDExternalMetadataStrategy createNewInstance(IProject resource) {
            return new MDExternalMetadataStrategy(resource);
        }
    }
}

