/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.dltk.internal.debug.ui.log.Messages;
import org.eclipse.dltk.internal.debug.ui.log.ScriptDebugLogItem;
import org.eclipse.dltk.internal.ui.text.DLTKColorManager;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class ScriptDebugLogLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private final IColorManager colorManager = new DLTKColorManager(false);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final String XML_DECL_BEGIN = "<?xml";
    private static final String XML_DECL_END = "?>";
    private final RGB textColor = new RGB(85, 85, 85);
    private final RGB inputColor = new RGB(0, 0, 255);
    private final RGB outputColor = new RGB(0, 128, 0);

    public void dispose() {
        super.dispose();
        this.colorManager.dispose();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ScriptDebugLogItem) {
            ScriptDebugLogItem item = (ScriptDebugLogItem)element;
            switch (columnIndex) {
                case 0: {
                    return this.dateFormat.format(new Date(item.getTimestamp()));
                }
                case 1: {
                    return this.timeFormat.format(new Date(item.getTimestamp()));
                }
                case 2: {
                    return item.getType();
                }
                case 3: {
                    if (item.getSessionId() <= 0) break;
                    return String.valueOf(item.getSessionId());
                }
                case 4: {
                    return this.formatMessage(item);
                }
            }
        }
        return null;
    }

    private String formatMessage(ScriptDebugLogItem item) {
        int end;
        String result = item.getMessage();
        if (result.startsWith(XML_DECL_BEGIN) && (end = result.indexOf(XML_DECL_END)) >= 0) {
            end += XML_DECL_END.length();
            while (end < result.length() && Character.isWhitespace(result.charAt(end))) {
                ++end;
            }
            result = result.substring(end);
        }
        return result.replaceAll("[\\p{Cntrl}]+", "");
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof ScriptDebugLogItem) {
            ScriptDebugLogItem item = (ScriptDebugLogItem)element;
            if (item.getType() == Messages.ItemType_Input) {
                return this.colorManager.getColor(this.inputColor);
            }
            if (item.getType() == Messages.ItemType_Output) {
                return this.colorManager.getColor(this.outputColor);
            }
            return this.colorManager.getColor(this.textColor);
        }
        return null;
    }
}

