/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.egit.ui.internal.logical;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.logical.IModelMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.jgit.lib.Repository;

public class SingleRepositoryMinimizer
implements IModelMinimizer {
    protected Repository expectedRepository;

    public void minimize(SynchronizationModel syncModel, IProgressMonitor monitor) {
        if (this.getExpectedRepository() == null) {
            return;
        }
        SubMonitor progess = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progess.subTask(EMFCompareIDEUIMessages.getString((String)"EMFSynchronizationModel.minimizing"));
        StorageTraversal leftTraversal = syncModel.getLeftTraversal();
        Set leftCopy = leftTraversal.getStorages();
        SubMonitor subMonitor = progess.newChild(100).setWorkRemaining(leftCopy.size());
        for (IStorage left : leftCopy) {
            if (!this.hasExpectedRepository(left)) {
                leftTraversal.removeStorage(left);
            }
            subMonitor.worked(1);
        }
    }

    public void minimize(IFile file, SynchronizationModel syncModel, IProgressMonitor monitor) {
        this.setExpectedRepository(SingleRepositoryMinimizer.getRepository(file));
        this.minimize(syncModel, monitor);
    }

    protected boolean hasExpectedRepository(IStorage storage) {
        return this.getExpectedRepository() == null || this.getExpectedRepository() == SingleRepositoryMinimizer.getRepository(storage);
    }

    protected void setExpectedRepository(Repository expectedRepository) {
        this.expectedRepository = expectedRepository;
    }

    public Repository getExpectedRepository() {
        return this.expectedRepository;
    }

    public static Repository getRepository(IFile file) {
        if (file == null) {
            return null;
        }
        return ResourceUtil.getRepository((IResource)file);
    }

    public static Repository getRepository(IStorage storage) {
        IFile file = (IFile)storage.getAdapter(IFile.class);
        if (file != null) {
            return SingleRepositoryMinimizer.getRepository(file);
        }
        return null;
    }
}

