/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.actions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;

public class ContextualLaunchableTester
extends PropertyTester {
    private Map<String, Expression> expressions = new HashMap<String, Expression>();

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        String delegateShortcutID = (String)args[0];
        Expression expr = this.expressions.get(delegateShortcutID);
        if (expr == null) {
            expr = this.createEnablementExpression(delegateShortcutID);
            this.expressions.put(delegateShortcutID, expr);
        }
        try {
            return expr.evaluate(this.createContext(receiver)) != EvaluationResult.FALSE;
        }
        catch (CoreException ce) {
            EclEmmaUIPlugin.getInstance().getLog().log(EclEmmaUIPlugin.errorStatus("Launch shortcut '" + delegateShortcutID + "' enablement expression caused exception.", ce));
            return false;
        }
    }

    private IEvaluationContext createContext(Object selection) {
        EvaluationContext context = new EvaluationContext(null, selection);
        context.addVariable("selection", selection);
        return context;
    }

    private Expression createEnablementExpression(String delegateShortcutID) {
        IConfigurationElement element = this.findEnablementConfiguration(delegateShortcutID);
        if (element != null) {
            try {
                return ExpressionConverter.getDefault().perform(element);
            }
            catch (CoreException ce) {
                EclEmmaUIPlugin.log(ce);
            }
        }
        return Expression.FALSE;
    }

    private IConfigurationElement findEnablementConfiguration(String delegateShortcutID) {
        IConfigurationElement[] configs;
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.debug.ui.launchShortcuts");
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] enablement;
            IConfigurationElement[] launch;
            String modes;
            IConfigurationElement config = iConfigurationElementArray[n2];
            if (delegateShortcutID.equals(config.getAttribute("id")) && (modes = config.getAttribute("modes")) != null && Arrays.asList(modes.split("\\W")).contains("run") && (launch = config.getChildren("contextualLaunch")).length == 1 && (enablement = launch[0].getChildren("enablement")).length == 1) {
                return enablement[0];
            }
            ++n2;
        }
        return null;
    }
}

