/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.html.internal;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.mylyn.wikitext.html.internal.HtmlElementStrategy;
import org.eclipse.mylyn.wikitext.parser.Attributes;

abstract class ElementStrategies<ElementType extends Enum<ElementType>, ElementStrategy, HtmlElementStrategyType extends HtmlElementStrategy<ElementType>> {
    private Map<ElementType, ElementStrategy> elementStrategyByElementType;
    private final List<HtmlElementStrategyType> elementStrategies;

    ElementStrategies(Class<ElementType> elementTypeClass, Set<ElementType> elementTypes, List<HtmlElementStrategyType> elementStrategies) {
        Objects.requireNonNull(elementTypeClass);
        Objects.requireNonNull(elementTypes);
        this.elementStrategies = List.copyOf((Collection)Objects.requireNonNull(elementStrategies));
        this.initialize(elementTypeClass, elementTypes);
    }

    public ElementStrategy getStrategy(ElementType elementType, Attributes attributes) {
        Objects.requireNonNull(elementType);
        for (HtmlElementStrategy strategy : this.elementStrategies) {
            if (!strategy.matcher().matches(elementType, attributes)) continue;
            return this.getElementStrategy(strategy);
        }
        return Objects.requireNonNull(this.elementStrategyByElementType.get(elementType));
    }

    abstract ElementStrategy getElementStrategy(HtmlElementStrategyType var1);

    private void initialize(Class<ElementType> elementTypeClass, Set<ElementType> elementTypes) {
        HashMap elementStrategyByElementType = new HashMap();
        for (Enum elementType : elementTypes) {
            this.addSupportedElementType(elementStrategyByElementType, elementType);
        }
        this.addImplicitElementTypes(elementStrategyByElementType, elementTypes);
        HashMap alternativesByElementType = new HashMap();
        for (Enum elementType : EnumSet.allOf(elementTypeClass)) {
            if (elementStrategyByElementType.containsKey(elementType)) continue;
            alternativesByElementType.put(elementType, this.calculateFallBackElementStrategy(elementStrategyByElementType, elementType));
        }
        elementStrategyByElementType.putAll(alternativesByElementType);
        this.elementStrategyByElementType = Map.copyOf(elementStrategyByElementType);
    }

    abstract void addImplicitElementTypes(Map<ElementType, ElementStrategy> var1, Set<ElementType> var2);

    void addSupportedElementType(Map<ElementType, ElementStrategy> elementStrategyByElementType, ElementType elementType) {
        elementStrategyByElementType.put(elementType, this.getSupportedStrategy(elementType));
    }

    abstract ElementStrategy getSupportedStrategy(ElementType var1);

    abstract ElementStrategy getUnsupportedElementStrategy(ElementType var1);

    abstract ElementStrategy createSubstitutionElementStrategy(ElementType var1);

    abstract Map<ElementType, List<ElementType>> getElementTypeToAlternatives();

    private ElementStrategy calculateFallBackElementStrategy(Map<ElementType, ElementStrategy> strategies, ElementType elementType) {
        ElementStrategy elementStrategy = null;
        List<ElementType> alternatives = this.getElementTypeToAlternatives().get(elementType);
        if (alternatives != null) {
            for (Enum alternative : alternatives) {
                if (!strategies.containsKey(alternative)) continue;
                elementStrategy = this.createSubstitutionElementStrategy(alternative);
                break;
            }
        }
        if (elementStrategy == null) {
            elementStrategy = this.getUnsupportedElementStrategy(elementType);
        }
        return elementStrategy;
    }
}

