/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui;

import java.io.IOException;
import java.io.Reader;

public class HTMLPrinter {
    private HTMLPrinter() {
    }

    private static String replace(String text, char c, String s) {
        int previous = 0;
        int current = text.indexOf(c, previous);
        if (current == -1) {
            return text;
        }
        StringBuilder buffer = new StringBuilder();
        while (current > -1) {
            buffer.append(text.substring(previous, current));
            buffer.append(s);
            previous = current + 1;
            current = text.indexOf(c, previous);
        }
        buffer.append(text.substring(previous));
        return buffer.toString();
    }

    public static String convertToHTMLContent(String content) {
        content = HTMLPrinter.replace(content, '<', "&lt;");
        return HTMLPrinter.replace(content, '>', "&gt;");
    }

    public static String read(Reader rd) {
        StringBuilder buffer = new StringBuilder();
        char[] readBuffer = new char[2048];
        try {
            int n = rd.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer, 0, n);
                n = rd.read(readBuffer);
            }
            return buffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void insertPageProlog(StringBuilder buffer, int position) {
        buffer.insert(position, "<html><body text=\"#000000\" bgcolor=\"#FFFF88\"><font size=-1>");
    }

    public static void addPageProlog(StringBuilder buffer) {
        HTMLPrinter.insertPageProlog(buffer, buffer.length());
    }

    public static void addPageEpilog(StringBuilder buffer) {
        buffer.append("</font></body></html>");
    }

    public static void startBulletList(StringBuilder buffer) {
        buffer.append("<ul>");
    }

    public static void endBulletList(StringBuilder buffer) {
        buffer.append("</ul>");
    }

    public static void addBullet(StringBuilder buffer, String bullet) {
        if (bullet != null) {
            buffer.append("<li>");
            buffer.append(bullet);
            buffer.append("</li>");
        }
    }

    public static void addSmallHeader(StringBuilder buffer, String header) {
        if (header != null) {
            buffer.append("<h5>");
            buffer.append(header);
            buffer.append("</h5>");
        }
    }

    public static void addParagraph(StringBuilder buffer, String paragraph) {
        if (paragraph != null) {
            buffer.append("<p>");
            buffer.append(paragraph);
        }
    }

    public static void addParagraph(StringBuilder buffer, Reader paragraphReader) {
        if (paragraphReader != null) {
            HTMLPrinter.addParagraph(buffer, HTMLPrinter.read(paragraphReader));
        }
    }
}

