/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewer;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Item;

public class BreakpointsDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private final AbstractTreeViewer fViewer;
    private Item[] fItems = null;
    private BreakpointsView fView;
    private TreePath[] fTreePaths = null;

    public BreakpointsDragAdapter(BreakpointsViewer viewer) {
        Assert.isNotNull((Object)((Object)viewer));
        this.fViewer = viewer;
    }

    public BreakpointsDragAdapter(AbstractTreeViewer viewer, BreakpointsView view) {
        Assert.isNotNull((Object)view);
        this.fViewer = viewer;
        this.fView = view;
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getTransfer();
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.fViewer.getSelection();
        LocalSelectionTransfer.getTransfer().setSelection(selection);
        LocalSelectionTransfer.getTransfer().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
        AbstractTreeViewer abstractTreeViewer = this.fViewer;
        if (abstractTreeViewer instanceof BreakpointsViewer) {
            BreakpointsViewer viewer = (BreakpointsViewer)abstractTreeViewer;
            this.fItems = viewer.getSelectedItems();
            event.doit = viewer.canDrag(this.fItems);
        } else {
            this.fTreePaths = selection instanceof ITreeSelection ? ((ITreeSelection)selection).getPaths() : new TreePath[0];
            event.doit = this.fView.canDrag(this.fTreePaths);
        }
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = LocalSelectionTransfer.getTransfer().getSelection();
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.detail == 2) {
            AbstractTreeViewer abstractTreeViewer = this.fViewer;
            if (abstractTreeViewer instanceof BreakpointsViewer) {
                BreakpointsViewer viewer = (BreakpointsViewer)abstractTreeViewer;
                viewer.performDrag(this.fItems);
            } else {
                this.fView.performDrag(this.fTreePaths);
            }
        }
        this.fItems = null;
        LocalSelectionTransfer.getTransfer().setSelection(null);
        LocalSelectionTransfer.getTransfer().setSelectionSetTime(0L);
    }
}

