/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class CLIShowEndianInfo
extends MIInfo {
    private static final String BIG_ENDIAN = "big endian";
    private boolean fIsBigEndian = false;

    public CLIShowEndianInfo(MIOutput record) {
        super(record);
        this.parse();
    }

    protected void parse() {
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] mIOOBRecordArray = out.getMIOOBRecords();
            int n = mIOOBRecordArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line;
                MIOOBRecord oob = mIOOBRecordArray[n2];
                if (oob instanceof MIConsoleStreamOutput && (line = ((MIConsoleStreamOutput)oob).getString().trim()).indexOf(BIG_ENDIAN) >= 0) {
                    this.fIsBigEndian = true;
                    break;
                }
                ++n2;
            }
        }
    }

    public boolean isBigEndian() {
        return this.fIsBigEndian;
    }
}

