/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.search;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.Person;
import org.eclipse.mylyn.internal.tasks.core.TaskGroup;
import org.eclipse.mylyn.internal.tasks.ui.search.Messages;
import org.eclipse.mylyn.internal.tasks.ui.search.RepositorySearchResult;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultContentProvider;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;

public class SearchResultTreeContentProvider
extends SearchResultContentProvider {
    private final Set<Object> elements = new LinkedHashSet<Object>();
    private final Map<String, Person> owners = new HashMap<String, Person>();
    private final Map<String, TaskGroup> completeState = new HashMap<String, TaskGroup>();
    private GroupBy selectedGroup;

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof RepositorySearchResult) {
            this.searchResult = (RepositorySearchResult)((Object)newInput);
            this.clear();
            this.elementsChanged(this.searchResult.getElements());
        } else {
            this.searchResult = null;
            this.clear();
        }
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement == this.searchResult) {
            if (this.selectedGroup == GroupBy.OWNER) {
                return this.owners.values().toArray();
            }
            if (this.selectedGroup == GroupBy.COMPLETION) {
                return this.completeState.values().toArray();
            }
            return this.elements.toArray();
        }
        return this.EMPTY_ARR;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof TaskGroup || parent instanceof Person) {
            return ((ITaskContainer)parent).getChildren().toArray();
        }
        return this.EMPTY_ARR;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    @Override
    public void elementsChanged(Object[] updatedElements) {
        Object[] objectArray = updatedElements;
        int n = updatedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] resultElements;
            Object object = objectArray[n2];
            boolean inResult = false;
            Object[] objectArray2 = resultElements = this.searchResult.getElements();
            int n3 = resultElements.length;
            int n4 = 0;
            while (n4 < n3) {
                Object resultObject = objectArray2[n4];
                if (resultObject.equals(object)) {
                    inResult = true;
                }
                ++n4;
            }
            if (inResult) {
                boolean added = this.elements.add(object);
                if (added && object instanceof ITask) {
                    Person person;
                    AbstractTask task = (AbstractTask)object;
                    String owner = task.getOwner();
                    if (owner == null) {
                        owner = Messages.SearchResultTreeContentProvider__unknown_;
                    }
                    if ((person = this.owners.get(owner)) == null) {
                        person = new Person(owner, task.getConnectorKind(), task.getRepositoryUrl());
                        this.owners.put(owner, person);
                    }
                    person.internalAddChild(task);
                    TaskGroup completeIncomplete = null;
                    if (task.isCompleted()) {
                        completeIncomplete = this.completeState.get(Messages.SearchResultTreeContentProvider_Complete);
                        if (completeIncomplete == null) {
                            completeIncomplete = new TaskGroup("group-complete", Messages.SearchResultTreeContentProvider_Complete, GroupBy.COMPLETION.name());
                            this.completeState.put(Messages.SearchResultTreeContentProvider_Complete, completeIncomplete);
                        }
                    } else {
                        completeIncomplete = this.completeState.get(Messages.SearchResultTreeContentProvider_Incomplete);
                        if (completeIncomplete == null) {
                            completeIncomplete = new TaskGroup("group-incomplete", Messages.SearchResultTreeContentProvider_Incomplete, GroupBy.COMPLETION.name());
                            this.completeState.put(Messages.SearchResultTreeContentProvider_Incomplete, completeIncomplete);
                        }
                    }
                    completeIncomplete.internalAddChild(task);
                }
            } else if (object instanceof ITask) {
                AbstractTask task = (AbstractTask)object;
                this.elements.remove(task);
                String owner = task.getOwner();
                if (owner == null) {
                    owner = Messages.SearchResultTreeContentProvider__unknown_;
                }
                Person person = this.owners.get(owner);
                person.internalRemoveChild((ITask)task);
                TaskGroup completeIncomplete = null;
                completeIncomplete = task.isCompleted() ? this.completeState.get(Messages.SearchResultTreeContentProvider_Complete) : this.completeState.get(Messages.SearchResultTreeContentProvider_Incomplete);
                completeIncomplete.internalRemoveChild((ITask)task);
            }
            ++n2;
        }
    }

    @Override
    public void clear() {
        this.elements.clear();
        this.owners.clear();
        this.completeState.clear();
    }

    public GroupBy getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setSelectedGroup(GroupBy selectedGroup) {
        this.selectedGroup = selectedGroup;
    }

    public static enum GroupBy {
        NONE,
        OWNER,
        COMPLETION;

    }
}

