/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.format;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatContraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.util.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public abstract class AbstractStructuredFormatProcessor
implements IStructuredFormatProcessor {
    protected IStructuredFormatContraints fFormatContraints = null;
    protected IProgressMonitor fProgressMonitor = null;
    public boolean refreshFormatPreferences = true;
    private static final int MAX_SMALL_FORMAT_SIZE = 1000;

    protected void ensureClosed(OutputStream outputStream, InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    public String formatContent(String input) throws IOException, CoreException {
        if (input == null) {
            return input;
        }
        IStructuredModel structuredModel = null;
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(input.getBytes("UTF8"));
            String id = String.valueOf(inputStream.toString()) + "." + this.getFileExtension();
            structuredModel = StructuredModelManager.getModelManager().getModelForRead(id, inputStream, null);
            this.formatModel(structuredModel);
            String string = structuredModel.getStructuredDocument().get();
            this.ensureClosed(null, inputStream);
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
            return string;
        }
        catch (Throwable throwable) {
            this.ensureClosed(null, inputStream);
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
            throw throwable;
        }
    }

    public String formatContent(String input, int start, int length) throws IOException, CoreException {
        if (input == null) {
            return input;
        }
        if (start >= 0 && length >= 0 && start + length <= input.length()) {
            IStructuredModel structuredModel = null;
            ByteArrayInputStream inputStream = null;
            try {
                inputStream = new ByteArrayInputStream(input.getBytes("UTF8"));
                String id = String.valueOf(inputStream.toString()) + "." + this.getFileExtension();
                structuredModel = StructuredModelManager.getModelManager().getModelForRead(id, inputStream, null);
                this.formatModel(structuredModel, start, length);
                String string = structuredModel.getStructuredDocument().get();
                this.ensureClosed(null, inputStream);
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
                return string;
            }
            catch (Throwable throwable) {
                this.ensureClosed(null, inputStream);
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
                throw throwable;
            }
        }
        return input;
    }

    public void formatDocument(IDocument document) throws IOException, CoreException {
        if (document == null) {
            return;
        }
        IStructuredModel structuredModel = null;
        try {
            structuredModel = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
            this.formatModel(structuredModel);
            if (!structuredModel.isSharedForEdit() && structuredModel.isSaveNeeded()) {
                structuredModel.save();
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromEdit();
            }
        }
    }

    @Override
    public void formatDocument(IDocument document, int start, int length) throws IOException, CoreException {
        if (document == null) {
            return;
        }
        if (start >= 0 && length >= 0 && start + length <= document.getLength()) {
            IStructuredModel structuredModel = null;
            try {
                structuredModel = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
                if (structuredModel != null) {
                    this.formatModel(structuredModel, start, length);
                    if (!structuredModel.isSharedForEdit() && structuredModel.isSaveNeeded()) {
                        structuredModel.save();
                    }
                }
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromEdit();
                }
            }
        }
    }

    @Override
    public void formatFile(IFile file) throws IOException, CoreException {
        if (file == null) {
            return;
        }
        IStructuredModel structuredModel = null;
        try {
            structuredModel = StructuredModelManager.getModelManager().getModelForEdit(file);
            this.formatModel(structuredModel);
            if (!structuredModel.isSharedForEdit() && structuredModel.isSaveNeeded()) {
                structuredModel.save();
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromEdit();
            }
        }
    }

    public void formatFile(IFile file, int start, int length) throws IOException, CoreException {
        if (file == null) {
            return;
        }
        IStructuredModel structuredModel = null;
        try {
            structuredModel = StructuredModelManager.getModelManager().getModelForEdit(file);
            this.formatModel(structuredModel, start, length);
            if (!structuredModel.isSharedForEdit() && structuredModel.isSaveNeeded()) {
                structuredModel.save();
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromEdit();
            }
        }
    }

    public void formatFileName(String fileName) throws IOException, CoreException {
        if (fileName == null) {
            return;
        }
        IStructuredModel structuredModel = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileName);
            structuredModel = StructuredModelManager.getModelManager().getModelForEdit(fileName, inputStream, null);
            this.formatModel(structuredModel);
            if (!structuredModel.isSharedForEdit() && structuredModel.isSaveNeeded()) {
                structuredModel.save();
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromEdit();
            }
        }
    }

    public void formatFileName(String fileName, int start, int length) throws IOException, CoreException {
        if (fileName == null) {
            return;
        }
        IStructuredModel structuredModel = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileName);
            structuredModel = StructuredModelManager.getModelManager().getModelForEdit(fileName, inputStream, null);
            this.formatModel(structuredModel, start, length);
            if (!structuredModel.isSharedForEdit() && structuredModel.isSaveNeeded()) {
                structuredModel.save();
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromEdit();
            }
        }
    }

    @Override
    public void formatModel(IStructuredModel structuredModel) {
        int start = 0;
        int length = structuredModel.getStructuredDocument().getLength();
        this.formatModel(structuredModel, start, length);
    }

    @Override
    public void formatModel(IStructuredModel structuredModel, int start, int length) {
        if (structuredModel != null) {
            long startTime = System.currentTimeMillis();
            IDocumentExtension4 docExt4 = null;
            if (structuredModel.getStructuredDocument() instanceof IDocumentExtension4) {
                docExt4 = (IDocumentExtension4)structuredModel.getStructuredDocument();
            }
            DocumentRewriteSession rewriteSession = null;
            try {
                List activeNodes;
                structuredModel.aboutToChangeModel();
                DocumentRewriteSessionType rewriteType = length > 1000 ? DocumentRewriteSessionType.UNRESTRICTED : DocumentRewriteSessionType.UNRESTRICTED_SMALL;
                DocumentRewriteSession documentRewriteSession = rewriteSession = docExt4 == null || docExt4.getActiveRewriteSession() != null ? null : docExt4.startRewriteSession(rewriteType);
                if (start == 0 && length == structuredModel.getStructuredDocument().getLength()) {
                    this.setFormatWithSiblingIndent(structuredModel, false);
                } else {
                    this.setFormatWithSiblingIndent(structuredModel, true);
                }
                if (start >= 0 && length >= 0 && start + length <= structuredModel.getStructuredDocument().getLength() && (activeNodes = this.getAllActiveNodes(structuredModel, start, length)).size() > 0) {
                    Node firstNode = (Node)activeNodes.get(0);
                    Node lastNode = (Node)activeNodes.get(activeNodes.size() - 1);
                    boolean done = false;
                    Node eachNode = firstNode;
                    Node nextNode = null;
                    while (!done) {
                        done = eachNode == lastNode;
                        nextNode = eachNode.getNextSibling();
                        this.formatNode(eachNode);
                        eachNode = nextNode != null && nextNode.getParentNode() == null ? eachNode.getNextSibling() : nextNode;
                        if (eachNode != null) continue;
                        done = true;
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    if (docExt4 != null && rewriteSession != null) {
                        docExt4.stopRewriteSession(rewriteSession);
                    }
                }
                finally {
                    structuredModel.changedModel();
                }
                throw throwable;
            }
            try {
                if (docExt4 != null && rewriteSession != null) {
                    docExt4.stopRewriteSession(rewriteSession);
                }
            }
            finally {
                structuredModel.changedModel();
            }
            if (Logger.DEBUG_FORMAT) {
                long endTime = System.currentTimeMillis();
                System.out.println("formatModel time: " + (endTime - startTime));
            }
        }
    }

    @Override
    public void formatNode(Node node) {
        if (node != null) {
            Node newNode = node;
            if (node.getNodeType() == 2) {
                newNode = ((Attr)node).getOwnerElement();
            }
            if (this.refreshFormatPreferences) {
                this.refreshFormatPreferences();
            }
            IStructuredFormatter formatter = this.getFormatter(newNode);
            Assert.isNotNull(formatter, "formatter was null for a node, ");
            IStructuredFormatContraints formatContraints = formatter.getFormatContraints();
            formatContraints.setFormatWithSiblingIndent(true);
            formatter.format(newNode, formatContraints);
        }
    }

    protected Vector getActiveNodes(IStructuredModel structuredModel, int startNodeOffset, int length) {
        List allActiveNodes = this.getAllActiveNodes(structuredModel, startNodeOffset, length);
        return new Vector(allActiveNodes);
    }

    protected List getAllActiveNodes(IStructuredModel structuredModel, int startNodeOffset, int length) {
        ArrayList<Node> activeNodes = new ArrayList<Node>();
        if (structuredModel != null) {
            Node startNode = (Node)((Object)structuredModel.getIndexedRegion(startNodeOffset));
            int endNodeOffset = length > 0 ? startNodeOffset + length - 1 : startNodeOffset + length;
            Node endNode = (Node)((Object)structuredModel.getIndexedRegion(endNodeOffset));
            if (startNode != null) {
                while (!this.isSiblingOf(startNode, endNode)) {
                    if (endNode != null) {
                        endNode = endNode.getParentNode();
                    }
                    if (endNode != null) continue;
                    startNode = startNode.getParentNode();
                    endNodeOffset = length > 0 ? startNodeOffset + length - 1 : startNodeOffset + length;
                    endNode = (Node)((Object)structuredModel.getIndexedRegion(endNodeOffset));
                }
                while (startNode != endNode) {
                    activeNodes.add(startNode);
                    startNode = startNode.getNextSibling();
                }
                if (startNode != null) {
                    activeNodes.add(startNode);
                }
            }
        }
        return activeNodes;
    }

    protected abstract String getFileExtension();

    protected IStructuredFormatContraints getFormatContraints(IStructuredModel structuredModel) {
        IStructuredFormatter formatter;
        Node node;
        if (this.fFormatContraints == null && structuredModel != null && (node = (Node)((Object)structuredModel.getIndexedRegion(0))) != null && (formatter = this.getFormatter(node)) != null) {
            this.fFormatContraints = formatter.getFormatContraints();
        }
        return this.fFormatContraints;
    }

    protected abstract IStructuredFormatter getFormatter(Node var1);

    protected boolean isSiblingOf(Node node, Node endNode) {
        if (endNode == null) {
            return true;
        }
        Node siblingNode = node;
        while (siblingNode != null) {
            if (siblingNode == endNode) {
                return true;
            }
            siblingNode = siblingNode.getNextSibling();
        }
        return false;
    }

    protected abstract void refreshFormatPreferences();

    protected void setFormatWithSiblingIndent(IStructuredModel structuredModel, boolean formatWithSiblingIndent) {
        IStructuredFormatContraints formatContraints = this.getFormatContraints(structuredModel);
        if (formatContraints != null) {
            formatContraints.setFormatWithSiblingIndent(formatWithSiblingIndent);
        }
    }

    @Override
    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }
}

