/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.memory.transport;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.eclipse.cdt.debug.core.memory.transport.ExportRequest;
import org.eclipse.cdt.debug.core.memory.transport.FileExport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;

public final class SRecordExport
extends FileExport {
    public SRecordExport(File input, ExportRequest request) {
        super(input, request);
    }

    @Override
    protected BigInteger chunkSize() {
        return BigInteger.valueOf(16L);
    }

    @Override
    protected void transfer(OutputStream output, BigInteger factor, IProgressMonitor monitor) throws IOException, DebugException {
        BigInteger DATA_PER_RECORD = this.chunkSize();
        BigInteger DATA_PER_TRANSFER = BigInteger.valueOf(4096L).multiply(DATA_PER_RECORD);
        BigInteger jobCount = BigInteger.ZERO;
        BigInteger transferAddress = this.start;
        while (transferAddress.compareTo(this.end) < 0 && !monitor.isCanceled()) {
            BigInteger length = DATA_PER_TRANSFER;
            if (this.end.subtract(transferAddress).compareTo(length) < 0) {
                length = this.end.subtract(transferAddress);
            }
            monitor.subTask(this.transferring(length, transferAddress));
            MemoryByte[] bytes = this.read.from(transferAddress, length.longValue() / this.addressable.longValue());
            BigInteger sRecordAddress = transferAddress;
            BigInteger sRecordEndAddress = transferAddress.add(length);
            while (sRecordAddress.compareTo(sRecordEndAddress) < 0 && !monitor.isCanceled()) {
                String bString;
                BigInteger sRecordDataLength = DATA_PER_RECORD;
                if (sRecordEndAddress.subtract(sRecordAddress).compareTo(sRecordDataLength) < 0) {
                    sRecordDataLength = this.end.subtract(sRecordAddress);
                }
                output.write("S3".getBytes());
                StringBuilder buf = new StringBuilder();
                BigInteger sRecordLength = BigInteger.valueOf(4L);
                sRecordLength = sRecordLength.add(sRecordDataLength);
                sRecordLength = sRecordLength.add(BigInteger.ONE);
                String transferAddressString = sRecordAddress.toString(16);
                String lengthString = sRecordLength.toString(16);
                if (lengthString.length() == 1) {
                    buf.append("0");
                }
                buf.append(lengthString);
                int i = 0;
                while (i < 8 - transferAddressString.length()) {
                    buf.append("0");
                    ++i;
                }
                buf.append(transferAddressString);
                int byteOffset = sRecordAddress.subtract(transferAddress).intValue();
                int byteLength = byteOffset + sRecordDataLength.intValue();
                int byteIndex = byteOffset;
                while (byteIndex < byteLength) {
                    bString = BigInteger.valueOf(0xFF & bytes[byteIndex].getValue()).toString(16);
                    if (bString.length() == 1) {
                        buf.append("0");
                    }
                    buf.append(bString);
                    ++byteIndex;
                }
                int checksum = 0;
                int i2 = 0;
                while (i2 < buf.length()) {
                    BigInteger value = new BigInteger(buf.substring(i2, i2 + 2), 16);
                    checksum = (byte)(checksum + value.byteValue());
                    i2 += 2;
                }
                bString = BigInteger.valueOf(255 - checksum).and(BigInteger.valueOf(255L)).toString(16);
                if (bString.length() == 1) {
                    buf.append("0");
                }
                buf.append(bString);
                output.write(buf.toString().toUpperCase().getBytes());
                output.write("\n".getBytes());
                sRecordAddress = sRecordAddress.add(sRecordDataLength);
                jobCount = jobCount.add(BigInteger.ONE);
                if (jobCount.compareTo(factor) != 0) continue;
                jobCount = BigInteger.ZERO;
                monitor.worked(1);
            }
            transferAddress = transferAddress.add(length);
        }
    }
}

