/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.actions;

import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDComplexTypeDefinitionAdapter;
import org.eclipse.wst.xsd.ui.internal.common.actions.XSDBaseAction;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddEnumerationsCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class AddXSDEnumerationFacetAction
extends XSDBaseAction {
    public static String ID = "org.eclipse.wst.xsd.ui.AddXSDEnumerationFacetAction";
    public static String BEFORE_SELECTED_ID = "org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDEnumerationFacetAction.BEFORE_SELECTED_ID";
    public static String AFTER_SELECTED_ID = "org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDEnumerationFacetAction.AFTER_SELECTED_ID";

    public AddXSDEnumerationFacetAction(IWorkbenchPart part, String id, String label) {
        super(part);
        this.setText(label);
        this.setId(id);
    }

    public AddXSDEnumerationFacetAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages._UI_ACTION_ADD_ENUMERATION);
        this.setId(ID);
    }

    public void run() {
        Object selection = ((IStructuredSelection)this.getSelection()).getFirstElement();
        if (selection instanceof XSDBaseAdapter) {
            selection = ((XSDBaseAdapter)selection).getTarget();
            int index = -1;
            AddEnumerationsCommand command = null;
            XSDSimpleTypeDefinition st = null;
            if (selection instanceof XSDSimpleTypeDefinition) {
                st = (XSDSimpleTypeDefinition)selection;
                command = new AddEnumerationsCommand(this.getText(), st);
            } else if (selection instanceof XSDEnumerationFacet) {
                st = ((XSDEnumerationFacet)selection).getSimpleTypeDefinition();
                index = st.getFacetContents().indexOf(selection);
                this.doDirectEdit = true;
                command = new AddEnumerationsCommand(this.getText(), st, this.getId(), index);
            } else if (selection instanceof XSDComplexTypeDefinition) {
                st = (XSDSimpleTypeDefinition)((XSDComplexTypeDefinition)selection).getContent();
                command = new AddEnumerationsCommand(this.getText(), st);
            } else {
                return;
            }
            EList enumList = st.getEnumerationFacets();
            String newName = XSDCommonUIUtils.createUniqueEnumerationValue("value", (List)enumList);
            command.setValue(newName);
            this.getCommandStack().execute((Command)command);
            this.addedComponent = command.getAddedComponent();
            Adapter adapter = XSDAdapterFactory.getInstance().adapt((Notifier)this.addedComponent);
            this.selectAddedComponent(adapter);
        }
    }

    protected boolean calculateEnabled() {
        XSDComplexTypeDefinition definition;
        XSDTypeDefinition baseType;
        boolean parentResult = super.calculateEnabled();
        boolean endResult = true;
        Object selection = ((IStructuredSelection)this.getSelection()).getFirstElement();
        if (selection instanceof XSDComplexTypeDefinitionAdapter && (baseType = (definition = ((XSDComplexTypeDefinitionAdapter)selection).getXSDComplexTypeDefinition()).getBaseType()) instanceof XSDSimpleTypeDefinition) {
            endResult = false;
        }
        return endResult &= parentResult;
    }
}

