/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.Point;

public class CompositeDebugImageDescriptor
extends CompositeImageDescriptor {
    public static final int SKIP_BREAKPOINT = 1;
    private Image fBaseImage;
    private int fFlags;
    private Point fSize;

    public CompositeDebugImageDescriptor(Image baseImage, int flags) {
        this.setBaseImage(baseImage);
        this.setFlags(flags);
    }

    protected Point getSize() {
        if (this.fSize == null) {
            CompositeImageDescriptor.CachedImageDataProvider provider = this.createCachedImageDataProvider(this.getBaseImage());
            this.setSize(new Point(provider.getWidth(), provider.getHeight()));
        }
        return this.fSize;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        void other;
        if (!(object instanceof CompositeDebugImageDescriptor)) {
            return false;
        }
        CompositeDebugImageDescriptor compositeDebugImageDescriptor = (CompositeDebugImageDescriptor)((Object)object);
        return this.getBaseImage().equals((Object)other.getBaseImage()) && this.getFlags() == other.getFlags();
    }

    public int hashCode() {
        return this.getBaseImage().hashCode() | this.getFlags();
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage((ImageDataProvider)this.createCachedImageDataProvider(this.getBaseImage()), 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        int flags = this.getFlags();
        int x = 0;
        int y = 0;
        if ((flags & 1) != 0) {
            x = 0;
            y = 0;
            CompositeImageDescriptor.CachedImageDataProvider provider = this.createCachedImageDataProvider(DebugUITools.getImage("IMG_OVR_SKIP_BREAKPOINT"));
            this.drawImage((ImageDataProvider)provider, x, y);
        }
    }

    protected Image getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(Image image) {
        this.fBaseImage = image;
    }

    protected int getFlags() {
        return this.fFlags;
    }

    protected void setFlags(int flags) {
        this.fFlags = flags;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

