/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaLogicalStructure;
import org.eclipse.jdt.internal.debug.core.logicalstructures.JavaLogicalStructures;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.EditLogicalStructureDialog;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class JavaLogicalStructuresPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ISelectionChangedListener,
Listener {
    private TableViewer fLogicalStructuresViewer;
    private Button fAddLogicalStructureButton;
    private Button fEditLogicalStructureButton;
    private Button fRemoveLogicalStructureButton;
    private LogicalStructuresListViewerContentProvider fLogicalStructuresContentProvider;
    protected static String[] fTableColumnProperties = new String[]{"type", "showAs"};
    protected String[] fTableColumnHeaders = new String[]{DebugUIMessages.JavaLogicalStructuresPreferencePage_9, DebugUIMessages.JavaLogicalStructuresPreferencePage_10};
    protected ColumnLayoutData[] fTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(70), new ColumnWeightData(30)};
    private JDISourceViewer fCodeViewer;

    public JavaLogicalStructuresPreferencePage() {
        super(DebugUIMessages.JavaLogicalStructuresPreferencePage_0);
        this.setPreferenceStore(JDIDebugUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(DebugUIMessages.JavaLogicalStructuresPreferencePage_11);
    }

    public void applyData(Object data) {
        if (data instanceof String) {
            Object[] logicalStructures = this.fLogicalStructuresContentProvider.getElements(null);
            int i = 0;
            int length = logicalStructures.length;
            while (i < length) {
                JavaLogicalStructure javaLogicalStructure = (JavaLogicalStructure)logicalStructures[i];
                if (((String)data).compareToIgnoreCase(javaLogicalStructure.getId() + javaLogicalStructure.getDescription() + javaLogicalStructure.hashCode()) == 0) {
                    this.fLogicalStructuresViewer.setSelection((ISelection)new StructuredSelection(logicalStructures[i]));
                    return;
                }
                ++i;
            }
        } else {
            super.applyData(data);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.JAVA_LOGICAL_STRUCTURES_PAGE);
    }

    protected Control createContents(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)2, (int)1, (int)1808, (int)0, (int)2);
        this.createTable(comp);
        this.createTableButtons(comp);
        this.createSourceViewer(comp);
        this.noDefaultAndApplyButton();
        return comp;
    }

    public void createSourceViewer(Composite parent) {
        SWTFactory.createWrapLabel((Composite)parent, (String)DebugUIMessages.JavaLogicalStructuresPreferencePage_12, (int)2, (int)300);
        this.fCodeViewer = new JDISourceViewer(parent, null, 0x2000B00);
        JavaTextTools tools = JDIDebugUIPlugin.getDefault().getJavaTextTools();
        Document document = new Document();
        tools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        this.fCodeViewer.configure((SourceViewerConfiguration)new DisplayViewerConfiguration());
        this.fCodeViewer.setEditable(false);
        this.fCodeViewer.setDocument((IDocument)document);
        Control control = this.fCodeViewer.getControl();
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        control.setLayoutData((Object)gd);
    }

    private void createTableButtons(Composite container) {
        Composite buttonContainer = SWTFactory.createComposite((Composite)container, (Font)container.getFont(), (int)1, (int)1, (int)2, (int)1, (int)0);
        this.fAddLogicalStructureButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)DebugUIMessages.JavaLogicalStructuresPreferencePage_2, (String)DebugUIMessages.JavaLogicalStructuresPreferencePage_3, null);
        this.fAddLogicalStructureButton.addListener(13, (Listener)this);
        this.fEditLogicalStructureButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)DebugUIMessages.JavaLogicalStructuresPreferencePage_4, (String)DebugUIMessages.JavaLogicalStructuresPreferencePage_5, null);
        this.fEditLogicalStructureButton.addListener(13, (Listener)this);
        this.fRemoveLogicalStructureButton = SWTFactory.createPushButton((Composite)buttonContainer, (String)DebugUIMessages.JavaLogicalStructuresPreferencePage_6, (String)DebugUIMessages.JavaLogicalStructuresPreferencePage_7, null);
        this.fRemoveLogicalStructureButton.addListener(13, (Listener)this);
        this.selectionChanged((IStructuredSelection)this.fLogicalStructuresViewer.getSelection());
    }

    private void createTable(Composite parent) {
        SWTFactory.createWrapLabel((Composite)parent, (String)DebugUIMessages.JavaLogicalStructuresPreferencePage_1, (int)2, (int)300);
        this.fLogicalStructuresViewer = new TableViewer(parent, 68354);
        Table table = (Table)this.fLogicalStructuresViewer.getControl();
        GridData gd = new GridData(768);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(10);
        table.setLayoutData((Object)gd);
        table.setFont(parent.getFont());
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fLogicalStructuresViewer.setColumnProperties(fTableColumnProperties);
        int i = 0;
        while (i < this.fTableColumnHeaders.length) {
            tableLayout.addColumnData(this.fTableColumnLayouts[i]);
            TableColumn column = new TableColumn(table, 0, i);
            column.setResizable(this.fTableColumnLayouts[i].resizable);
            column.setText(this.fTableColumnHeaders[i]);
            ++i;
        }
        this.fLogicalStructuresContentProvider = new LogicalStructuresListViewerContentProvider();
        this.fLogicalStructuresViewer.setContentProvider((IContentProvider)this.fLogicalStructuresContentProvider);
        this.fLogicalStructuresViewer.setLabelProvider((IBaseLabelProvider)new LogicalStructuresListViewerLabelProvider());
        this.fLogicalStructuresViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fLogicalStructuresViewer.setInput((Object)this);
        this.fLogicalStructuresViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)JavaLogicalStructuresPreferencePage.this.fLogicalStructuresViewer.getSelection();
                if (selection.size() == 1 && !((JavaLogicalStructure)selection.getFirstElement()).isContributed()) {
                    JavaLogicalStructuresPreferencePage.this.editLogicalStructure();
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && JavaLogicalStructuresPreferencePage.this.fRemoveLogicalStructureButton.isEnabled()) {
                    JavaLogicalStructuresPreferencePage.this.removeLogicalStrutures();
                }
            }
        });
        this.fLogicalStructuresViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer iViewer, Object e1, Object e2) {
                String type2;
                if (e1 == null) {
                    return -1;
                }
                if (e2 == null) {
                    return 1;
                }
                String type1 = ((JavaLogicalStructure)e1).getQualifiedTypeName();
                int index = type1.lastIndexOf(46) + 1;
                if (index > 0) {
                    type1 = type1.substring(index);
                }
                if ((index = (type2 = ((JavaLogicalStructure)e2).getQualifiedTypeName()).lastIndexOf(46) + 1) > 0) {
                    type2 = type2.substring(index);
                }
                return type1.compareToIgnoreCase(type2);
            }
        });
    }

    public void init(IWorkbench workbench) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        }
    }

    private void selectionChanged(IStructuredSelection structuredSelection) {
        int size = structuredSelection.size();
        if (size == 0) {
            this.fEditLogicalStructureButton.setEnabled(false);
            this.fRemoveLogicalStructureButton.setEnabled(false);
            this.refreshCodeViewer(null);
        } else {
            JavaLogicalStructure structure = (JavaLogicalStructure)structuredSelection.getFirstElement();
            this.fEditLogicalStructureButton.setEnabled(size == 1 && !structure.isContributed());
            boolean removeEnabled = true;
            Iterator iter = structuredSelection.iterator();
            while (iter.hasNext()) {
                if (!((JavaLogicalStructure)iter.next()).isContributed()) continue;
                removeEnabled = false;
            }
            this.fRemoveLogicalStructureButton.setEnabled(removeEnabled);
            this.refreshCodeViewer(structure);
        }
    }

    private void refreshCodeViewer(JavaLogicalStructure structure) {
        StringBuilder buffer = new StringBuilder();
        if (structure != null) {
            String snippet = structure.getValue();
            if (snippet != null) {
                buffer.append(snippet);
            } else {
                String[][] variables = structure.getVariables();
                int i = 0;
                while (i < variables.length) {
                    buffer.append(variables[i][0]);
                    buffer.append(" = ");
                    buffer.append(variables[i][1]);
                    if (buffer.charAt(buffer.length() - 1) != '\n') {
                        buffer.append('\n');
                    }
                    ++i;
                }
            }
        }
        if (this.fCodeViewer != null) {
            this.fCodeViewer.getDocument().set(buffer.toString());
        }
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.fAddLogicalStructureButton) {
            this.addLogicalStructure();
        } else if (source == this.fEditLogicalStructureButton) {
            this.editLogicalStructure();
        } else if (source == this.fRemoveLogicalStructureButton) {
            this.removeLogicalStrutures();
        }
    }

    protected void addLogicalStructure() {
        JavaLogicalStructure logicalStructure = new JavaLogicalStructure("", true, "", "", (String[][])new String[0][]);
        if (new EditLogicalStructureDialog(this.getShell(), logicalStructure).open() == 0) {
            this.fLogicalStructuresContentProvider.add(logicalStructure);
            this.fLogicalStructuresViewer.refresh();
            this.fLogicalStructuresViewer.setSelection((ISelection)new StructuredSelection((Object)logicalStructure));
        }
    }

    protected void editLogicalStructure() {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.fLogicalStructuresViewer.getSelection();
        if (structuredSelection.size() == 1) {
            JavaLogicalStructure logicalStructure = (JavaLogicalStructure)structuredSelection.getFirstElement();
            new EditLogicalStructureDialog(this.getShell(), logicalStructure).open();
            this.fLogicalStructuresContentProvider.refresh(logicalStructure);
            this.fLogicalStructuresViewer.refresh();
            this.refreshCodeViewer(logicalStructure);
        }
    }

    protected void removeLogicalStrutures() {
        IStructuredSelection selection = (IStructuredSelection)this.fLogicalStructuresViewer.getSelection();
        if (selection.size() > 0) {
            List selectedElements = selection.toList();
            Object[] elements = this.fLogicalStructuresContentProvider.getElements(null);
            Object newSelectedElement = null;
            int i = 0;
            while (i < elements.length) {
                if (selectedElements.contains(elements[i])) break;
                newSelectedElement = elements[i];
                ++i;
            }
            this.fLogicalStructuresContentProvider.remove(((IStructuredSelection)this.fLogicalStructuresViewer.getSelection()).toList());
            this.fLogicalStructuresViewer.refresh();
            if (newSelectedElement == null) {
                Object[] newElements = this.fLogicalStructuresContentProvider.getElements(null);
                if (newElements.length > 0) {
                    this.fLogicalStructuresViewer.setSelection((ISelection)new StructuredSelection(newElements[0]));
                }
            } else {
                this.fLogicalStructuresViewer.setSelection((ISelection)new StructuredSelection(newSelectedElement));
            }
        }
    }

    public boolean performOk() {
        if (this.fCodeViewer != null) {
            this.fLogicalStructuresContentProvider.saveUserDefinedJavaLogicalStructures();
            this.fCodeViewer.dispose();
        }
        return super.performOk();
    }

    public boolean performCancel() {
        if (this.fCodeViewer != null) {
            this.fCodeViewer.dispose();
        }
        return super.performCancel();
    }

    public class LogicalStructuresListViewerContentProvider
    implements IStructuredContentProvider {
        private final List<JavaLogicalStructure> fLogicalStructures = new ArrayList<JavaLogicalStructure>();

        LogicalStructuresListViewerContentProvider() {
            JavaLogicalStructure[] logicalStructures = JavaLogicalStructures.getJavaLogicalStructures();
            int i = 0;
            while (i < logicalStructures.length) {
                this.add(logicalStructures[i]);
                ++i;
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.fLogicalStructures.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void add(JavaLogicalStructure logicalStructure) {
            int i = 0;
            int length = this.fLogicalStructures.size();
            while (i < length) {
                if (!this.greaterThan(logicalStructure, this.fLogicalStructures.get(i))) {
                    this.fLogicalStructures.add(i, logicalStructure);
                    return;
                }
                ++i;
            }
            this.fLogicalStructures.add(logicalStructure);
        }

        private boolean greaterThan(JavaLogicalStructure logicalStructure1, JavaLogicalStructure logicalStructure2) {
            int res = logicalStructure1.getQualifiedTypeName().compareToIgnoreCase(logicalStructure2.getQualifiedTypeName());
            if (res != 0) {
                return res > 0;
            }
            res = logicalStructure1.getDescription().compareToIgnoreCase(logicalStructure2.getDescription());
            if (res != 0) {
                return res > 0;
            }
            return logicalStructure1.hashCode() > logicalStructure2.hashCode();
        }

        public void remove(List<JavaLogicalStructure> list) {
            this.fLogicalStructures.removeAll(list);
        }

        public void refresh(JavaLogicalStructure logicalStructure) {
            this.fLogicalStructures.remove(logicalStructure);
            this.add(logicalStructure);
        }

        public void saveUserDefinedJavaLogicalStructures() {
            ArrayList<JavaLogicalStructure> logicalStructures = new ArrayList<JavaLogicalStructure>();
            for (JavaLogicalStructure logicalStructure : this.fLogicalStructures) {
                if (logicalStructure.isContributed()) continue;
                logicalStructures.add(logicalStructure);
            }
            JavaLogicalStructures.setUserDefinedJavaLogicalStructures((JavaLogicalStructure[])logicalStructures.toArray(new JavaLogicalStructure[logicalStructures.size()]));
        }
    }

    public class LogicalStructuresListViewerLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            JavaLogicalStructure logicalStructure = (JavaLogicalStructure)element;
            StringBuilder buffer = new StringBuilder();
            if (columnIndex == 0) {
                String qualifiedName = logicalStructure.getQualifiedTypeName();
                int index = qualifiedName.lastIndexOf(46) + 1;
                String simpleName = qualifiedName.substring(index);
                buffer.append(simpleName);
                if (index > 0) {
                    buffer.append(" (").append(logicalStructure.getQualifiedTypeName()).append(')');
                }
            } else if (columnIndex == 1) {
                buffer.append(logicalStructure.getDescription());
                String pluginId = logicalStructure.getContributingPluginId();
                if (pluginId != null) {
                    buffer.append(NLS.bind((String)DebugUIMessages.JavaLogicalStructuresPreferencePage_8, (Object)pluginId));
                }
            }
            return buffer.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

