/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.eresource.CDOFileResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.internal.ui.actions.ResourceNodeAction;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.editor.CDOLobEditorInput;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;

public final class OpenResourceEditorAction
extends ResourceNodeAction {
    private static final String TITLE = Messages.getString("OpenResourceEditorAction.0");
    private static final String TOOL_TIP = Messages.getString("OpenResourceEditorAction.1");
    private static final String FILE_TITLE = Messages.getString("OpenFileEditorAction.0");
    private static final String FILE_TOOL_TIP = Messages.getString("OpenFileEditorAction.1");

    public OpenResourceEditorAction(IWorkbenchPage page, CDOResourceLeaf resource) {
        super(page, resource instanceof CDOResource ? TITLE : FILE_TITLE, resource instanceof CDOResource ? TOOL_TIP : FILE_TOOL_TIP, null, (CDOResourceNode)resource);
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        final CDOResourceLeaf resource = (CDOResourceLeaf)this.getResourceNode();
        final IWorkbenchPage page = this.getPage();
        if (resource instanceof CDOResource) {
            CDOView view = resource.cdoView();
            String resourcePath = resource.getPath();
            CDOEditorUtil.openEditor(page, view, resourcePath);
        } else if (resource instanceof CDOFileResource) {
            Display display = page.getWorkbenchWindow().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        CDOLobEditorInput input = new CDOLobEditorInput(resource);
                        page.openEditor((IEditorInput)input, "org.eclipse.ui.DefaultTextEditor");
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                    }
                }
            });
        }
    }
}

