/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.ui.internal.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.internal.view.task.TaskViewActionStateRules;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public final class TreeViewerDoubleClickListener
implements IDoubleClickListener {
    private final String commandId;
    private final TreeViewer treeViewer;

    public TreeViewerDoubleClickListener(String commandId, TreeViewer treeViewer) {
        this.commandId = (String)Preconditions.checkNotNull((Object)commandId);
        this.treeViewer = (TreeViewer)Preconditions.checkNotNull((Object)treeViewer);
    }

    public void doubleClick(DoubleClickEvent event) {
        NodeSelection nodeSelection = NodeSelection.from(this.treeViewer.getSelection());
        if (this.isEnabledFor(nodeSelection)) {
            this.run();
        } else if (nodeSelection.isSingleSelection()) {
            Object selected = nodeSelection.toList().get(0);
            IContentProvider provider = this.treeViewer.getContentProvider();
            if (provider instanceof ITreeContentProvider && ((ITreeContentProvider)provider).hasChildren(selected)) {
                if (this.treeViewer.getExpandedState(selected)) {
                    this.treeViewer.collapseToLevel(selected, -1);
                } else {
                    this.treeViewer.expandToLevel(selected, 1);
                }
            }
        }
    }

    private boolean isEnabledFor(NodeSelection node) {
        return TaskViewActionStateRules.taskScopedTaskExecutionActionsEnablement(node).asBoolean();
    }

    private void run() {
        try {
            this.getHandlerService().executeCommand(this.commandId, null);
        }
        catch (Exception e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot execute command '%s'.", this.commandId), (Throwable)e);
        }
    }

    private IHandlerService getHandlerService() {
        return (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
    }
}

