/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support.conversion;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.support.conversion.StringToObjectConverter;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

class FallbackStringToObjectConverter
implements StringToObjectConverter {
    private static final Function<String, Object> NULL_EXECUTABLE = source -> source;
    private static final ConcurrentHashMap<Class<?>, Function<String, @Nullable Object>> factoryExecutableCache = new ConcurrentHashMap(64);

    FallbackStringToObjectConverter() {
    }

    @Override
    public boolean canConvertTo(Class<?> targetType) {
        return FallbackStringToObjectConverter.findFactoryExecutable(targetType) != NULL_EXECUTABLE;
    }

    @Override
    public @Nullable Object convert(String source, Class<?> targetType) throws Exception {
        Function<String, @Nullable Object> executable = FallbackStringToObjectConverter.findFactoryExecutable(targetType);
        Preconditions.condition(executable != NULL_EXECUTABLE, "Illegal state: convert() must not be called if canConvert() returned false");
        return executable.apply(source);
    }

    private static Function<String, @Nullable Object> findFactoryExecutable(Class<?> targetType) {
        return factoryExecutableCache.computeIfAbsent(targetType, type -> {
            Function<String, @Nullable Object> factory = FallbackStringToObjectConverter.findFactoryExecutable(type, String.class);
            if (factory != null) {
                return factory;
            }
            factory = FallbackStringToObjectConverter.findFactoryExecutable(type, CharSequence.class);
            if (factory != null) {
                return factory;
            }
            return NULL_EXECUTABLE;
        });
    }

    private static @Nullable Function<String, @Nullable Object> findFactoryExecutable(Class<?> targetType, Class<?> parameterType) {
        Method factoryMethod = FallbackStringToObjectConverter.findFactoryMethod(targetType, parameterType);
        if (factoryMethod != null) {
            return source -> ReflectionSupport.invokeMethod(factoryMethod, null, source);
        }
        Constructor<?> constructor = FallbackStringToObjectConverter.findFactoryConstructor(targetType, parameterType);
        if (constructor != null) {
            return source -> ReflectionUtils.newInstance(constructor, source);
        }
        return null;
    }

    private static @Nullable Method findFactoryMethod(Class<?> targetType, Class<?> parameterType) {
        List<Method> factoryMethods = ReflectionSupport.findMethods(targetType, new IsFactoryMethod(targetType, parameterType), HierarchyTraversalMode.BOTTOM_UP);
        if (factoryMethods.size() == 1) {
            return factoryMethods.get(0);
        }
        return null;
    }

    private static @Nullable Constructor<?> findFactoryConstructor(Class<?> targetType, Class<?> parameterType) {
        List<Constructor<?>> constructors = ReflectionUtils.findConstructors(targetType, new IsFactoryConstructor(targetType, parameterType));
        if (constructors.size() == 1) {
            return constructors.get(0);
        }
        return null;
    }

    private static boolean isFactoryCandidate(Executable executable, Class<?> parameterType) {
        return ModifierSupport.isNotPrivate(executable) && executable.getParameterCount() == 1 && executable.getParameterTypes()[0] == parameterType;
    }

    record IsFactoryMethod(Class<?> targetType, Class<?> parameterType) implements Predicate<Method>
    {
        @Override
        public boolean test(Method method) {
            if (!method.getReturnType().equals(this.targetType)) {
                return false;
            }
            if (ModifierSupport.isNotStatic(method)) {
                return false;
            }
            return FallbackStringToObjectConverter.isFactoryCandidate(method, this.parameterType);
        }
    }

    record IsFactoryConstructor(Class<?> targetType, Class<?> parameterType) implements Predicate<Constructor<?>>
    {
        @Override
        public boolean test(Constructor<?> constructor) {
            if (!constructor.getDeclaringClass().equals(this.targetType)) {
                return false;
            }
            return FallbackStringToObjectConverter.isFactoryCandidate(constructor, this.parameterType);
        }
    }
}

