/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j;

import com.google.gson.annotations.JsonAdapter;
import java.util.List;
import org.eclipse.lsp4j.DiagnosticCodeDescription;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DiagnosticTag;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.json.adapters.JsonElementTypeAdapter;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class Diagnostic {
    @NonNull
    private Range range;
    private DiagnosticSeverity severity;
    private Either<String, Integer> code;
    private DiagnosticCodeDescription codeDescription;
    private String source;
    @NonNull
    private String message;
    private List<DiagnosticTag> tags;
    private List<DiagnosticRelatedInformation> relatedInformation;
    @JsonAdapter(value=JsonElementTypeAdapter.Factory.class)
    private Object data;

    public Diagnostic() {
    }

    public Diagnostic(@NonNull Range range, @NonNull String message) {
        this.range = Preconditions.checkNotNull(range, "range");
        this.message = Preconditions.checkNotNull(message, "message");
    }

    public Diagnostic(@NonNull Range range, @NonNull String message, DiagnosticSeverity severity, String source) {
        this(range, message);
        this.severity = severity;
        this.source = source;
    }

    public Diagnostic(@NonNull Range range, @NonNull String message, DiagnosticSeverity severity, String source, String code) {
        this(range, message, severity, source);
        this.setCode(code);
    }

    @NonNull
    public Range getRange() {
        return this.range;
    }

    public void setRange(@NonNull Range range) {
        this.range = Preconditions.checkNotNull(range, "range");
    }

    public DiagnosticSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(DiagnosticSeverity severity) {
        this.severity = severity;
    }

    public Either<String, Integer> getCode() {
        return this.code;
    }

    public void setCode(Either<String, Integer> code) {
        this.code = code;
    }

    public void setCode(String code) {
        if (code == null) {
            this.code = null;
            return;
        }
        this.code = Either.forLeft(code);
    }

    public void setCode(Integer code) {
        if (code == null) {
            this.code = null;
            return;
        }
        this.code = Either.forRight(code);
    }

    public DiagnosticCodeDescription getCodeDescription() {
        return this.codeDescription;
    }

    public void setCodeDescription(DiagnosticCodeDescription codeDescription) {
        this.codeDescription = codeDescription;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @NonNull
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@NonNull String message) {
        this.message = Preconditions.checkNotNull(message, "message");
    }

    public List<DiagnosticTag> getTags() {
        return this.tags;
    }

    public void setTags(List<DiagnosticTag> tags) {
        this.tags = tags;
    }

    public List<DiagnosticRelatedInformation> getRelatedInformation() {
        return this.relatedInformation;
    }

    public void setRelatedInformation(List<DiagnosticRelatedInformation> relatedInformation) {
        this.relatedInformation = relatedInformation;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder(this);
        b.add("range", this.range);
        b.add("severity", (Object)this.severity);
        b.add("code", this.code);
        b.add("codeDescription", this.codeDescription);
        b.add("source", this.source);
        b.add("message", this.message);
        b.add("tags", this.tags);
        b.add("relatedInformation", this.relatedInformation);
        b.add("data", this.data);
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Diagnostic other = (Diagnostic)obj;
        if (this.range == null ? other.range != null : !this.range.equals(other.range)) {
            return false;
        }
        if (this.severity == null ? other.severity != null : !this.severity.equals((Object)other.severity)) {
            return false;
        }
        if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
            return false;
        }
        if (this.codeDescription == null ? other.codeDescription != null : !this.codeDescription.equals(other.codeDescription)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        if (this.relatedInformation == null ? other.relatedInformation != null : !this.relatedInformation.equals(other.relatedInformation)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.codeDescription == null ? 0 : this.codeDescription.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (this.relatedInformation == null ? 0 : this.relatedInformation.hashCode());
        return 31 * result + (this.data == null ? 0 : this.data.hashCode());
    }
}

