/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.RecordComponent;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class RecordComponentBinding
extends VariableBinding {
    public ReferenceBinding declaringRecord;
    TypeBinding explicitType;

    public RecordComponentBinding(ReferenceBinding declaringRecord, RecordComponent declaration, TypeBinding type, int modifiers) {
        super(declaration.name, type, modifiers, null);
        this.declaringRecord = declaringRecord;
        declaration.binding = this;
    }

    public RecordComponentBinding(char[] name, TypeBinding type, int modifiers, ReferenceBinding declaringClass) {
        super(name, type, modifiers, null);
        this.declaringRecord = declaringClass;
    }

    @Override
    public final int kind() {
        return 131072;
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.declaringRecord.computeUniqueKey(false));
        buffer.append('#');
        buffer.append(this.name);
        int length = buffer.length();
        char[] uniqueKey = new char[length];
        buffer.getChars(0, length, uniqueKey, 0);
        return uniqueKey;
    }

    public char[] genericSignature() {
        if ((this.modifiers & 0x40000000) == 0) {
            return null;
        }
        return this.type.genericTypeSignature();
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        RecordComponentBinding originalRecordComponentBinding = this.original();
        ReferenceBinding declaringRecordBinding = originalRecordComponentBinding.declaringRecord;
        if (declaringRecordBinding == null) {
            return Binding.NO_ANNOTATIONS;
        }
        return declaringRecordBinding.retrieveAnnotations(originalRecordComponentBinding);
    }

    @Override
    public long getAnnotationTagBits() {
        RecordComponentBinding originalRecordComponentBinding = this.original();
        if ((originalRecordComponentBinding.extendedTagBits & 0x20) == 0 && originalRecordComponentBinding.declaringRecord instanceof SourceTypeBinding) {
            ClassScope scope = ((SourceTypeBinding)originalRecordComponentBinding.declaringRecord).scope;
            if (scope == null) {
                this.extendedTagBits |= 0xE0;
                return 0L;
            }
            TypeDeclaration typeDecl = scope.referenceContext;
            RecordComponent recordComponent = typeDecl.declarationOf(originalRecordComponentBinding);
            if (recordComponent != null) {
                ASTNode.resolveAnnotations((BlockScope)typeDecl.initializerScope, recordComponent.annotations, originalRecordComponentBinding);
            }
        }
        return originalRecordComponentBinding.tagBits;
    }

    @Override
    public void fillInDefaultNonNullness(AbstractVariableDeclaration sourceField, Scope scope) {
        this.explicitType = this.type;
        super.fillInDefaultNonNullness(sourceField, scope);
    }

    @Override
    public ReferenceBinding getDeclaringClass() {
        return this.declaringRecord;
    }

    public RecordComponentBinding original() {
        return this;
    }

    @Override
    public void setAnnotations(AnnotationBinding[] annotations, boolean forceStore) {
        this.declaringRecord.storeAnnotations(this, annotations, forceStore);
    }

    public RecordComponent sourceRecordComponent() {
        ReferenceBinding referenceBinding = this.declaringRecord;
        if (referenceBinding instanceof SourceTypeBinding) {
            SourceTypeBinding sourceType = (SourceTypeBinding)referenceBinding;
            RecordComponent[] recordComponentArray = sourceType.scope.referenceContext.recordComponents;
            int n = sourceType.scope.referenceContext.recordComponents.length;
            int n2 = 0;
            while (n2 < n) {
                RecordComponent component = recordComponentArray[n2];
                if (this == component.binding) {
                    return component;
                }
                ++n2;
            }
        }
        return null;
    }
}

