/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks.maven;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;

public class ConsoleTransferListener
extends AbstractTransferListener {
    private final PrintStream out;

    public ConsoleTransferListener(PrintStream out) {
        this.out = out != null ? out : System.out;
    }

    public void transferInitiated(TransferEvent event) {
        String message = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        this.out.println(message + ": " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName());
    }

    public void transferProgressed(TransferEvent event) {
    }

    public void transferSucceeded(TransferEvent event) {
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        if (contentLength >= 0L) {
            String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
            String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
            Object throughput = "";
            long duration = System.currentTimeMillis() - resource.getTransferStartTime();
            if (duration > 0L) {
                long bytes = contentLength - resource.getResumeOffset();
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)bytes / 1024.0 / ((double)duration / 1000.0);
                throughput = " at " + format.format(kbPerSec) + " KB/sec";
            }
            this.out.println(type + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + (String)throughput + ")");
        }
    }

    public void transferFailed(TransferEvent event) {
        TransferResource resource = event.getResource();
        String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Failed Upload" : "Failed Download";
        this.out.println(type + ": " + resource.getRepositoryUrl() + resource.getResourceName());
        if (!(event.getException() instanceof MetadataNotFoundException)) {
            event.getException().printStackTrace(this.out);
        }
    }

    public void transferCorrupted(TransferEvent event) {
        event.getException().printStackTrace(this.out);
    }

    protected long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }
}

