/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.lcdsl.tasks.p2;

import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.library.build.lcdsl.tasks.p2.TaskGenFeatureFromLcDsl;
import org.eclipse.tea.library.build.model.PlatformTriple;
import org.eclipse.tea.library.build.tasks.jar.TaskRunFeaturePluginJarExport;
import org.eclipse.tea.library.build.tasks.p2.TaskGenPropertiesFiles;
import org.eclipse.tea.library.build.tasks.p2.TaskPublishProductUpdateSite;
import org.eclipse.tea.library.build.tasks.p2.TaskRunProductExport;

public abstract class AbstractProductBuild {
    private final String featureBundle;
    private final String productBundle;
    private final String productDefinition;
    private final boolean needProperties;

    protected AbstractProductBuild(String featureBundle, String productBundle, String productDefinition, boolean needProperties) {
        this.featureBundle = featureBundle;
        this.productBundle = productBundle;
        this.productDefinition = productDefinition;
        this.needProperties = needProperties;
    }

    public TaskGenFeatureFromLcDsl createTaskGenFeatureXml(boolean errorIfNotExist) {
        return new TaskGenFeatureFromLcDsl(this.featureBundle, errorIfNotExist);
    }

    protected TaskPublishProductUpdateSite createTaskPublishProductUpdateSite(String siteName) {
        return new TaskPublishProductUpdateSite(siteName, this.productBundle, this.productDefinition, true);
    }

    public void addUpdateSiteTasks(TaskExecutionContext c, String[] updateSites) {
        c.addTask((Object)this.createTaskGenFeatureXml(true));
        if (this.needProperties) {
            c.addTask((Object)new TaskGenPropertiesFiles(this.featureBundle));
        }
        c.addTask((Object)new TaskRunFeaturePluginJarExport(this.featureBundle));
        String[] stringArray = updateSites;
        int n = updateSites.length;
        int n2 = 0;
        while (n2 < n) {
            String siteName = stringArray[n2];
            c.addTask((Object)this.createTaskPublishProductUpdateSite(siteName));
            ++n2;
        }
    }

    public void addProductTasks(TaskExecutionContext c, String updateSite) {
        this.addProductTasks(c, updateSite, true);
    }

    public TaskRunProductExport addProductTasks(TaskExecutionContext c, String updateSite, boolean zip) {
        TaskRunProductExport task = this.createProductExportTask(updateSite, zip);
        c.addTask((Object)task);
        return task;
    }

    public TaskRunProductExport createProductExportTask(String updateSite, boolean zip) {
        TaskRunProductExport task = new TaskRunProductExport(updateSite, this.productBundle, this.productDefinition, zip);
        task.setPlatformsToBuild(this.getPlatformsToBuild());
        return task;
    }

    public PlatformTriple[] getPlatformsToBuild() {
        return new PlatformTriple[]{PlatformTriple.WIN64, PlatformTriple.LINUX64};
    }

    public String getName() {
        String name = this.getClass().getSimpleName();
        if (name.isEmpty()) {
            name = this.getClass().getName();
        }
        return name;
    }

    public String getFeatureBundleName() {
        return this.featureBundle;
    }

    public String getProductBundleName() {
        return this.productBundle;
    }

    public String getOfficialName() {
        return this.getClass().getSimpleName();
    }

    public String getDescription() {
        return this.getOfficialName();
    }
}

