/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks;

import java.util.Arrays;
import java.util.List;
import javax.inject.Named;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.tea.core.services.TaskProgressTracker;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.chain.TeaBuildChain;
import org.eclipse.tea.library.build.config.TeaBuildConfig;
import org.eclipse.tea.library.build.model.WorkspaceBuild;

@Named(value="Build all projects")
public class TaskBuildWorkspace {
    @Execute
    public IStatus build(IEclipseContext taskContext, TaskingLog log, TaskProgressTracker tracker, WorkspaceBuild wb, TeaBuildConfig config) throws Exception {
        TeaBuildChain chain = TeaBuildChain.make(taskContext, Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
        this.setWorkspaceBuildOrder(chain.getBuildOrder());
        IStatus result = chain.execute(tracker, config.failureThreshold);
        if (result.getSeverity() > 2) {
            log.error("Errors during build: " + this.formatStatus(result, ""));
        }
        return result;
    }

    private String formatStatus(IStatus status, String indent) {
        StringBuilder builder = new StringBuilder();
        builder.append(indent).append(this.formatSeverity(status.getSeverity())).append(": ");
        if (status.getPlugin() != null) {
            builder.append(status.getPlugin()).append(": ");
        }
        if (status.getCode() != 0) {
            builder.append("code=").append(status.getCode()).append(": ");
        }
        builder.append(status.getMessage());
        if (status.getException() != null) {
            builder.append(" (").append(status.getException().toString()).append(")");
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            if (child.getSeverity() > 2) {
                builder.append('\n').append(this.formatStatus(child, indent + "  "));
            }
            ++n2;
        }
        return builder.toString();
    }

    private String formatSeverity(int severity) {
        if (severity == 0) {
            return "OK";
        }
        if (severity == 4) {
            return "ERROR";
        }
        if (severity == 2) {
            return "WARNING";
        }
        if (severity == 1) {
            return "INFO";
        }
        if (severity == 8) {
            return "CANCEL";
        }
        return "severity=" + severity;
    }

    private void setWorkspaceBuildOrder(List<String> buildOrder) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        description.setBuildOrder(buildOrder == null ? null : buildOrder.toArray(new String[buildOrder.size()]));
        description.setMaxBuildIterations(3 * buildOrder.size());
        workspace.setDescription(description);
    }
}

