/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.chain.plugin;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.tea.core.services.TaskProgressTracker;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.chain.TeaBuildChain;
import org.eclipse.tea.library.build.chain.TeaBuildElement;
import org.eclipse.tea.library.build.chain.plugin.TeaBuildPluginElement;
import org.eclipse.tea.library.build.config.TeaBuildConfig;
import org.eclipse.tea.library.build.model.PluginData;
import org.eclipse.tea.library.build.services.TeaBuildVisitor;
import org.eclipse.tea.library.build.services.TeaElementFailurePolicy;
import org.eclipse.tea.library.build.util.TeaBuildUtil;
import org.osgi.service.component.annotations.Component;

@Component
public class TeaBuildPluginVisitor
implements TeaBuildVisitor {
    private TaskingLog log;
    private TeaBuildConfig config;
    private TaskProgressTracker tracker;

    @Execute
    public void prepare(TaskingLog log, TaskProgressTracker tracker, TeaBuildConfig config) {
        this.log = log;
        this.tracker = tracker;
        this.config = config;
    }

    @Override
    public Map<TeaBuildElement, IStatus> visit(List<TeaBuildElement> elements) {
        TreeMap<TeaBuildElement, IStatus> results = new TreeMap<TeaBuildElement, IStatus>();
        if (this.config.batchCompile) {
            Map projects = elements.stream().filter(e -> e instanceof TeaBuildPluginElement).map(e -> (TeaBuildPluginElement)e).collect(Collectors.toMap(e -> ((PluginData)e.getPlugin().getData()).getProject(), Function.identity()));
            this.log.info("compile " + projects.size() + " plugins in group.");
            try {
                TeaBuildUtil.tryCompile(projects.keySet());
                projects.values().stream().forEach(e -> results.put((TeaBuildElement)e, Status.OK_STATUS));
            }
            catch (Exception ex) {
                projects.values().stream().forEach(e -> {
                    Status status = results.put((TeaBuildElement)e, (IStatus)new Status(4, "org.eclipse.tea.library.build", "failed to batch compile group", (Throwable)ex));
                });
            }
        } else {
            for (TeaBuildElement e2 : elements) {
                if (!(e2 instanceof TeaBuildPluginElement)) continue;
                TeaBuildPluginElement p = (TeaBuildPluginElement)e2;
                this.tracker.setTaskName(p.getName());
                if (!p.isAllDependenciesBuilt()) {
                    results.put(p, Status.CANCEL_STATUS);
                    this.log.warn("skipping " + p.getName() + " due to errors in dependencies.");
                    continue;
                }
                IStatus s = TeaBuildUtil.tryCompile(this.log, this.tracker, p, this.config);
                if (s.getSeverity() > 2) {
                    p.error();
                    results.put(p, s);
                    if (TeaBuildChain.getFailurePolicyFor(p) != TeaElementFailurePolicy.FailurePolicy.ABORT_IMMEDIATE) continue;
                    break;
                }
                p.done();
                results.put(p, Status.OK_STATUS);
            }
        }
        return results;
    }
}

